<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* credit/index.html.twig */
class __TwigTemplate_b577385c6cf88062605f36438ab9dd15 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "credit/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "credit/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Gestion des crédits - Red Store";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Gestion des crédits";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .credit-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        margin-bottom: 1.5rem;
    }

    .credit-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--border);
    }

    .credit-amount {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--danger);
    }

    .vente-item, .achat-item {
        padding: 1rem;
        background: var(--bg-secondary);
        border-radius: 0.5rem;
        margin-bottom: 0.75rem;
        border-left: 4px solid var(--primary);
    }

    .stat-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.875rem;
        font-weight: 600;
    }

    .badge-impaye {
        background: #fee2e2;
        color: #991b1b;
    }

    .badge-partiel {
        background: #fef3c7;
        color: #92400e;
    }

    .badge-paye {
        background: #d1fae5;
        color: #065f46;
    }
</style>

<div class=\"d-flex justify-content-between align-items-center mb-4\">
    <div>
        <h2 class=\"mb-0\">Gestion des crédits</h2>
        <p class=\"text-muted mb-0\">Gérez les dettes des clients et des fournisseurs</p>
    </div>
    <div class=\"btn-group\" role=\"group\">
        <a href=\"";
        // line 70
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_index", ["type" => "clients"]);
        yield "\" 
           class=\"btn ";
        // line 71
        yield ((((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 71, $this->source); })()) == "clients")) ? ("btn-primary") : ("btn-outline-primary"));
        yield "\">
            <i class=\"bi bi-people\"></i> Clients
        </a>
        <a href=\"";
        // line 74
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_index", ["type" => "fournisseurs"]);
        yield "\" 
           class=\"btn ";
        // line 75
        yield ((((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 75, $this->source); })()) == "fournisseurs")) ? ("btn-primary") : ("btn-outline-primary"));
        yield "\">
            <i class=\"bi bi-truck\"></i> Fournisseurs
        </a>
        <a href=\"";
        // line 78
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_index", ["type" => "all"]);
        yield "\" 
           class=\"btn ";
        // line 79
        yield ((((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 79, $this->source); })()) == "all")) ? ("btn-primary") : ("btn-outline-primary"));
        yield "\">
            <i class=\"bi bi-list\"></i> Tous
        </a>
    </div>
</div>

<!-- Statistiques globales -->
<div class=\"row mb-4\">
    <div class=\"col-md-6\">
        <div class=\"credit-card\">
            <div class=\"d-flex justify-content-between align-items-center\">
                <div>
                    <h6 class=\"text-muted mb-1\">Total crédits clients</h6>
                    <h3 class=\"mb-0 text-danger\">";
        // line 92
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber((isset($context["totalCreditsClients"]) || array_key_exists("totalCreditsClients", $context) ? $context["totalCreditsClients"] : (function () { throw new RuntimeError('Variable "totalCreditsClients" does not exist.', 92, $this->source); })()), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                </div>
                <div class=\"text-danger\" style=\"font-size: 2.5rem;\">
                    <i class=\"bi bi-arrow-down-circle\"></i>
                </div>
            </div>
        </div>
    </div>
    <div class=\"col-md-6\">
        <div class=\"credit-card\">
            <div class=\"d-flex justify-content-between align-items-center\">
                <div>
                    <h6 class=\"text-muted mb-1\">Total dettes fournisseurs</h6>
                    <h3 class=\"mb-0 text-warning\">";
        // line 105
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber((isset($context["totalDettesFournisseurs"]) || array_key_exists("totalDettesFournisseurs", $context) ? $context["totalDettesFournisseurs"] : (function () { throw new RuntimeError('Variable "totalDettesFournisseurs" does not exist.', 105, $this->source); })()), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                </div>
                <div class=\"text-warning\" style=\"font-size: 2.5rem;\">
                    <i class=\"bi bi-arrow-up-circle\"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Clients avec crédit -->
";
        // line 116
        if (((((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 116, $this->source); })()) == "clients") || ((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 116, $this->source); })()) == "all")) && (Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["clientsAvecCredit"]) || array_key_exists("clientsAvecCredit", $context) ? $context["clientsAvecCredit"] : (function () { throw new RuntimeError('Variable "clientsAvecCredit" does not exist.', 116, $this->source); })())) > 0))) {
            // line 117
            yield "<div class=\"mb-5\">
    <h4 class=\"mb-3\">
        <i class=\"bi bi-people\"></i> Clients avec crédit (";
            // line 119
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["clientsAvecCredit"]) || array_key_exists("clientsAvecCredit", $context) ? $context["clientsAvecCredit"] : (function () { throw new RuntimeError('Variable "clientsAvecCredit" does not exist.', 119, $this->source); })())), "html", null, true);
            yield ")
    </h4>
    
    ";
            // line 122
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["clientsAvecCredit"]) || array_key_exists("clientsAvecCredit", $context) ? $context["clientsAvecCredit"] : (function () { throw new RuntimeError('Variable "clientsAvecCredit" does not exist.', 122, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["item"]) {
                // line 123
                yield "    <div class=\"credit-card\">
        <div class=\"credit-header\">
            <div>
                <h5 class=\"mb-1\">";
                // line 126
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "client", [], "any", false, false, false, 126), "nom", [], "any", false, false, false, 126), "html", null, true);
                yield "</h5>
                <small class=\"text-muted\">";
                // line 127
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "client", [], "any", false, false, false, 127), "telephone", [], "any", false, false, false, 127), "html", null, true);
                yield "</small>
            </div>
            <div class=\"text-end\">
                <div class=\"credit-amount\">";
                // line 130
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["item"], "totalRestant", [], "any", false, false, false, 130), 2, ",", " "), "html", null, true);
                yield " MAD</div>
                <small class=\"text-muted\">Total dû</small>
            </div>
        </div>

        <div class=\"mb-3\">
            <strong>Ventes impayées (";
                // line 136
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["item"], "ventesImpayees", [], "any", false, false, false, 136)), "html", null, true);
                yield "):</strong>
        </div>

        ";
                // line 139
                $context['_parent'] = $context;
                $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, $context["item"], "ventesImpayees", [], "any", false, false, false, 139));
                foreach ($context['_seq'] as $context["_key"] => $context["vente"]) {
                    // line 140
                    yield "        <div class=\"vente-item\">
            <div class=\"d-flex justify-content-between align-items-start mb-2\">
                <div>
                    <strong>Facture #";
                    // line 143
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "numeroFacture", [], "any", false, false, false, 143), "html", null, true);
                    yield "</strong>
                    <br>
                    <small class=\"text-muted\">
                        Date: ";
                    // line 146
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "dateVente", [], "any", false, false, false, 146), "d/m/Y"), "html", null, true);
                    yield "
                        | Total: ";
                    // line 147
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantFinal", [], "any", false, false, false, 147), 2, ",", " "), "html", null, true);
                    yield " MAD
                        | Payé: ";
                    // line 148
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantPaye", [], "any", false, false, false, 148), 2, ",", " "), "html", null, true);
                    yield " MAD
                    </small>
                </div>
                <div class=\"text-end\">
                    <div class=\"credit-amount mb-1\">";
                    // line 152
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 152), 2, ",", " "), "html", null, true);
                    yield " MAD</div>
                    <span class=\"stat-badge badge-";
                    // line 153
                    yield (((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 153) == "impaye")) ? ("impaye") : ("partiel"));
                    yield "\">
                        ";
                    // line 154
                    yield (((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 154) == "impaye")) ? ("Impayé") : ("Partiel"));
                    yield "
                    </span>
                </div>
            </div>
            <button type=\"button\" 
                    class=\"btn btn-sm btn-primary\" 
                    onclick=\"ouvrirModalPaiementClient(";
                    // line 160
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "client", [], "any", false, false, false, 160), "id", [], "any", false, false, false, 160), "html", null, true);
                    yield ", ";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "id", [], "any", false, false, false, 160), "html", null, true);
                    yield ", ";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 160), "html", null, true);
                    yield ")\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
        </div>
        ";
                }
                $_parent = $context['_parent'];
                unset($context['_seq'], $context['_key'], $context['vente'], $context['_parent']);
                $context = array_intersect_key($context, $_parent) + $_parent;
                // line 165
                yield "    </div>
    ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['item'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 167
            yield "</div>
";
        } elseif (((        // line 168
(isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 168, $this->source); })()) == "clients") || ((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 168, $this->source); })()) == "all"))) {
            // line 169
            yield "<div class=\"alert alert-info\">
    <i class=\"bi bi-info-circle\"></i> Aucun client avec crédit en cours.
</div>
";
        }
        // line 173
        yield "
<!-- Fournisseurs avec dette -->
";
        // line 175
        if (((((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 175, $this->source); })()) == "fournisseurs") || ((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 175, $this->source); })()) == "all")) && (Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["fournisseursAvecDette"]) || array_key_exists("fournisseursAvecDette", $context) ? $context["fournisseursAvecDette"] : (function () { throw new RuntimeError('Variable "fournisseursAvecDette" does not exist.', 175, $this->source); })())) > 0))) {
            // line 176
            yield "<div class=\"mb-5\">
    <h4 class=\"mb-3\">
        <i class=\"bi bi-truck\"></i> Fournisseurs avec dette (";
            // line 178
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["fournisseursAvecDette"]) || array_key_exists("fournisseursAvecDette", $context) ? $context["fournisseursAvecDette"] : (function () { throw new RuntimeError('Variable "fournisseursAvecDette" does not exist.', 178, $this->source); })())), "html", null, true);
            yield ")
    </h4>
    
    ";
            // line 181
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["fournisseursAvecDette"]) || array_key_exists("fournisseursAvecDette", $context) ? $context["fournisseursAvecDette"] : (function () { throw new RuntimeError('Variable "fournisseursAvecDette" does not exist.', 181, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["item"]) {
                // line 182
                yield "    <div class=\"credit-card\">
        <div class=\"credit-header\">
            <div>
                <h5 class=\"mb-1\">";
                // line 185
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "fournisseur", [], "any", false, false, false, 185), "nom", [], "any", false, false, false, 185), "html", null, true);
                yield "</h5>
                <small class=\"text-muted\">
                    ";
                // line 187
                if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "fournisseur", [], "any", false, false, false, 187), "telephones", [], "any", false, false, false, 187)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    // line 188
                    yield "                        ";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "fournisseur", [], "any", false, false, false, 188), "telephones", [], "any", false, false, false, 188), 0, [], "array", false, false, false, 188), "html", null, true);
                    yield "
                    ";
                }
                // line 190
                yield "                </small>
            </div>
            <div class=\"text-end\">
                <div class=\"credit-amount text-warning\">";
                // line 193
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["item"], "totalDette", [], "any", false, false, false, 193), 2, ",", " "), "html", null, true);
                yield " MAD</div>
                <small class=\"text-muted\">Total dû</small>
            </div>
        </div>

        <div class=\"mb-3\">
            <strong>Achats impayés (";
                // line 199
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["item"], "achatsImpayes", [], "any", false, false, false, 199)), "html", null, true);
                yield "):</strong>
        </div>

        ";
                // line 202
                $context['_parent'] = $context;
                $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, $context["item"], "achatsImpayes", [], "any", false, false, false, 202));
                foreach ($context['_seq'] as $context["_key"] => $context["achat"]) {
                    // line 203
                    yield "        <div class=\"achat-item\">
            <div class=\"d-flex justify-content-between align-items-start mb-2\">
                <div>
                    <strong>Facture #";
                    // line 206
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "numeroFacture", [], "any", false, false, false, 206), "html", null, true);
                    yield "</strong>
                    <br>
                    <small class=\"text-muted\">
                        Date: ";
                    // line 209
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "dateAchat", [], "any", false, false, false, 209), "d/m/Y"), "html", null, true);
                    yield "
                        | Total: ";
                    // line 210
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantTotal", [], "any", false, false, false, 210), 2, ",", " "), "html", null, true);
                    yield " MAD
                        | Payé: ";
                    // line 211
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantPaye", [], "method", false, false, false, 211), 2, ",", " "), "html", null, true);
                    yield " MAD
                    </small>
                </div>
                <div class=\"text-end\">
                    <div class=\"credit-amount text-warning mb-1\">";
                    // line 215
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantRestant", [], "any", false, false, false, 215), 2, ",", " "), "html", null, true);
                    yield " MAD</div>
                    <span class=\"stat-badge badge-";
                    // line 216
                    yield (((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 216) == "non_paye")) ? ("impaye") : ("partiel"));
                    yield "\">
                        ";
                    // line 217
                    yield (((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 217) == "non_paye")) ? ("Impayé") : ("Partiel"));
                    yield "
                    </span>
                </div>
            </div>
            <button type=\"button\" 
                    class=\"btn btn-sm btn-warning\" 
                    onclick=\"ouvrirModalPaiementFournisseur(";
                    // line 223
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["item"], "fournisseur", [], "any", false, false, false, 223), "id", [], "any", false, false, false, 223), "html", null, true);
                    yield ", ";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "id", [], "any", false, false, false, 223), "html", null, true);
                    yield ", ";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantRestant", [], "any", false, false, false, 223), "html", null, true);
                    yield ")\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
        </div>
        ";
                }
                $_parent = $context['_parent'];
                unset($context['_seq'], $context['_key'], $context['achat'], $context['_parent']);
                $context = array_intersect_key($context, $_parent) + $_parent;
                // line 228
                yield "    </div>
    ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['item'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 230
            yield "</div>
";
        } elseif (((        // line 231
(isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 231, $this->source); })()) == "fournisseurs") || ((isset($context["type"]) || array_key_exists("type", $context) ? $context["type"] : (function () { throw new RuntimeError('Variable "type" does not exist.', 231, $this->source); })()) == "all"))) {
            // line 232
            yield "<div class=\"alert alert-info\">
    <i class=\"bi bi-info-circle\"></i> Aucun fournisseur avec dette en cours.
</div>
";
        }
        // line 236
        yield "
<!-- Modal Paiement Client -->
<div class=\"modal fade\" id=\"modalPaiementClient\" tabindex=\"-1\">
    <div class=\"modal-dialog\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Ajouter un paiement client</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <form id=\"form-paiement-client\">
                    <input type=\"hidden\" id=\"paiement-client-id\" name=\"client_id\">
                    <input type=\"hidden\" id=\"paiement-vente-id\" name=\"vente_id\">
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant restant</label>
                        <input type=\"text\" id=\"paiement-montant-restant-client\" class=\"form-control\" readonly>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant à payer *</label>
                        <input type=\"number\" id=\"paiement-montant-client\" name=\"montant\" class=\"form-control\" step=\"0.01\" min=\"0.01\" required>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Mode de paiement *</label>
                        <select id=\"paiement-mode-client\" name=\"mode\" class=\"form-select\" required>
                            <option value=\"cash\">Cash</option>
                            <option value=\"carte\">Carte</option>
                            <option value=\"virement\">Virement</option>
                            <option value=\"cheque\">Chèque</option>
                            <option value=\"autre\">Autre</option>
                        </select>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Référence (optionnel)</label>
                        <input type=\"text\" id=\"paiement-reference-client\" name=\"reference\" class=\"form-control\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Date de paiement</label>
                        <input type=\"datetime-local\" id=\"paiement-date-client\" name=\"date\" class=\"form-control\" value=\"";
        // line 278
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "Y-m-d\\TH:i"), "html", null, true);
        yield "\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Notes (optionnel)</label>
                        <textarea id=\"paiement-notes-client\" name=\"notes\" class=\"form-control\" rows=\"3\"></textarea>
                    </div>
                    
                    <button type=\"submit\" class=\"btn btn-primary w-100\">
                        <i class=\"bi bi-check-circle\"></i> Enregistrer le paiement
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Paiement Fournisseur -->
<div class=\"modal fade\" id=\"modalPaiementFournisseur\" tabindex=\"-1\">
    <div class=\"modal-dialog\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Ajouter un paiement fournisseur</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <form id=\"form-paiement-fournisseur\">
                    <input type=\"hidden\" id=\"paiement-fournisseur-id\" name=\"fournisseur_id\">
                    <input type=\"hidden\" id=\"paiement-achat-id\" name=\"achat_id\">
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant restant</label>
                        <input type=\"text\" id=\"paiement-montant-restant-fournisseur\" class=\"form-control\" readonly>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant à payer *</label>
                        <input type=\"number\" id=\"paiement-montant-fournisseur\" name=\"montant\" class=\"form-control\" step=\"0.01\" min=\"0.01\" required>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Mode de paiement *</label>
                        <select id=\"paiement-mode-fournisseur\" name=\"mode\" class=\"form-select\" required>
                            <option value=\"especes\">Espèces</option>
                            <option value=\"virement\">Virement</option>
                            <option value=\"carte\">Carte</option>
                            <option value=\"cheque\">Chèque</option>
                            <option value=\"autre\">Autre</option>
                        </select>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Référence (optionnel)</label>
                        <input type=\"text\" id=\"paiement-reference-fournisseur\" name=\"reference\" class=\"form-control\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Date de paiement</label>
                        <input type=\"datetime-local\" id=\"paiement-date-fournisseur\" name=\"date\" class=\"form-control\" value=\"";
        // line 336
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "Y-m-d\\TH:i"), "html", null, true);
        yield "\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Notes (optionnel)</label>
                        <textarea id=\"paiement-notes-fournisseur\" name=\"notes\" class=\"form-control\" rows=\"3\"></textarea>
                    </div>
                    
                    <button type=\"submit\" class=\"btn btn-warning w-100\">
                        <i class=\"bi bi-check-circle\"></i> Enregistrer le paiement
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function ouvrirModalPaiementClient(clientId, venteId, montantRestant) {
    document.getElementById('paiement-client-id').value = clientId;
    document.getElementById('paiement-vente-id').value = venteId;
    document.getElementById('paiement-montant-restant-client').value = parseFloat(montantRestant).toFixed(2) + ' MAD';
    document.getElementById('paiement-montant-client').value = '';
    document.getElementById('paiement-montant-client').max = montantRestant;
    const modal = new bootstrap.Modal(document.getElementById('modalPaiementClient'));
    modal.show();
}

function ouvrirModalPaiementFournisseur(fournisseurId, achatId, montantRestant) {
    document.getElementById('paiement-fournisseur-id').value = fournisseurId;
    document.getElementById('paiement-achat-id').value = achatId;
    document.getElementById('paiement-montant-restant-fournisseur').value = parseFloat(montantRestant).toFixed(2) + ' MAD';
    document.getElementById('paiement-montant-fournisseur').value = '';
    document.getElementById('paiement-montant-fournisseur').max = montantRestant;
    const modal = new bootstrap.Modal(document.getElementById('modalPaiementFournisseur'));
    modal.show();
}

// Soumettre paiement client
document.getElementById('form-paiement-client')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const data = {
        vente_id: document.getElementById('paiement-vente-id').value,
        montant: parseFloat(document.getElementById('paiement-montant-client').value),
        mode: document.getElementById('paiement-mode-client').value,
        reference: document.getElementById('paiement-reference-client').value || null,
        notes: document.getElementById('paiement-notes-client').value || null,
        date: document.getElementById('paiement-date-client').value,
    };
    
    const clientId = document.getElementById('paiement-client-id').value;
    
    try {
        const response = await fetch(`";
        // line 390
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_client_paiement", ["id" => "PLACEHOLDER"]);
        yield "`.replace('PLACEHOLDER', clientId), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert('Erreur: ' + result.error);
            return;
        }
        
        if (result.success) {
            bootstrap.Modal.getInstance(document.getElementById('modalPaiementClient')).hide();
            location.reload();
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'enregistrement du paiement');
    }
});

// Soumettre paiement fournisseur
document.getElementById('form-paiement-fournisseur')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const data = {
        achat_id: document.getElementById('paiement-achat-id').value,
        montant: parseFloat(document.getElementById('paiement-montant-fournisseur').value),
        mode: document.getElementById('paiement-mode-fournisseur').value,
        reference: document.getElementById('paiement-reference-fournisseur').value || null,
        notes: document.getElementById('paiement-notes-fournisseur').value || null,
        date: document.getElementById('paiement-date-fournisseur').value,
    };
    
    const fournisseurId = document.getElementById('paiement-fournisseur-id').value;
    
    try {
        const response = await fetch(`";
        // line 432
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("credits_fournisseur_paiement", ["id" => "PLACEHOLDER"]);
        yield "`.replace('PLACEHOLDER', fournisseurId), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert('Erreur: ' + result.error);
            return;
        }
        
        if (result.success) {
            bootstrap.Modal.getInstance(document.getElementById('modalPaiementFournisseur')).hide();
            location.reload();
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'enregistrement du paiement');
    }
});
</script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "credit/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  730 => 432,  685 => 390,  628 => 336,  567 => 278,  523 => 236,  517 => 232,  515 => 231,  512 => 230,  505 => 228,  490 => 223,  481 => 217,  477 => 216,  473 => 215,  466 => 211,  462 => 210,  458 => 209,  452 => 206,  447 => 203,  443 => 202,  437 => 199,  428 => 193,  423 => 190,  417 => 188,  415 => 187,  410 => 185,  405 => 182,  401 => 181,  395 => 178,  391 => 176,  389 => 175,  385 => 173,  379 => 169,  377 => 168,  374 => 167,  367 => 165,  352 => 160,  343 => 154,  339 => 153,  335 => 152,  328 => 148,  324 => 147,  320 => 146,  314 => 143,  309 => 140,  305 => 139,  299 => 136,  290 => 130,  284 => 127,  280 => 126,  275 => 123,  271 => 122,  265 => 119,  261 => 117,  259 => 116,  245 => 105,  229 => 92,  213 => 79,  209 => 78,  203 => 75,  199 => 74,  193 => 71,  189 => 70,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Gestion des crédits - Red Store{% endblock %}
{% block page_title %}Gestion des crédits{% endblock %}

{% block content %}
<style>
    .credit-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        margin-bottom: 1.5rem;
    }

    .credit-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--border);
    }

    .credit-amount {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--danger);
    }

    .vente-item, .achat-item {
        padding: 1rem;
        background: var(--bg-secondary);
        border-radius: 0.5rem;
        margin-bottom: 0.75rem;
        border-left: 4px solid var(--primary);
    }

    .stat-badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 1rem;
        font-size: 0.875rem;
        font-weight: 600;
    }

    .badge-impaye {
        background: #fee2e2;
        color: #991b1b;
    }

    .badge-partiel {
        background: #fef3c7;
        color: #92400e;
    }

    .badge-paye {
        background: #d1fae5;
        color: #065f46;
    }
</style>

<div class=\"d-flex justify-content-between align-items-center mb-4\">
    <div>
        <h2 class=\"mb-0\">Gestion des crédits</h2>
        <p class=\"text-muted mb-0\">Gérez les dettes des clients et des fournisseurs</p>
    </div>
    <div class=\"btn-group\" role=\"group\">
        <a href=\"{{ path('credits_index', {'type': 'clients'}) }}\" 
           class=\"btn {{ type == 'clients' ? 'btn-primary' : 'btn-outline-primary' }}\">
            <i class=\"bi bi-people\"></i> Clients
        </a>
        <a href=\"{{ path('credits_index', {'type': 'fournisseurs'}) }}\" 
           class=\"btn {{ type == 'fournisseurs' ? 'btn-primary' : 'btn-outline-primary' }}\">
            <i class=\"bi bi-truck\"></i> Fournisseurs
        </a>
        <a href=\"{{ path('credits_index', {'type': 'all'}) }}\" 
           class=\"btn {{ type == 'all' ? 'btn-primary' : 'btn-outline-primary' }}\">
            <i class=\"bi bi-list\"></i> Tous
        </a>
    </div>
</div>

<!-- Statistiques globales -->
<div class=\"row mb-4\">
    <div class=\"col-md-6\">
        <div class=\"credit-card\">
            <div class=\"d-flex justify-content-between align-items-center\">
                <div>
                    <h6 class=\"text-muted mb-1\">Total crédits clients</h6>
                    <h3 class=\"mb-0 text-danger\">{{ totalCreditsClients|number_format(2, ',', ' ') }} MAD</h3>
                </div>
                <div class=\"text-danger\" style=\"font-size: 2.5rem;\">
                    <i class=\"bi bi-arrow-down-circle\"></i>
                </div>
            </div>
        </div>
    </div>
    <div class=\"col-md-6\">
        <div class=\"credit-card\">
            <div class=\"d-flex justify-content-between align-items-center\">
                <div>
                    <h6 class=\"text-muted mb-1\">Total dettes fournisseurs</h6>
                    <h3 class=\"mb-0 text-warning\">{{ totalDettesFournisseurs|number_format(2, ',', ' ') }} MAD</h3>
                </div>
                <div class=\"text-warning\" style=\"font-size: 2.5rem;\">
                    <i class=\"bi bi-arrow-up-circle\"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Clients avec crédit -->
{% if (type == 'clients' or type == 'all') and clientsAvecCredit|length > 0 %}
<div class=\"mb-5\">
    <h4 class=\"mb-3\">
        <i class=\"bi bi-people\"></i> Clients avec crédit ({{ clientsAvecCredit|length }})
    </h4>
    
    {% for item in clientsAvecCredit %}
    <div class=\"credit-card\">
        <div class=\"credit-header\">
            <div>
                <h5 class=\"mb-1\">{{ item.client.nom }}</h5>
                <small class=\"text-muted\">{{ item.client.telephone }}</small>
            </div>
            <div class=\"text-end\">
                <div class=\"credit-amount\">{{ item.totalRestant|number_format(2, ',', ' ') }} MAD</div>
                <small class=\"text-muted\">Total dû</small>
            </div>
        </div>

        <div class=\"mb-3\">
            <strong>Ventes impayées ({{ item.ventesImpayees|length }}):</strong>
        </div>

        {% for vente in item.ventesImpayees %}
        <div class=\"vente-item\">
            <div class=\"d-flex justify-content-between align-items-start mb-2\">
                <div>
                    <strong>Facture #{{ vente.numeroFacture }}</strong>
                    <br>
                    <small class=\"text-muted\">
                        Date: {{ vente.dateVente|date('d/m/Y') }}
                        | Total: {{ vente.montantFinal|number_format(2, ',', ' ') }} MAD
                        | Payé: {{ vente.montantPaye|number_format(2, ',', ' ') }} MAD
                    </small>
                </div>
                <div class=\"text-end\">
                    <div class=\"credit-amount mb-1\">{{ vente.montantRestant|number_format(2, ',', ' ') }} MAD</div>
                    <span class=\"stat-badge badge-{{ vente.statutPaiement == 'impaye' ? 'impaye' : 'partiel' }}\">
                        {{ vente.statutPaiement == 'impaye' ? 'Impayé' : 'Partiel' }}
                    </span>
                </div>
            </div>
            <button type=\"button\" 
                    class=\"btn btn-sm btn-primary\" 
                    onclick=\"ouvrirModalPaiementClient({{ item.client.id }}, {{ vente.id }}, {{ vente.montantRestant }})\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
        </div>
        {% endfor %}
    </div>
    {% endfor %}
</div>
{% elseif (type == 'clients' or type == 'all') %}
<div class=\"alert alert-info\">
    <i class=\"bi bi-info-circle\"></i> Aucun client avec crédit en cours.
</div>
{% endif %}

<!-- Fournisseurs avec dette -->
{% if (type == 'fournisseurs' or type == 'all') and fournisseursAvecDette|length > 0 %}
<div class=\"mb-5\">
    <h4 class=\"mb-3\">
        <i class=\"bi bi-truck\"></i> Fournisseurs avec dette ({{ fournisseursAvecDette|length }})
    </h4>
    
    {% for item in fournisseursAvecDette %}
    <div class=\"credit-card\">
        <div class=\"credit-header\">
            <div>
                <h5 class=\"mb-1\">{{ item.fournisseur.nom }}</h5>
                <small class=\"text-muted\">
                    {% if item.fournisseur.telephones %}
                        {{ item.fournisseur.telephones[0] }}
                    {% endif %}
                </small>
            </div>
            <div class=\"text-end\">
                <div class=\"credit-amount text-warning\">{{ item.totalDette|number_format(2, ',', ' ') }} MAD</div>
                <small class=\"text-muted\">Total dû</small>
            </div>
        </div>

        <div class=\"mb-3\">
            <strong>Achats impayés ({{ item.achatsImpayes|length }}):</strong>
        </div>

        {% for achat in item.achatsImpayes %}
        <div class=\"achat-item\">
            <div class=\"d-flex justify-content-between align-items-start mb-2\">
                <div>
                    <strong>Facture #{{ achat.numeroFacture }}</strong>
                    <br>
                    <small class=\"text-muted\">
                        Date: {{ achat.dateAchat|date('d/m/Y') }}
                        | Total: {{ achat.montantTotal|number_format(2, ',', ' ') }} MAD
                        | Payé: {{ achat.montantPaye()|number_format(2, ',', ' ') }} MAD
                    </small>
                </div>
                <div class=\"text-end\">
                    <div class=\"credit-amount text-warning mb-1\">{{ achat.montantRestant|number_format(2, ',', ' ') }} MAD</div>
                    <span class=\"stat-badge badge-{{ achat.etatPaiement == 'non_paye' ? 'impaye' : 'partiel' }}\">
                        {{ achat.etatPaiement == 'non_paye' ? 'Impayé' : 'Partiel' }}
                    </span>
                </div>
            </div>
            <button type=\"button\" 
                    class=\"btn btn-sm btn-warning\" 
                    onclick=\"ouvrirModalPaiementFournisseur({{ item.fournisseur.id }}, {{ achat.id }}, {{ achat.montantRestant }})\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
        </div>
        {% endfor %}
    </div>
    {% endfor %}
</div>
{% elseif (type == 'fournisseurs' or type == 'all') %}
<div class=\"alert alert-info\">
    <i class=\"bi bi-info-circle\"></i> Aucun fournisseur avec dette en cours.
</div>
{% endif %}

<!-- Modal Paiement Client -->
<div class=\"modal fade\" id=\"modalPaiementClient\" tabindex=\"-1\">
    <div class=\"modal-dialog\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Ajouter un paiement client</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <form id=\"form-paiement-client\">
                    <input type=\"hidden\" id=\"paiement-client-id\" name=\"client_id\">
                    <input type=\"hidden\" id=\"paiement-vente-id\" name=\"vente_id\">
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant restant</label>
                        <input type=\"text\" id=\"paiement-montant-restant-client\" class=\"form-control\" readonly>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant à payer *</label>
                        <input type=\"number\" id=\"paiement-montant-client\" name=\"montant\" class=\"form-control\" step=\"0.01\" min=\"0.01\" required>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Mode de paiement *</label>
                        <select id=\"paiement-mode-client\" name=\"mode\" class=\"form-select\" required>
                            <option value=\"cash\">Cash</option>
                            <option value=\"carte\">Carte</option>
                            <option value=\"virement\">Virement</option>
                            <option value=\"cheque\">Chèque</option>
                            <option value=\"autre\">Autre</option>
                        </select>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Référence (optionnel)</label>
                        <input type=\"text\" id=\"paiement-reference-client\" name=\"reference\" class=\"form-control\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Date de paiement</label>
                        <input type=\"datetime-local\" id=\"paiement-date-client\" name=\"date\" class=\"form-control\" value=\"{{ 'now'|date('Y-m-d\\\\TH:i') }}\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Notes (optionnel)</label>
                        <textarea id=\"paiement-notes-client\" name=\"notes\" class=\"form-control\" rows=\"3\"></textarea>
                    </div>
                    
                    <button type=\"submit\" class=\"btn btn-primary w-100\">
                        <i class=\"bi bi-check-circle\"></i> Enregistrer le paiement
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Paiement Fournisseur -->
<div class=\"modal fade\" id=\"modalPaiementFournisseur\" tabindex=\"-1\">
    <div class=\"modal-dialog\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Ajouter un paiement fournisseur</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <form id=\"form-paiement-fournisseur\">
                    <input type=\"hidden\" id=\"paiement-fournisseur-id\" name=\"fournisseur_id\">
                    <input type=\"hidden\" id=\"paiement-achat-id\" name=\"achat_id\">
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant restant</label>
                        <input type=\"text\" id=\"paiement-montant-restant-fournisseur\" class=\"form-control\" readonly>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Montant à payer *</label>
                        <input type=\"number\" id=\"paiement-montant-fournisseur\" name=\"montant\" class=\"form-control\" step=\"0.01\" min=\"0.01\" required>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Mode de paiement *</label>
                        <select id=\"paiement-mode-fournisseur\" name=\"mode\" class=\"form-select\" required>
                            <option value=\"especes\">Espèces</option>
                            <option value=\"virement\">Virement</option>
                            <option value=\"carte\">Carte</option>
                            <option value=\"cheque\">Chèque</option>
                            <option value=\"autre\">Autre</option>
                        </select>
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Référence (optionnel)</label>
                        <input type=\"text\" id=\"paiement-reference-fournisseur\" name=\"reference\" class=\"form-control\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Date de paiement</label>
                        <input type=\"datetime-local\" id=\"paiement-date-fournisseur\" name=\"date\" class=\"form-control\" value=\"{{ 'now'|date('Y-m-d\\\\TH:i') }}\">
                    </div>
                    
                    <div class=\"mb-3\">
                        <label class=\"form-label\">Notes (optionnel)</label>
                        <textarea id=\"paiement-notes-fournisseur\" name=\"notes\" class=\"form-control\" rows=\"3\"></textarea>
                    </div>
                    
                    <button type=\"submit\" class=\"btn btn-warning w-100\">
                        <i class=\"bi bi-check-circle\"></i> Enregistrer le paiement
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function ouvrirModalPaiementClient(clientId, venteId, montantRestant) {
    document.getElementById('paiement-client-id').value = clientId;
    document.getElementById('paiement-vente-id').value = venteId;
    document.getElementById('paiement-montant-restant-client').value = parseFloat(montantRestant).toFixed(2) + ' MAD';
    document.getElementById('paiement-montant-client').value = '';
    document.getElementById('paiement-montant-client').max = montantRestant;
    const modal = new bootstrap.Modal(document.getElementById('modalPaiementClient'));
    modal.show();
}

function ouvrirModalPaiementFournisseur(fournisseurId, achatId, montantRestant) {
    document.getElementById('paiement-fournisseur-id').value = fournisseurId;
    document.getElementById('paiement-achat-id').value = achatId;
    document.getElementById('paiement-montant-restant-fournisseur').value = parseFloat(montantRestant).toFixed(2) + ' MAD';
    document.getElementById('paiement-montant-fournisseur').value = '';
    document.getElementById('paiement-montant-fournisseur').max = montantRestant;
    const modal = new bootstrap.Modal(document.getElementById('modalPaiementFournisseur'));
    modal.show();
}

// Soumettre paiement client
document.getElementById('form-paiement-client')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const data = {
        vente_id: document.getElementById('paiement-vente-id').value,
        montant: parseFloat(document.getElementById('paiement-montant-client').value),
        mode: document.getElementById('paiement-mode-client').value,
        reference: document.getElementById('paiement-reference-client').value || null,
        notes: document.getElementById('paiement-notes-client').value || null,
        date: document.getElementById('paiement-date-client').value,
    };
    
    const clientId = document.getElementById('paiement-client-id').value;
    
    try {
        const response = await fetch(`{{ path('credits_client_paiement', {'id': 'PLACEHOLDER'}) }}`.replace('PLACEHOLDER', clientId), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert('Erreur: ' + result.error);
            return;
        }
        
        if (result.success) {
            bootstrap.Modal.getInstance(document.getElementById('modalPaiementClient')).hide();
            location.reload();
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'enregistrement du paiement');
    }
});

// Soumettre paiement fournisseur
document.getElementById('form-paiement-fournisseur')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const data = {
        achat_id: document.getElementById('paiement-achat-id').value,
        montant: parseFloat(document.getElementById('paiement-montant-fournisseur').value),
        mode: document.getElementById('paiement-mode-fournisseur').value,
        reference: document.getElementById('paiement-reference-fournisseur').value || null,
        notes: document.getElementById('paiement-notes-fournisseur').value || null,
        date: document.getElementById('paiement-date-fournisseur').value,
    };
    
    const fournisseurId = document.getElementById('paiement-fournisseur-id').value;
    
    try {
        const response = await fetch(`{{ path('credits_fournisseur_paiement', {'id': 'PLACEHOLDER'}) }}`.replace('PLACEHOLDER', fournisseurId), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert('Erreur: ' + result.error);
            return;
        }
        
        if (result.success) {
            bootstrap.Modal.getInstance(document.getElementById('modalPaiementFournisseur')).hide();
            location.reload();
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'enregistrement du paiement');
    }
});
</script>
{% endblock %}

", "credit/index.html.twig", "/var/www/html/templates/credit/index.html.twig");
    }
}
