<?php

namespace App\Service;

use App\Entity\LogActivite;
use App\Entity\User;
use App\Entity\Magasin;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class LogService
{
    public function __construct(
        private EntityManagerInterface $em,
        private RequestStack $requestStack
    ) {
    }

    public function log(User $user, Magasin $magasin, string $action, ?string $entite = null, ?int $entiteId = null, ?string $details = null): void
    {
        $log = new LogActivite();
        $log->setUtilisateur($user);
        $log->setMagasin($magasin);
        $log->setAction($action);
        $log->setEntite($entite);
        $log->setEntiteId($entiteId);
        $log->setDetails($details);
        
        $request = $this->requestStack->getCurrentRequest();
        if ($request) {
            $log->setIpAddress($request->getClientIp());
        }
        
        $this->em->persist($log);
        $this->em->flush();
    }
}

