<?php

namespace App\Repository;

use App\Entity\Paiement;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Paiement>
 */
class PaiementRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Paiement::class);
    }

    /**
     * Calcule le total des paiements pour un fournisseur
     */
    public function getTotalPayeByFournisseur(int $fournisseurId): float
    {
        $result = $this->createQueryBuilder('p')
            ->select('SUM(p.montant) as total')
            ->where('p.fournisseur = :fournisseurId')
            ->setParameter('fournisseurId', $fournisseurId)
            ->getQuery()
            ->getSingleScalarResult();

        return (float)($result ?? 0);
    }

    /**
     * Calcule le total des paiements pour un achat
     */
    public function getTotalPayeByAchat(int $achatId): float
    {
        $result = $this->createQueryBuilder('p')
            ->select('SUM(p.montant) as total')
            ->where('p.achat = :achatId')
            ->setParameter('achatId', $achatId)
            ->getQuery()
            ->getSingleScalarResult();

        return (float)($result ?? 0);
    }
}

