<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* vente/facture.html.twig */
class __TwigTemplate_482559400b939d3ae3ecfaa913ef2e24 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/facture.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/facture.html.twig"));

        // line 1
        yield "<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Facture ";
        // line 6
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 6, $this->source); })()), "numeroFacture", [], "any", false, false, false, 6), "html", null, true);
        yield "</title>
    <style>
        @media print {
            body { margin: 0; padding: 20px; }
            .no-print { display: none !important; }
            @page { margin: 1cm; }
        }
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            color: #333;
        }
        .header {
            border-bottom: 3px solid #000;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            color: #000;
        }
        .header .info {
            margin-top: 10px;
            font-size: 14px;
            color: #666;
        }
        .company-info {
            margin-bottom: 30px;
        }
        .company-info h2 {
            margin: 0 0 10px 0;
            font-size: 20px;
        }
        .company-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        .client-info {
            margin-bottom: 30px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 5px;
        }
        .client-info h3 {
            margin: 0 0 10px 0;
            font-size: 16px;
            text-transform: uppercase;
        }
        .client-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table thead {
            background: #333;
            color: #fff;
        }
        table th, table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table th {
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
        }
        table tbody tr:hover {
            background: #f9f9f9;
        }
        table tfoot {
            background: #f5f5f5;
        }
        table tfoot th {
            text-align: right;
            padding-right: 20px;
        }
        .total-row {
            background: #000 !important;
            color: #fff !important;
            font-size: 18px;
            font-weight: bold;
        }
        .total-row th, .total-row td {
            border: none;
        }
        .payment-info {
            margin-top: 30px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 5px;
        }
        .payment-info h3 {
            margin: 0 0 10px 0;
            font-size: 16px;
        }
        .payment-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .btn-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .btn-print button {
            background: #007bff;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .btn-print button:hover {
            background: #0056b3;
        }
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-paye {
            background: #28a745;
            color: #fff;
        }
        .badge-partiel {
            background: #ffc107;
            color: #000;
        }
        .badge-impaye {
            background: #dc3545;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class=\"btn-print no-print\">
        <button onclick=\"window.print()\">🖨️ Imprimer</button>
        <a href=\"";
        // line 161
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_show", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 161, $this->source); })()), "id", [], "any", false, false, false, 161)]), "html", null, true);
        yield "\" style=\"margin-left: 10px; color: #007bff; text-decoration: none;\">← Retour</a>
    </div>

    <div class=\"header\">
        <h1>FACTURE</h1>
        <div class=\"info\">
            <strong>N° Facture:</strong> ";
        // line 167
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 167, $this->source); })()), "numeroFacture", [], "any", false, false, false, 167), "html", null, true);
        yield "<br>
            <strong>Date:</strong> ";
        // line 168
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 168, $this->source); })()), "dateVente", [], "any", false, false, false, 168), "d/m/Y à H:i"), "html", null, true);
        yield "
        </div>
    </div>

    <div class=\"company-info\">
        <h2>";
        // line 173
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 173, $this->source); })()), "magasin", [], "any", false, false, false, 173), "nom", [], "any", false, false, false, 173), "html", null, true);
        yield "</h2>
        ";
        // line 174
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 174, $this->source); })()), "magasin", [], "any", false, false, false, 174), "adresse", [], "any", false, false, false, 174)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 175
            yield "        <p>";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 175, $this->source); })()), "magasin", [], "any", false, false, false, 175), "adresse", [], "any", false, false, false, 175), "html", null, true);
            yield "</p>
        ";
        }
        // line 177
        yield "        ";
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 177, $this->source); })()), "magasin", [], "any", false, false, false, 177), "telephone", [], "any", false, false, false, 177)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 178
            yield "        <p><strong>Tél:</strong> ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 178, $this->source); })()), "magasin", [], "any", false, false, false, 178), "telephone", [], "any", false, false, false, 178), "html", null, true);
            yield "</p>
        ";
        }
        // line 180
        yield "        ";
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 180, $this->source); })()), "magasin", [], "any", false, false, false, 180), "email", [], "any", false, false, false, 180)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 181
            yield "        <p><strong>Email:</strong> ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 181, $this->source); })()), "magasin", [], "any", false, false, false, 181), "email", [], "any", false, false, false, 181), "html", null, true);
            yield "</p>
        ";
        }
        // line 183
        yield "    </div>

    ";
        // line 185
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 185, $this->source); })()), "client", [], "any", false, false, false, 185)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 186
            yield "    <div class=\"client-info\">
        <h3>Client</h3>
        <p><strong>";
            // line 188
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 188, $this->source); })()), "client", [], "any", false, false, false, 188), "nom", [], "any", false, false, false, 188), "html", null, true);
            yield "</strong></p>
        ";
            // line 189
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 189, $this->source); })()), "client", [], "any", false, false, false, 189), "telephone", [], "any", false, false, false, 189)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 190
                yield "        <p><strong>Tél:</strong> ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 190, $this->source); })()), "client", [], "any", false, false, false, 190), "telephone", [], "any", false, false, false, 190), "html", null, true);
                yield "</p>
        ";
            }
            // line 192
            yield "        ";
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 192, $this->source); })()), "client", [], "any", false, false, false, 192), "adresse", [], "any", false, false, false, 192)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 193
                yield "        <p><strong>Adresse:</strong> ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 193, $this->source); })()), "client", [], "any", false, false, false, 193), "adresse", [], "any", false, false, false, 193), "html", null, true);
                yield "</p>
        ";
            }
            // line 195
            yield "        ";
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 195, $this->source); })()), "client", [], "any", false, false, false, 195), "email", [], "any", false, false, false, 195)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 196
                yield "        <p><strong>Email:</strong> ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 196, $this->source); })()), "client", [], "any", false, false, false, 196), "email", [], "any", false, false, false, 196), "html", null, true);
                yield "</p>
        ";
            }
            // line 198
            yield "    </div>
    ";
        }
        // line 200
        yield "
    <table>
        <thead>
            <tr>
                <th>Produit</th>
                <th style=\"text-align: center;\">Quantité</th>
                <th style=\"text-align: right;\">Prix unitaire</th>
                <th style=\"text-align: right;\">Total</th>
            </tr>
        </thead>
        <tbody>
            ";
        // line 211
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 211, $this->source); })()), "lignesVente", [], "any", false, false, false, 211));
        foreach ($context['_seq'] as $context["_key"] => $context["ligne"]) {
            // line 212
            yield "            <tr>
                <td><strong>";
            // line 213
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "produit", [], "any", false, false, false, 213), "nom", [], "any", false, false, false, 213), "html", null, true);
            yield "</strong>
                    ";
            // line 214
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "produit", [], "any", false, false, false, 214), "codeBarres", [], "any", false, false, false, 214)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 215
                yield "                    <br><small style=\"color: #666;\">Code: ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "produit", [], "any", false, false, false, 215), "codeBarres", [], "any", false, false, false, 215), "html", null, true);
                yield "</small>
                    ";
            }
            // line 217
            yield "                </td>
                <td style=\"text-align: center;\">";
            // line 218
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "quantite", [], "any", false, false, false, 218), "html", null, true);
            yield "</td>
                <td style=\"text-align: right;\">";
            // line 219
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "prixUnitaire", [], "any", false, false, false, 219), 2, ",", " "), "html", null, true);
            yield " MAD</td>
                <td style=\"text-align: right;\"><strong>";
            // line 220
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "montantTotal", [], "any", false, false, false, 220), 2, ",", " "), "html", null, true);
            yield " MAD</strong></td>
            </tr>
            ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['ligne'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 223
        yield "        </tbody>
        <tfoot>
            <tr>
                <th colspan=\"3\" style=\"text-align: right;\">Sous-total</th>
                <th style=\"text-align: right;\">";
        // line 227
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 227, $this->source); })()), "montantTotal", [], "any", false, false, false, 227), 2, ",", " "), "html", null, true);
        yield " MAD</th>
            </tr>
            ";
        // line 229
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 229, $this->source); })()), "reduction", [], "any", false, false, false, 229) && (CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 229, $this->source); })()), "reduction", [], "any", false, false, false, 229) > 0))) {
            // line 230
            yield "            <tr>
                <th colspan=\"3\" style=\"text-align: right;\">Réduction</th>
                <th style=\"text-align: right; color: #dc3545;\">-";
            // line 232
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 232, $this->source); })()), "reduction", [], "any", false, false, false, 232), 2, ",", " "), "html", null, true);
            yield " MAD</th>
            </tr>
            ";
        }
        // line 235
        yield "            <tr class=\"total-row\">
                <th colspan=\"3\" style=\"text-align: right;\">TOTAL</th>
                <th style=\"text-align: right;\">";
        // line 237
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 237, $this->source); })()), "montantFinal", [], "any", false, false, false, 237), 2, ",", " "), "html", null, true);
        yield " MAD</th>
            </tr>
        </tfoot>
    </table>

    <div class=\"payment-info\">
        <h3>Informations de paiement</h3>
        <p><strong>Mode de paiement:</strong> 
            ";
        // line 245
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 245, $this->source); })()), "modePaiement", [], "any", false, false, false, 245) == "cash")) {
            yield "Espèces
            ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 246
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 246, $this->source); })()), "modePaiement", [], "any", false, false, false, 246) == "carte")) {
            yield "Carte
            ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 247
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 247, $this->source); })()), "modePaiement", [], "any", false, false, false, 247) == "virement")) {
            yield "Virement
            ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 248
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 248, $this->source); })()), "modePaiement", [], "any", false, false, false, 248) == "cheque")) {
            yield "Chèque
            ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 249
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 249, $this->source); })()), "modePaiement", [], "any", false, false, false, 249) == "credit")) {
            yield "Crédit
            ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 250
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 250, $this->source); })()), "modePaiement", [], "any", false, false, false, 250) == "mixte")) {
            yield "Mixte
            ";
        } else {
            // line 251
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 251, $this->source); })()), "modePaiement", [], "any", false, false, false, 251), "html", null, true);
            yield "
            ";
        }
        // line 253
        yield "        </p>
        <p><strong>Statut:</strong> 
            <span class=\"badge badge-";
        // line 255
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 255, $this->source); })()), "statutPaiement", [], "any", false, false, false, 255) == "paye")) ? ("paye") : ((((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 255, $this->source); })()), "statutPaiement", [], "any", false, false, false, 255) == "partiel")) ? ("partiel") : ("impaye"))));
        yield "\">
                ";
        // line 256
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 256, $this->source); })()), "statutPaiement", [], "any", false, false, false, 256) == "paye")) {
            yield "Payé
                ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 257
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 257, $this->source); })()), "statutPaiement", [], "any", false, false, false, 257) == "partiel")) {
            yield "Partiel
                ";
        } else {
            // line 258
            yield "Impayé
                ";
        }
        // line 260
        yield "            </span>
        </p>
        <p><strong>Montant payé:</strong> ";
        // line 262
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 262, $this->source); })()), "montantPaye", [], "any", false, false, false, 262), 2, ",", " "), "html", null, true);
        yield " MAD</p>
        ";
        // line 263
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 263, $this->source); })()), "montantRestant", [], "any", false, false, false, 263) > 0)) {
            // line 264
            yield "        <p><strong>Montant restant:</strong> <span style=\"color: #dc3545; font-weight: bold;\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 264, $this->source); })()), "montantRestant", [], "any", false, false, false, 264), 2, ",", " "), "html", null, true);
            yield " MAD</span></p>
        ";
            // line 265
            if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 265, $this->source); })()), "dateLimitePaiement", [], "any", false, false, false, 265)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                // line 266
                yield "        <p><strong>Date limite de paiement:</strong> ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 266, $this->source); })()), "dateLimitePaiement", [], "any", false, false, false, 266), "d/m/Y"), "html", null, true);
                yield "</p>
        ";
            }
            // line 268
            yield "        ";
        } else {
            // line 269
            yield "        <p><strong>Montant restant:</strong> <span style=\"color: #28a745; font-weight: bold;\">0,00 MAD</span></p>
        ";
        }
        // line 271
        yield "        
        ";
        // line 272
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 272, $this->source); })()), "paiementsClient", [], "any", false, false, false, 272)) > 0)) {
            // line 273
            yield "        <h3 style=\"margin-top: 20px; margin-bottom: 10px;\">Historique des paiements</h3>
        <table style=\"width: 100%; border-collapse: collapse; margin-top: 10px;\">
            <thead>
                <tr style=\"background: #333; color: #fff;\">
                    <th style=\"padding: 8px; text-align: left; font-size: 12px;\">Date</th>
                    <th style=\"padding: 8px; text-align: right; font-size: 12px;\">Montant</th>
                    <th style=\"padding: 8px; text-align: center; font-size: 12px;\">Mode</th>
                    <th style=\"padding: 8px; text-align: left; font-size: 12px;\">Référence</th>
                </tr>
            </thead>
            <tbody>
                ";
            // line 284
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(Twig\Extension\CoreExtension::sort($this->env, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 284, $this->source); })()), "paiementsClient", [], "any", false, false, false, 284), function ($__a__, $__b__) use ($context, $macros) { $context["a"] = $__a__; $context["b"] = $__b__; return (CoreExtension::getAttribute($this->env, $this->source, (isset($context["b"]) || array_key_exists("b", $context) ? $context["b"] : (function () { throw new RuntimeError('Variable "b" does not exist.', 284, $this->source); })()), "datePaiement", [], "any", false, false, false, 284) <=> CoreExtension::getAttribute($this->env, $this->source, (isset($context["a"]) || array_key_exists("a", $context) ? $context["a"] : (function () { throw new RuntimeError('Variable "a" does not exist.', 284, $this->source); })()), "datePaiement", [], "any", false, false, false, 284)); }));
            foreach ($context['_seq'] as $context["_key"] => $context["paiement"]) {
                // line 285
                yield "                <tr style=\"border-bottom: 1px solid #ddd;\">
                    <td style=\"padding: 8px; font-size: 12px;\">";
                // line 286
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "datePaiement", [], "any", false, false, false, 286), "d/m/Y à H:i"), "html", null, true);
                yield "</td>
                    <td style=\"padding: 8px; text-align: right; font-weight: bold; color: #28a745; font-size: 12px;\">";
                // line 287
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "montant", [], "any", false, false, false, 287), 2, ",", " "), "html", null, true);
                yield " MAD</td>
                    <td style=\"padding: 8px; text-align: center; font-size: 12px;\">
                        ";
                // line 289
                if ((CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "mode", [], "any", false, false, false, 289) == "cash")) {
                    yield "Espèces
                        ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 290
$context["paiement"], "mode", [], "any", false, false, false, 290) == "carte")) {
                    yield "Carte
                        ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 291
$context["paiement"], "mode", [], "any", false, false, false, 291) == "virement")) {
                    yield "Virement
                        ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 292
$context["paiement"], "mode", [], "any", false, false, false, 292) == "cheque")) {
                    yield "Chèque
                        ";
                } else {
                    // line 293
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "mode", [], "any", false, false, false, 293), "html", null, true);
                    yield "
                        ";
                }
                // line 295
                yield "                    </td>
                    <td style=\"padding: 8px; font-size: 12px;\">";
                // line 296
                yield (((CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", true, true, false, 296) &&  !(null === CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", false, false, false, 296)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", false, false, false, 296), "html", null, true)) : ("-"));
                yield "</td>
                </tr>
                ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['paiement'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 299
            yield "            </tbody>
        </table>
        ";
        }
        // line 302
        yield "    </div>

    ";
        // line 304
        if ((($tmp = CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 304, $this->source); })()), "notes", [], "any", false, false, false, 304)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 305
            yield "    <div class=\"payment-info\">
        <h3>Notes</h3>
        <p>";
            // line 307
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 307, $this->source); })()), "notes", [], "any", false, false, false, 307), "html", null, true);
            yield "</p>
    </div>
    ";
        }
        // line 310
        yield "
    <div class=\"footer\">
        <p>Merci de votre confiance !</p>
        <p>Facture générée le ";
        // line 313
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate("now", "d/m/Y à H:i"), "html", null, true);
        yield "</p>
    </div>
</body>
</html>

";
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "vente/facture.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  573 => 313,  568 => 310,  562 => 307,  558 => 305,  556 => 304,  552 => 302,  547 => 299,  538 => 296,  535 => 295,  530 => 293,  525 => 292,  521 => 291,  517 => 290,  513 => 289,  508 => 287,  504 => 286,  501 => 285,  497 => 284,  484 => 273,  482 => 272,  479 => 271,  475 => 269,  472 => 268,  466 => 266,  464 => 265,  459 => 264,  457 => 263,  453 => 262,  449 => 260,  445 => 258,  440 => 257,  436 => 256,  432 => 255,  428 => 253,  423 => 251,  418 => 250,  414 => 249,  410 => 248,  406 => 247,  402 => 246,  398 => 245,  387 => 237,  383 => 235,  377 => 232,  373 => 230,  371 => 229,  366 => 227,  360 => 223,  351 => 220,  347 => 219,  343 => 218,  340 => 217,  334 => 215,  332 => 214,  328 => 213,  325 => 212,  321 => 211,  308 => 200,  304 => 198,  298 => 196,  295 => 195,  289 => 193,  286 => 192,  280 => 190,  278 => 189,  274 => 188,  270 => 186,  268 => 185,  264 => 183,  258 => 181,  255 => 180,  249 => 178,  246 => 177,  240 => 175,  238 => 174,  234 => 173,  226 => 168,  222 => 167,  213 => 161,  55 => 6,  48 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("<!DOCTYPE html>
<html lang=\"fr\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <title>Facture {{ vente.numeroFacture }}</title>
    <style>
        @media print {
            body { margin: 0; padding: 20px; }
            .no-print { display: none !important; }
            @page { margin: 1cm; }
        }
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            color: #333;
        }
        .header {
            border-bottom: 3px solid #000;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
            color: #000;
        }
        .header .info {
            margin-top: 10px;
            font-size: 14px;
            color: #666;
        }
        .company-info {
            margin-bottom: 30px;
        }
        .company-info h2 {
            margin: 0 0 10px 0;
            font-size: 20px;
        }
        .company-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        .client-info {
            margin-bottom: 30px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 5px;
        }
        .client-info h3 {
            margin: 0 0 10px 0;
            font-size: 16px;
            text-transform: uppercase;
        }
        .client-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table thead {
            background: #333;
            color: #fff;
        }
        table th, table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table th {
            font-weight: bold;
            text-transform: uppercase;
            font-size: 12px;
        }
        table tbody tr:hover {
            background: #f9f9f9;
        }
        table tfoot {
            background: #f5f5f5;
        }
        table tfoot th {
            text-align: right;
            padding-right: 20px;
        }
        .total-row {
            background: #000 !important;
            color: #fff !important;
            font-size: 18px;
            font-weight: bold;
        }
        .total-row th, .total-row td {
            border: none;
        }
        .payment-info {
            margin-top: 30px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 5px;
        }
        .payment-info h3 {
            margin: 0 0 10px 0;
            font-size: 16px;
        }
        .payment-info p {
            margin: 5px 0;
            font-size: 14px;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .btn-print {
            margin-bottom: 20px;
            text-align: center;
        }
        .btn-print button {
            background: #007bff;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .btn-print button:hover {
            background: #0056b3;
        }
        .badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-paye {
            background: #28a745;
            color: #fff;
        }
        .badge-partiel {
            background: #ffc107;
            color: #000;
        }
        .badge-impaye {
            background: #dc3545;
            color: #fff;
        }
    </style>
</head>
<body>
    <div class=\"btn-print no-print\">
        <button onclick=\"window.print()\">🖨️ Imprimer</button>
        <a href=\"{{ path('ventes_show', {'id': vente.id}) }}\" style=\"margin-left: 10px; color: #007bff; text-decoration: none;\">← Retour</a>
    </div>

    <div class=\"header\">
        <h1>FACTURE</h1>
        <div class=\"info\">
            <strong>N° Facture:</strong> {{ vente.numeroFacture }}<br>
            <strong>Date:</strong> {{ vente.dateVente|date('d/m/Y à H:i') }}
        </div>
    </div>

    <div class=\"company-info\">
        <h2>{{ vente.magasin.nom }}</h2>
        {% if vente.magasin.adresse %}
        <p>{{ vente.magasin.adresse }}</p>
        {% endif %}
        {% if vente.magasin.telephone %}
        <p><strong>Tél:</strong> {{ vente.magasin.telephone }}</p>
        {% endif %}
        {% if vente.magasin.email %}
        <p><strong>Email:</strong> {{ vente.magasin.email }}</p>
        {% endif %}
    </div>

    {% if vente.client %}
    <div class=\"client-info\">
        <h3>Client</h3>
        <p><strong>{{ vente.client.nom }}</strong></p>
        {% if vente.client.telephone %}
        <p><strong>Tél:</strong> {{ vente.client.telephone }}</p>
        {% endif %}
        {% if vente.client.adresse %}
        <p><strong>Adresse:</strong> {{ vente.client.adresse }}</p>
        {% endif %}
        {% if vente.client.email %}
        <p><strong>Email:</strong> {{ vente.client.email }}</p>
        {% endif %}
    </div>
    {% endif %}

    <table>
        <thead>
            <tr>
                <th>Produit</th>
                <th style=\"text-align: center;\">Quantité</th>
                <th style=\"text-align: right;\">Prix unitaire</th>
                <th style=\"text-align: right;\">Total</th>
            </tr>
        </thead>
        <tbody>
            {% for ligne in vente.lignesVente %}
            <tr>
                <td><strong>{{ ligne.produit.nom }}</strong>
                    {% if ligne.produit.codeBarres %}
                    <br><small style=\"color: #666;\">Code: {{ ligne.produit.codeBarres }}</small>
                    {% endif %}
                </td>
                <td style=\"text-align: center;\">{{ ligne.quantite }}</td>
                <td style=\"text-align: right;\">{{ ligne.prixUnitaire|number_format(2, ',', ' ') }} MAD</td>
                <td style=\"text-align: right;\"><strong>{{ ligne.montantTotal|number_format(2, ',', ' ') }} MAD</strong></td>
            </tr>
            {% endfor %}
        </tbody>
        <tfoot>
            <tr>
                <th colspan=\"3\" style=\"text-align: right;\">Sous-total</th>
                <th style=\"text-align: right;\">{{ vente.montantTotal|number_format(2, ',', ' ') }} MAD</th>
            </tr>
            {% if vente.reduction and vente.reduction > 0 %}
            <tr>
                <th colspan=\"3\" style=\"text-align: right;\">Réduction</th>
                <th style=\"text-align: right; color: #dc3545;\">-{{ vente.reduction|number_format(2, ',', ' ') }} MAD</th>
            </tr>
            {% endif %}
            <tr class=\"total-row\">
                <th colspan=\"3\" style=\"text-align: right;\">TOTAL</th>
                <th style=\"text-align: right;\">{{ vente.montantFinal|number_format(2, ',', ' ') }} MAD</th>
            </tr>
        </tfoot>
    </table>

    <div class=\"payment-info\">
        <h3>Informations de paiement</h3>
        <p><strong>Mode de paiement:</strong> 
            {% if vente.modePaiement == 'cash' %}Espèces
            {% elseif vente.modePaiement == 'carte' %}Carte
            {% elseif vente.modePaiement == 'virement' %}Virement
            {% elseif vente.modePaiement == 'cheque' %}Chèque
            {% elseif vente.modePaiement == 'credit' %}Crédit
            {% elseif vente.modePaiement == 'mixte' %}Mixte
            {% else %}{{ vente.modePaiement }}
            {% endif %}
        </p>
        <p><strong>Statut:</strong> 
            <span class=\"badge badge-{{ vente.statutPaiement == 'paye' ? 'paye' : (vente.statutPaiement == 'partiel' ? 'partiel' : 'impaye') }}\">
                {% if vente.statutPaiement == 'paye' %}Payé
                {% elseif vente.statutPaiement == 'partiel' %}Partiel
                {% else %}Impayé
                {% endif %}
            </span>
        </p>
        <p><strong>Montant payé:</strong> {{ vente.montantPaye|number_format(2, ',', ' ') }} MAD</p>
        {% if vente.montantRestant > 0 %}
        <p><strong>Montant restant:</strong> <span style=\"color: #dc3545; font-weight: bold;\">{{ vente.montantRestant|number_format(2, ',', ' ') }} MAD</span></p>
        {% if vente.dateLimitePaiement %}
        <p><strong>Date limite de paiement:</strong> {{ vente.dateLimitePaiement|date('d/m/Y') }}</p>
        {% endif %}
        {% else %}
        <p><strong>Montant restant:</strong> <span style=\"color: #28a745; font-weight: bold;\">0,00 MAD</span></p>
        {% endif %}
        
        {% if vente.paiementsClient|length > 0 %}
        <h3 style=\"margin-top: 20px; margin-bottom: 10px;\">Historique des paiements</h3>
        <table style=\"width: 100%; border-collapse: collapse; margin-top: 10px;\">
            <thead>
                <tr style=\"background: #333; color: #fff;\">
                    <th style=\"padding: 8px; text-align: left; font-size: 12px;\">Date</th>
                    <th style=\"padding: 8px; text-align: right; font-size: 12px;\">Montant</th>
                    <th style=\"padding: 8px; text-align: center; font-size: 12px;\">Mode</th>
                    <th style=\"padding: 8px; text-align: left; font-size: 12px;\">Référence</th>
                </tr>
            </thead>
            <tbody>
                {% for paiement in vente.paiementsClient|sort((a, b) => b.datePaiement <=> a.datePaiement) %}
                <tr style=\"border-bottom: 1px solid #ddd;\">
                    <td style=\"padding: 8px; font-size: 12px;\">{{ paiement.datePaiement|date('d/m/Y à H:i') }}</td>
                    <td style=\"padding: 8px; text-align: right; font-weight: bold; color: #28a745; font-size: 12px;\">{{ paiement.montant|number_format(2, ',', ' ') }} MAD</td>
                    <td style=\"padding: 8px; text-align: center; font-size: 12px;\">
                        {% if paiement.mode == 'cash' %}Espèces
                        {% elseif paiement.mode == 'carte' %}Carte
                        {% elseif paiement.mode == 'virement' %}Virement
                        {% elseif paiement.mode == 'cheque' %}Chèque
                        {% else %}{{ paiement.mode }}
                        {% endif %}
                    </td>
                    <td style=\"padding: 8px; font-size: 12px;\">{{ paiement.reference ?? '-' }}</td>
                </tr>
                {% endfor %}
            </tbody>
        </table>
        {% endif %}
    </div>

    {% if vente.notes %}
    <div class=\"payment-info\">
        <h3>Notes</h3>
        <p>{{ vente.notes }}</p>
    </div>
    {% endif %}

    <div class=\"footer\">
        <p>Merci de votre confiance !</p>
        <p>Facture générée le {{ 'now'|date('d/m/Y à H:i') }}</p>
    </div>
</body>
</html>

", "vente/facture.html.twig", "/var/www/html/templates/vente/facture.html.twig");
    }
}
