<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* bilan/index.html.twig */
class __TwigTemplate_4d6e759e84e8a6864872509f0c1d3681 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "bilan/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "bilan/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Bilan détaillé - Red Store";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Bilan détaillé";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .bilan-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        margin-bottom: 2rem;
    }

    .bilan-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--border);
        margin-bottom: 1.5rem;
    }

    .bilan-total-card {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border-radius: 1rem;
        padding: 2rem;
        margin-bottom: 2rem;
    }

    .stat-box {
        background: var(--bg-secondary);
        border-radius: 0.5rem;
        padding: 1rem;
        text-align: center;
    }

    .stat-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin: 0.5rem 0;
    }

    .stat-label {
        font-size: 0.875rem;
        color: var(--text-secondary);
        text-transform: uppercase;
    }

    .mois-section {
        margin-bottom: 3rem;
    }

    .mois-header {
        background: var(--primary);
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 0.5rem 0.5rem 0 0;
        font-weight: 600;
        font-size: 1.125rem;
    }

    .table-detail {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 1rem;
    }

    .table-detail th,
    .table-detail td {
        padding: 0.75rem;
        text-align: left;
        border-bottom: 1px solid var(--border);
    }

    .table-detail th {
        background: var(--bg-secondary);
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
    }

    .badge-vente {
        background: #d1fae5;
        color: #065f46;
    }

    .badge-achat {
        background: #fee2e2;
        color: #991b1b;
    }

    .badge-depense {
        background: #fef3c7;
        color: #92400e;
    }
</style>

<!-- Bilan Total -->
<div class=\"bilan-total-card\">
    <h2 class=\"mb-4\">
        <i class=\"bi bi-calculator\"></i> Bilan Total Actuel
    </h2>
    <div class=\"row g-4\">
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Ventes</div>
                <div class=\"stat-value\" style=\"color: white;\">";
        // line 111
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 111, $this->source); })()), "totalVentes", [], "any", false, false, false, 111), 2, ",", " "), "html", null, true);
        yield " MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Achats</div>
                <div class=\"stat-value\" style=\"color: white;\">";
        // line 117
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 117, $this->source); })()), "totalAchats", [], "any", false, false, false, 117), 2, ",", " "), "html", null, true);
        yield " MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Dépenses</div>
                <div class=\"stat-value\" style=\"color: white;\">";
        // line 123
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 123, $this->source); })()), "totalDepenses", [], "any", false, false, false, 123), 2, ",", " "), "html", null, true);
        yield " MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Profit Net</div>
                <div class=\"stat-value\" style=\"color: white; ";
        // line 129
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 129, $this->source); })()), "profitNet", [], "any", false, false, false, 129) >= 0)) ? ("") : ("color: #fee2e2;"));
        yield "\">
                    ";
        // line 130
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 130, $this->source); })()), "profitNet", [], "any", false, false, false, 130), 2, ",", " "), "html", null, true);
        yield " MAD
                </div>
            </div>
        </div>
    </div>
    <div class=\"row g-4 mt-2\">
        <div class=\"col-md-6\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Crédits Clients</div>
                <div class=\"stat-value\" style=\"color: #fee2e2;\">";
        // line 139
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 139, $this->source); })()), "totalCreditsClients", [], "any", false, false, false, 139), 2, ",", " "), "html", null, true);
        yield " MAD</div>
            </div>
        </div>
        <div class=\"col-md-6\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Dettes Fournisseurs</div>
                <div class=\"stat-value\" style=\"color: #fef3c7;\">";
        // line 145
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bilanTotal"]) || array_key_exists("bilanTotal", $context) ? $context["bilanTotal"] : (function () { throw new RuntimeError('Variable "bilanTotal" does not exist.', 145, $this->source); })()), "totalDettesFournisseurs", [], "any", false, false, false, 145), 2, ",", " "), "html", null, true);
        yield " MAD</div>
            </div>
        </div>
    </div>
</div>

<!-- Bilans par mois -->
<h3 class=\"mb-4\">
    <i class=\"bi bi-calendar-month\"></i> Bilans par mois
</h3>

";
        // line 156
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["bilansParMois"]) || array_key_exists("bilansParMois", $context) ? $context["bilansParMois"] : (function () { throw new RuntimeError('Variable "bilansParMois" does not exist.', 156, $this->source); })())) > 0)) {
            // line 157
            yield "    ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["bilansParMois"]) || array_key_exists("bilansParMois", $context) ? $context["bilansParMois"] : (function () { throw new RuntimeError('Variable "bilansParMois" does not exist.', 157, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["bilan"]) {
                // line 158
                yield "    <div class=\"mois-section\">
        <div class=\"bilan-card\">
            <div class=\"mois-header\">
                <i class=\"bi bi-calendar3\"></i> 
                ";
                // line 162
                $context["moisNum"] = CoreExtension::getAttribute($this->env, $this->source, Twig\Extension\CoreExtension::split($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "mois", [], "any", false, false, false, 162), "-"), 1, [], "array", false, false, false, 162);
                // line 163
                yield "                ";
                $context["annee"] = CoreExtension::getAttribute($this->env, $this->source, Twig\Extension\CoreExtension::split($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "mois", [], "any", false, false, false, 163), "-"), 0, [], "array", false, false, false, 163);
                // line 164
                yield "                ";
                $context["moisNoms"] = ["01" => "Janvier", "02" => "Février", "03" => "Mars", "04" => "Avril", "05" => "Mai", "06" => "Juin", "07" => "Juillet", "08" => "Août", "09" => "Septembre", "10" => "Octobre", "11" => "Novembre", "12" => "Décembre"];
                // line 178
                yield "                ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["moisNoms"]) || array_key_exists("moisNoms", $context) ? $context["moisNoms"] : (function () { throw new RuntimeError('Variable "moisNoms" does not exist.', 178, $this->source); })()), (isset($context["moisNum"]) || array_key_exists("moisNum", $context) ? $context["moisNum"] : (function () { throw new RuntimeError('Variable "moisNum" does not exist.', 178, $this->source); })()), [], "array", false, false, false, 178), "html", null, true);
                yield " ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((isset($context["annee"]) || array_key_exists("annee", $context) ? $context["annee"] : (function () { throw new RuntimeError('Variable "annee" does not exist.', 178, $this->source); })()), "html", null, true);
                yield "
            </div>

            <!-- Résumé du mois -->
            <div class=\"row g-3 mb-4\">
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Ventes</div>
                        <div class=\"stat-value\" style=\"color: var(--success);\">
                            ";
                // line 187
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "totalVentes", [], "any", false, false, false, 187), 2, ",", " "), "html", null, true);
                yield " MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">";
                // line 189
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "ventes", [], "any", false, false, false, 189)), "html", null, true);
                yield " vente(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Achats</div>
                        <div class=\"stat-value\" style=\"color: var(--danger);\">
                            ";
                // line 196
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "totalAchats", [], "any", false, false, false, 196), 2, ",", " "), "html", null, true);
                yield " MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">";
                // line 198
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "achats", [], "any", false, false, false, 198)), "html", null, true);
                yield " achat(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Dépenses</div>
                        <div class=\"stat-value\" style=\"color: var(--warning);\">
                            ";
                // line 205
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "totalDepenses", [], "any", false, false, false, 205), 2, ",", " "), "html", null, true);
                yield " MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">";
                // line 207
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "depenses", [], "any", false, false, false, 207)), "html", null, true);
                yield " dépense(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Profit Net</div>
                        <div class=\"stat-value\" style=\"color: ";
                // line 213
                yield (((CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "profitNet", [], "any", false, false, false, 213) >= 0)) ? ("var(--success)") : ("var(--danger)"));
                yield ";\">
                            ";
                // line 214
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "profitNet", [], "any", false, false, false, 214), 2, ",", " "), "html", null, true);
                yield " MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">Profit brut: ";
                // line 216
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "profitBrut", [], "any", false, false, false, 216), 2, ",", " "), "html", null, true);
                yield " MAD</small>
                    </div>
                </div>
            </div>

            <!-- Détails des ventes -->
            ";
                // line 222
                if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "ventes", [], "any", false, false, false, 222)) > 0)) {
                    // line 223
                    yield "            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-vente\">Ventes (";
                    // line 225
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "ventes", [], "any", false, false, false, 225)), "html", null, true);
                    yield ")</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Facture</th>
                                <th>Client</th>
                                <th>Montant</th>
                                <th>Payé</th>
                                <th>Reste</th>
                                <th>Statut</th>
                            </tr>
                        </thead>
                        <tbody>
                            ";
                    // line 241
                    $context['_parent'] = $context;
                    $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "ventes", [], "any", false, false, false, 241));
                    foreach ($context['_seq'] as $context["_key"] => $context["vente"]) {
                        // line 242
                        yield "                            <tr>
                                <td>";
                        // line 243
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "dateVente", [], "any", false, false, false, 243), "d/m/Y"), "html", null, true);
                        yield "</td>
                                <td><strong>";
                        // line 244
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "numeroFacture", [], "any", false, false, false, 244), "html", null, true);
                        yield "</strong></td>
                                <td>";
                        // line 245
                        yield (((($tmp = CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "client", [], "any", false, false, false, 245)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "client", [], "any", false, false, false, 245), "nom", [], "any", false, false, false, 245), "html", null, true)) : ("Client rapide"));
                        yield "</td>
                                <td>";
                        // line 246
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantFinal", [], "any", false, false, false, 246), 2, ",", " "), "html", null, true);
                        yield " MAD</td>
                                <td>";
                        // line 247
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantPaye", [], "any", false, false, false, 247), 2, ",", " "), "html", null, true);
                        yield " MAD</td>
                                <td style=\"color: ";
                        // line 248
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 248) > 0)) ? ("var(--danger)") : ("var(--success)"));
                        yield ";\">
                                    ";
                        // line 249
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "montantRestant", [], "any", false, false, false, 249), 2, ",", " "), "html", null, true);
                        yield " MAD
                                </td>
                                <td>
                                    <span class=\"badge badge-";
                        // line 252
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 252) == "paye")) ? ("success") : ((((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 252) == "partiel")) ? ("warning") : ("danger"))));
                        yield "\">
                                        ";
                        // line 253
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 253) == "paye")) ? ("Payé") : ((((CoreExtension::getAttribute($this->env, $this->source, $context["vente"], "statutPaiement", [], "any", false, false, false, 253) == "partiel")) ? ("Partiel") : ("Impayé"))));
                        yield "
                                    </span>
                                </td>
                            </tr>
                            ";
                    }
                    $_parent = $context['_parent'];
                    unset($context['_seq'], $context['_key'], $context['vente'], $context['_parent']);
                    $context = array_intersect_key($context, $_parent) + $_parent;
                    // line 258
                    yield "                        </tbody>
                    </table>
                </div>
            </div>
            ";
                }
                // line 263
                yield "
            <!-- Détails des achats -->
            ";
                // line 265
                if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "achats", [], "any", false, false, false, 265)) > 0)) {
                    // line 266
                    yield "            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-achat\">Achats (";
                    // line 268
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "achats", [], "any", false, false, false, 268)), "html", null, true);
                    yield ")</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Facture</th>
                                <th>Fournisseur</th>
                                <th>Montant Total</th>
                                <th>Payé</th>
                                <th>Reste</th>
                                <th>État</th>
                            </tr>
                        </thead>
                        <tbody>
                            ";
                    // line 284
                    $context['_parent'] = $context;
                    $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "achats", [], "any", false, false, false, 284));
                    foreach ($context['_seq'] as $context["_key"] => $context["achat"]) {
                        // line 285
                        yield "                            <tr>
                                <td>";
                        // line 286
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "dateAchat", [], "any", false, false, false, 286), "d/m/Y"), "html", null, true);
                        yield "</td>
                                <td><strong>";
                        // line 287
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "numeroFacture", [], "any", false, false, false, 287), "html", null, true);
                        yield "</strong></td>
                                <td>";
                        // line 288
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "fournisseur", [], "any", false, false, false, 288), "nom", [], "any", false, false, false, 288), "html", null, true);
                        yield "</td>
                                <td>";
                        // line 289
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantTotal", [], "any", false, false, false, 289), 2, ",", " "), "html", null, true);
                        yield " MAD</td>
                                <td>";
                        // line 290
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantPaye", [], "method", false, false, false, 290), 2, ",", " "), "html", null, true);
                        yield " MAD</td>
                                <td style=\"color: ";
                        // line 291
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantRestant", [], "any", false, false, false, 291) > 0)) ? ("var(--warning)") : ("var(--success)"));
                        yield ";\">
                                    ";
                        // line 292
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "montantRestant", [], "any", false, false, false, 292), 2, ",", " "), "html", null, true);
                        yield " MAD
                                </td>
                                <td>
                                    <span class=\"badge badge-";
                        // line 295
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 295) == "paye")) ? ("success") : ((((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 295) == "partiel")) ? ("warning") : ("danger"))));
                        yield "\">
                                        ";
                        // line 296
                        yield (((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 296) == "paye")) ? ("Payé") : ((((CoreExtension::getAttribute($this->env, $this->source, $context["achat"], "etatPaiement", [], "any", false, false, false, 296) == "partiel")) ? ("Partiel") : ("Impayé"))));
                        yield "
                                    </span>
                                </td>
                            </tr>
                            ";
                    }
                    $_parent = $context['_parent'];
                    unset($context['_seq'], $context['_key'], $context['achat'], $context['_parent']);
                    $context = array_intersect_key($context, $_parent) + $_parent;
                    // line 301
                    yield "                        </tbody>
                    </table>
                </div>
            </div>
            ";
                }
                // line 306
                yield "
            <!-- Détails des dépenses -->
            ";
                // line 308
                if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "depenses", [], "any", false, false, false, 308)) > 0)) {
                    // line 309
                    yield "            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-depense\">Dépenses (";
                    // line 311
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "depenses", [], "any", false, false, false, 311)), "html", null, true);
                    yield ")</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Libellé</th>
                                <th>Catégorie</th>
                                <th>Montant</th>
                                <th>Utilisateur</th>
                            </tr>
                        </thead>
                        <tbody>
                            ";
                    // line 325
                    $context['_parent'] = $context;
                    $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, $context["bilan"], "depenses", [], "any", false, false, false, 325));
                    foreach ($context['_seq'] as $context["_key"] => $context["depense"]) {
                        // line 326
                        yield "                            <tr>
                                <td>";
                        // line 327
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "dateDepense", [], "any", false, false, false, 327), "d/m/Y"), "html", null, true);
                        yield "</td>
                                <td><strong>";
                        // line 328
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "libelle", [], "any", false, false, false, 328), "html", null, true);
                        yield "</strong></td>
                                <td>
                                    <span class=\"badge\" style=\"background: var(--bg-tertiary);\">
                                        ";
                        // line 331
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::titleCase($this->env->getCharset(), Twig\Extension\CoreExtension::replace(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "categorie", [], "any", false, false, false, 331), ["_" => " "])), "html", null, true);
                        yield "
                                    </span>
                                </td>
                                <td style=\"color: var(--danger); font-weight: 600;\">
                                    ";
                        // line 335
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "montant", [], "any", false, false, false, 335), 2, ",", " "), "html", null, true);
                        yield " MAD
                                </td>
                                <td>";
                        // line 337
                        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["depense"], "utilisateur", [], "any", false, false, false, 337), "getFullName", [], "method", false, false, false, 337), "html", null, true);
                        yield "</td>
                            </tr>
                            ";
                    }
                    $_parent = $context['_parent'];
                    unset($context['_seq'], $context['_key'], $context['depense'], $context['_parent']);
                    $context = array_intersect_key($context, $_parent) + $_parent;
                    // line 340
                    yield "                        </tbody>
                    </table>
                </div>
            </div>
            ";
                }
                // line 345
                yield "        </div>
    </div>
    ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['bilan'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
        } else {
            // line 349
            yield "    <div class=\"alert alert-info\">
        <i class=\"bi bi-info-circle\"></i> Aucune donnée disponible pour afficher le bilan.
    </div>
";
        }
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "bilan/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  647 => 349,  638 => 345,  631 => 340,  622 => 337,  617 => 335,  610 => 331,  604 => 328,  600 => 327,  597 => 326,  593 => 325,  576 => 311,  572 => 309,  570 => 308,  566 => 306,  559 => 301,  548 => 296,  544 => 295,  538 => 292,  534 => 291,  530 => 290,  526 => 289,  522 => 288,  518 => 287,  514 => 286,  511 => 285,  507 => 284,  488 => 268,  484 => 266,  482 => 265,  478 => 263,  471 => 258,  460 => 253,  456 => 252,  450 => 249,  446 => 248,  442 => 247,  438 => 246,  434 => 245,  430 => 244,  426 => 243,  423 => 242,  419 => 241,  400 => 225,  396 => 223,  394 => 222,  385 => 216,  380 => 214,  376 => 213,  367 => 207,  362 => 205,  352 => 198,  347 => 196,  337 => 189,  332 => 187,  317 => 178,  314 => 164,  311 => 163,  309 => 162,  303 => 158,  298 => 157,  296 => 156,  282 => 145,  273 => 139,  261 => 130,  257 => 129,  248 => 123,  239 => 117,  230 => 111,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Bilan détaillé - Red Store{% endblock %}
{% block page_title %}Bilan détaillé{% endblock %}

{% block content %}
<style>
    .bilan-card {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        margin-bottom: 2rem;
    }

    .bilan-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--border);
        margin-bottom: 1.5rem;
    }

    .bilan-total-card {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border-radius: 1rem;
        padding: 2rem;
        margin-bottom: 2rem;
    }

    .stat-box {
        background: var(--bg-secondary);
        border-radius: 0.5rem;
        padding: 1rem;
        text-align: center;
    }

    .stat-value {
        font-size: 1.5rem;
        font-weight: 700;
        margin: 0.5rem 0;
    }

    .stat-label {
        font-size: 0.875rem;
        color: var(--text-secondary);
        text-transform: uppercase;
    }

    .mois-section {
        margin-bottom: 3rem;
    }

    .mois-header {
        background: var(--primary);
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 0.5rem 0.5rem 0 0;
        font-weight: 600;
        font-size: 1.125rem;
    }

    .table-detail {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 1rem;
    }

    .table-detail th,
    .table-detail td {
        padding: 0.75rem;
        text-align: left;
        border-bottom: 1px solid var(--border);
    }

    .table-detail th {
        background: var(--bg-secondary);
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
    }

    .badge-vente {
        background: #d1fae5;
        color: #065f46;
    }

    .badge-achat {
        background: #fee2e2;
        color: #991b1b;
    }

    .badge-depense {
        background: #fef3c7;
        color: #92400e;
    }
</style>

<!-- Bilan Total -->
<div class=\"bilan-total-card\">
    <h2 class=\"mb-4\">
        <i class=\"bi bi-calculator\"></i> Bilan Total Actuel
    </h2>
    <div class=\"row g-4\">
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Ventes</div>
                <div class=\"stat-value\" style=\"color: white;\">{{ bilanTotal.totalVentes|number_format(2, ',', ' ') }} MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Achats</div>
                <div class=\"stat-value\" style=\"color: white;\">{{ bilanTotal.totalAchats|number_format(2, ',', ' ') }} MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Total Dépenses</div>
                <div class=\"stat-value\" style=\"color: white;\">{{ bilanTotal.totalDepenses|number_format(2, ',', ' ') }} MAD</div>
            </div>
        </div>
        <div class=\"col-md-3\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Profit Net</div>
                <div class=\"stat-value\" style=\"color: white; {{ bilanTotal.profitNet >= 0 ? '' : 'color: #fee2e2;' }}\">
                    {{ bilanTotal.profitNet|number_format(2, ',', ' ') }} MAD
                </div>
            </div>
        </div>
    </div>
    <div class=\"row g-4 mt-2\">
        <div class=\"col-md-6\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Crédits Clients</div>
                <div class=\"stat-value\" style=\"color: #fee2e2;\">{{ bilanTotal.totalCreditsClients|number_format(2, ',', ' ') }} MAD</div>
            </div>
        </div>
        <div class=\"col-md-6\">
            <div class=\"stat-box\" style=\"background: rgba(255,255,255,0.2);\">
                <div class=\"stat-label\" style=\"color: rgba(255,255,255,0.9);\">Dettes Fournisseurs</div>
                <div class=\"stat-value\" style=\"color: #fef3c7;\">{{ bilanTotal.totalDettesFournisseurs|number_format(2, ',', ' ') }} MAD</div>
            </div>
        </div>
    </div>
</div>

<!-- Bilans par mois -->
<h3 class=\"mb-4\">
    <i class=\"bi bi-calendar-month\"></i> Bilans par mois
</h3>

{% if bilansParMois|length > 0 %}
    {% for bilan in bilansParMois %}
    <div class=\"mois-section\">
        <div class=\"bilan-card\">
            <div class=\"mois-header\">
                <i class=\"bi bi-calendar3\"></i> 
                {% set moisNum = bilan.mois|split('-')[1] %}
                {% set annee = bilan.mois|split('-')[0] %}
                {% set moisNoms = {
                    '01': 'Janvier',
                    '02': 'Février',
                    '03': 'Mars',
                    '04': 'Avril',
                    '05': 'Mai',
                    '06': 'Juin',
                    '07': 'Juillet',
                    '08': 'Août',
                    '09': 'Septembre',
                    '10': 'Octobre',
                    '11': 'Novembre',
                    '12': 'Décembre'
                } %}
                {{ moisNoms[moisNum] }} {{ annee }}
            </div>

            <!-- Résumé du mois -->
            <div class=\"row g-3 mb-4\">
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Ventes</div>
                        <div class=\"stat-value\" style=\"color: var(--success);\">
                            {{ bilan.totalVentes|number_format(2, ',', ' ') }} MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">{{ bilan.ventes|length }} vente(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Achats</div>
                        <div class=\"stat-value\" style=\"color: var(--danger);\">
                            {{ bilan.totalAchats|number_format(2, ',', ' ') }} MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">{{ bilan.achats|length }} achat(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Dépenses</div>
                        <div class=\"stat-value\" style=\"color: var(--warning);\">
                            {{ bilan.totalDepenses|number_format(2, ',', ' ') }} MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">{{ bilan.depenses|length }} dépense(s)</small>
                    </div>
                </div>
                <div class=\"col-md-3\">
                    <div class=\"stat-box\">
                        <div class=\"stat-label\">Profit Net</div>
                        <div class=\"stat-value\" style=\"color: {{ bilan.profitNet >= 0 ? 'var(--success)' : 'var(--danger)' }};\">
                            {{ bilan.profitNet|number_format(2, ',', ' ') }} MAD
                        </div>
                        <small style=\"color: var(--text-secondary);\">Profit brut: {{ bilan.profitBrut|number_format(2, ',', ' ') }} MAD</small>
                    </div>
                </div>
            </div>

            <!-- Détails des ventes -->
            {% if bilan.ventes|length > 0 %}
            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-vente\">Ventes ({{ bilan.ventes|length }})</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Facture</th>
                                <th>Client</th>
                                <th>Montant</th>
                                <th>Payé</th>
                                <th>Reste</th>
                                <th>Statut</th>
                            </tr>
                        </thead>
                        <tbody>
                            {% for vente in bilan.ventes %}
                            <tr>
                                <td>{{ vente.dateVente|date('d/m/Y') }}</td>
                                <td><strong>{{ vente.numeroFacture }}</strong></td>
                                <td>{{ vente.client ? vente.client.nom : 'Client rapide' }}</td>
                                <td>{{ vente.montantFinal|number_format(2, ',', ' ') }} MAD</td>
                                <td>{{ vente.montantPaye|number_format(2, ',', ' ') }} MAD</td>
                                <td style=\"color: {{ vente.montantRestant > 0 ? 'var(--danger)' : 'var(--success)' }};\">
                                    {{ vente.montantRestant|number_format(2, ',', ' ') }} MAD
                                </td>
                                <td>
                                    <span class=\"badge badge-{{ vente.statutPaiement == 'paye' ? 'success' : (vente.statutPaiement == 'partiel' ? 'warning' : 'danger') }}\">
                                        {{ vente.statutPaiement == 'paye' ? 'Payé' : (vente.statutPaiement == 'partiel' ? 'Partiel' : 'Impayé') }}
                                    </span>
                                </td>
                            </tr>
                            {% endfor %}
                        </tbody>
                    </table>
                </div>
            </div>
            {% endif %}

            <!-- Détails des achats -->
            {% if bilan.achats|length > 0 %}
            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-achat\">Achats ({{ bilan.achats|length }})</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Facture</th>
                                <th>Fournisseur</th>
                                <th>Montant Total</th>
                                <th>Payé</th>
                                <th>Reste</th>
                                <th>État</th>
                            </tr>
                        </thead>
                        <tbody>
                            {% for achat in bilan.achats %}
                            <tr>
                                <td>{{ achat.dateAchat|date('d/m/Y') }}</td>
                                <td><strong>{{ achat.numeroFacture }}</strong></td>
                                <td>{{ achat.fournisseur.nom }}</td>
                                <td>{{ achat.montantTotal|number_format(2, ',', ' ') }} MAD</td>
                                <td>{{ achat.montantPaye()|number_format(2, ',', ' ') }} MAD</td>
                                <td style=\"color: {{ achat.montantRestant > 0 ? 'var(--warning)' : 'var(--success)' }};\">
                                    {{ achat.montantRestant|number_format(2, ',', ' ') }} MAD
                                </td>
                                <td>
                                    <span class=\"badge badge-{{ achat.etatPaiement == 'paye' ? 'success' : (achat.etatPaiement == 'partiel' ? 'warning' : 'danger') }}\">
                                        {{ achat.etatPaiement == 'paye' ? 'Payé' : (achat.etatPaiement == 'partiel' ? 'Partiel' : 'Impayé') }}
                                    </span>
                                </td>
                            </tr>
                            {% endfor %}
                        </tbody>
                    </table>
                </div>
            </div>
            {% endif %}

            <!-- Détails des dépenses -->
            {% if bilan.depenses|length > 0 %}
            <div class=\"mb-4\">
                <h5 class=\"mb-3\">
                    <span class=\"badge badge-depense\">Dépenses ({{ bilan.depenses|length }})</span>
                </h5>
                <div class=\"table-responsive\">
                    <table class=\"table-detail\">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Libellé</th>
                                <th>Catégorie</th>
                                <th>Montant</th>
                                <th>Utilisateur</th>
                            </tr>
                        </thead>
                        <tbody>
                            {% for depense in bilan.depenses %}
                            <tr>
                                <td>{{ depense.dateDepense|date('d/m/Y') }}</td>
                                <td><strong>{{ depense.libelle }}</strong></td>
                                <td>
                                    <span class=\"badge\" style=\"background: var(--bg-tertiary);\">
                                        {{ depense.categorie|replace({'_': ' '})|title }}
                                    </span>
                                </td>
                                <td style=\"color: var(--danger); font-weight: 600;\">
                                    {{ depense.montant|number_format(2, ',', ' ') }} MAD
                                </td>
                                <td>{{ depense.utilisateur.getFullName() }}</td>
                            </tr>
                            {% endfor %}
                        </tbody>
                    </table>
                </div>
            </div>
            {% endif %}
        </div>
    </div>
    {% endfor %}
{% else %}
    <div class=\"alert alert-info\">
        <i class=\"bi bi-info-circle\"></i> Aucune donnée disponible pour afficher le bilan.
    </div>
{% endif %}
{% endblock %}

", "bilan/index.html.twig", "/var/www/html/templates/bilan/index.html.twig");
    }
}
