<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* vente/nouvelle.html.twig */
class __TwigTemplate_869cefa55317d6338bd874004b02d843 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/nouvelle.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/nouvelle.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Nouvelle vente - Red Store";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Nouvelle vente";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .vente-container {
        display: grid;
        grid-template-columns: 1fr 400px;
        gap: 1.5rem;
        height: calc(100vh - 200px);
    }

    .vente-main {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .vente-sidebar {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        overflow-y: auto;
    }

    .search-section {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        margin-bottom: 1rem;
    }

    .barcode-scanner {
        position: relative;
    }

    .barcode-scanner input {
        font-size: 1.25rem;
        letter-spacing: 2px;
        text-align: center;
    }

    .produits-liste {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 1rem;
        max-height: 300px;
        overflow-y: auto;
        padding: 1rem;
        background: var(--bg-secondary);
        border-radius: 0.5rem;
    }

    .produit-card-select {
        background: white;
        border: 2px solid var(--border);
        border-radius: 0.5rem;
        padding: 1rem;
        cursor: pointer;
        transition: all 0.2s;
    }

    .produit-card-select:hover {
        border-color: var(--primary);
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .lignes-vente {
        flex: 1;
        overflow-y: auto;
        background: white;
        border-radius: 1rem;
        padding: 1rem;
        border: 1px solid var(--border);
    }

    .ligne-vente {
        display: grid;
        grid-template-columns: 2fr 1fr 1fr 1fr 1fr auto;
        gap: 1rem;
        padding: 1rem;
        border-bottom: 1px solid var(--border);
        align-items: center;
    }

    .ligne-vente:last-child {
        border-bottom: none;
    }

    .ligne-vente-header {
        font-weight: 600;
        color: var(--text-secondary);
        font-size: 0.875rem;
        text-transform: uppercase;
        margin-bottom: 0.5rem;
    }

    .alert-marge {
        background: #fee2e2;
        color: #991b1b;
        padding: 0.5rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    .summary-card {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border-radius: 1rem;
        padding: 1.5rem;
        margin-bottom: 1rem;
    }

    .summary-value {
        font-size: 2rem;
        font-weight: 700;
    }
</style>

<div class=\"vente-container\">
    <div class=\"vente-main\">
        <!-- Section 1: Recherche et sélection de produits -->
        <div class=\"search-section\">
            <h5 class=\"mb-3\">
                <i class=\"bi bi-search\"></i> Rechercher un produit
            </h5>
            
            <!-- Scanner code-barres -->
            <div class=\"mb-3\">
                <label class=\"form-label\">Scanner code-barres</label>
                <div class=\"barcode-scanner\">
                    <input type=\"text\" 
                           id=\"barcode-input\" 
                           class=\"form-control\" 
                           placeholder=\"Scannez ou saisissez le code-barres\"
                           autofocus>
                </div>
            </div>

            <!-- Recherche par nom / IMEI / Référence -->
            <div class=\"mb-3\">
                <label class=\"form-label\">Recherche par nom, IMEI, référence</label>
                <input type=\"text\" 
                       id=\"produit-search\" 
                       class=\"form-control\" 
                       placeholder=\"Tapez pour rechercher...\">
                <div id=\"produit-search-results\" class=\"mt-2\" style=\"display: none;\">
                    <div class=\"list-group\">
                        <!-- Résultats de recherche -->
                    </div>
                </div>
            </div>

            <!-- Liste des sous-catégories (affichage initial) -->
            <div id=\"sous-categories-section\">
                <label class=\"form-label\">
                    Choisir une sous-catégorie
                    <span class=\"badge bg-primary\">";
        // line 165
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["sousCategories"]) || array_key_exists("sousCategories", $context) ? $context["sousCategories"] : (function () { throw new RuntimeError('Variable "sousCategories" does not exist.', 165, $this->source); })())), "html", null, true);
        yield " sous-catégorie(s) disponible(s)</span>
                </label>
                ";
        // line 167
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["sousCategories"]) || array_key_exists("sousCategories", $context) ? $context["sousCategories"] : (function () { throw new RuntimeError('Variable "sousCategories" does not exist.', 167, $this->source); })())) > 0)) {
            // line 168
            yield "                <div class=\"produits-liste\" id=\"sous-categories-liste\">
                    ";
            // line 169
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["sousCategories"]) || array_key_exists("sousCategories", $context) ? $context["sousCategories"] : (function () { throw new RuntimeError('Variable "sousCategories" does not exist.', 169, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["sousCategorie"]) {
                // line 170
                yield "                    <div class=\"produit-card-select\" 
                         data-sous-categorie-id=\"";
                // line 171
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["sousCategorie"], "id", [], "any", false, false, false, 171), "html", null, true);
                yield "\"
                         onclick=\"chargerProduitsSousCategorie(";
                // line 172
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["sousCategorie"], "id", [], "any", false, false, false, 172), "html", null, true);
                yield ", '";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["sousCategorie"], "nom", [], "any", false, false, false, 172), "html", null, true);
                yield "')\"
                         style=\"cursor: pointer; border: 2px solid var(--primary);\">
                        <div style=\"font-weight: 700; font-size: 1rem; margin-bottom: 0.5rem; color: var(--primary);\">
                            <i class=\"bi bi-folder-fill\"></i> ";
                // line 175
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["sousCategorie"], "nom", [], "any", false, false, false, 175), "html", null, true);
                yield "
                        </div>
                        <div style=\"font-size: 0.75rem; color: var(--text-secondary);\">
                            Catégorie: ";
                // line 178
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["sousCategorie"], "categorie", [], "any", false, false, false, 178), "nom", [], "any", false, false, false, 178), "html", null, true);
                yield "
                        </div>
                        <div style=\"font-size: 0.875rem; color: var(--success); margin-top: 0.5rem; font-weight: 600;\">
                            <i class=\"bi bi-box-seam\"></i> Produits disponibles
                        </div>
                    </div>
                    ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['sousCategorie'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 185
            yield "                </div>
                ";
        } else {
            // line 187
            yield "                <div class=\"alert alert-warning\">
                    <i class=\"bi bi-exclamation-triangle\"></i> 
                    Aucune sous-catégorie avec produits disponibles.
                </div>
                ";
        }
        // line 192
        yield "            </div>

            <!-- Liste des produits d'une sous-catégorie (affichage après sélection) -->
            <div id=\"produits-section\" style=\"display: none;\">
                <div class=\"d-flex justify-content-between align-items-center mb-2\">
                    <label class=\"form-label mb-0\">
                        Produits de: <strong id=\"sous-categorie-selectionnee\"></strong>
                    </label>
                    <button type=\"button\" class=\"btn btn-sm btn-outline-secondary\" onclick=\"retourSousCategories()\">
                        <i class=\"bi bi-arrow-left\"></i> Retour aux sous-catégories
                    </button>
                </div>
                <div class=\"produits-liste\" id=\"produits-liste\">
                    <!-- Les produits seront chargés dynamiquement ici -->
                </div>
            </div>
        </div>

        <!-- Section 2: Lignes de vente -->
        <div class=\"lignes-vente\">
            <div class=\"ligne-vente-header\">
                <div class=\"ligne-vente\">
                    <div>Produit</div>
                    <div>Quantité</div>
                    <div>Prix unitaire</div>
                    <div>Marge</div>
                    <div>Total</div>
                    <div></div>
                </div>
            </div>
            <div id=\"lignes-vente-container\">
                <!-- Les lignes de vente seront ajoutées ici -->
            </div>
        </div>
    </div>

    <!-- Sidebar: Résumé et paiement -->
    <div class=\"vente-sidebar\">
        <div class=\"summary-card\">
            <div style=\"font-size: 0.875rem; opacity: 0.9; margin-bottom: 0.5rem;\">Total de la vente</div>
            <div class=\"summary-value\" id=\"total-vente\">0.00 MAD</div>
        </div>

        <!-- Gestion client -->
        <div class=\"mb-3\">
            <h6 class=\"mb-2\">
                <i class=\"bi bi-person\"></i> Client
            </h6>
            <button type=\"button\" 
                    class=\"btn btn-outline-primary btn-sm w-100 mb-2\" 
                    onclick=\"ouvrirModalClient()\">
                <i class=\"bi bi-person-plus\"></i> Sélectionner/Ajouter client
            </button>
            <div id=\"client-selectionne\" style=\"display: none;\">
                <div class=\"alert alert-info\">
                    <strong id=\"client-nom\" style=\"display: block;\"></strong>
                    <small id=\"client-info\" style=\"display: block;\"></small>
                    <button type=\"button\" class=\"btn btn-sm btn-link p-0\" onclick=\"retirerClient()\">
                        Retirer
                    </button>
                </div>
            </div>
        </div>

        <!-- Remise -->
        <div class=\"mb-3\">
            <label class=\"form-label\">Remise</label>
            <div class=\"input-group mb-2\">
                <select class=\"form-select\" id=\"reduction-type\" style=\"max-width: 100px;\">
                    <option value=\"montant\">MAD</option>
                    <option value=\"pourcentage\">%</option>
                </select>
                <input type=\"number\" 
                       id=\"reduction\" 
                       class=\"form-control\" 
                       step=\"0.01\" 
                       min=\"0\" 
                       value=\"0\"
                       oninput=\"calculerTotaux()\">
            </div>
            <div id=\"reduction-appliquee\" style=\"font-size: 0.875rem; color: var(--success);\"></div>
        </div>

        <!-- Total après remise -->
        <div class=\"mb-3\">
            <div style=\"display: flex; justify-content: space-between; font-weight: 600; font-size: 1.125rem;\">
                <span>Total à payer:</span>
                <span id=\"total-final\">0.00 MAD</span>
            </div>
        </div>

        <!-- Paiements -->
        <div class=\"mb-3\">
            <h6 class=\"mb-2\">
                <i class=\"bi bi-cash-coin\"></i> Paiements
            </h6>
            <div id=\"paiements-container\">
                <!-- Les paiements seront ajoutés ici -->
            </div>
            <button type=\"button\" 
                    class=\"btn btn-outline-primary btn-sm w-100 mt-2\" 
                    onclick=\"ajouterPaiement()\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
            <div class=\"mt-2\">
                <div style=\"display: flex; justify-content: space-between; font-size: 0.875rem;\">
                    <span>Payé:</span>
                    <span id=\"montant-paye\" style=\"color: var(--success); font-weight: 600;\">0.00 MAD</span>
                </div>
                <div style=\"display: flex; justify-content: space-between; font-size: 0.875rem;\">
                    <span>Reste:</span>
                    <span id=\"montant-restant\" style=\"color: var(--danger); font-weight: 600;\">0.00 MAD</span>
                </div>
            </div>
        </div>

        <!-- Date limite paiement (si crédit) -->
        <div class=\"mb-3\" id=\"date-limite-container\" style=\"display: none;\">
            <label class=\"form-label\">Date limite de paiement</label>
            <input type=\"date\" 
                   id=\"date-limite-paiement\" 
                   class=\"form-control\">
        </div>

        <!-- Notes -->
        <div class=\"mb-3\">
            <label class=\"form-label\">Notes</label>
            <textarea id=\"notes-vente\" 
                      class=\"form-control\" 
                      rows=\"3\" 
                      placeholder=\"Notes internes...\"></textarea>
        </div>

        <!-- Bouton finaliser -->
        <button type=\"button\" 
                class=\"btn btn-primary-modern btn-modern w-100\" 
                onclick=\"finaliserVente()\"
                id=\"btn-finaliser\">
            <i class=\"bi bi-check-circle-fill\"></i> Confirmer la vente
        </button>
    </div>
</div>

<!-- Modal Client -->
<div class=\"modal fade\" id=\"modalClient\" tabindex=\"-1\">
    <div class=\"modal-dialog modal-lg\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Gérer le client</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <ul class=\"nav nav-tabs mb-3\">
                    <li class=\"nav-item\">
                        <a class=\"nav-link active\" data-bs-toggle=\"tab\" href=\"#select-client\">Sélectionner</a>
                    </li>
                    <li class=\"nav-item\">
                        <a class=\"nav-link\" data-bs-toggle=\"tab\" href=\"#new-client\">Nouveau client</a>
                    </li>
                    <li class=\"nav-item\">
                        <a class=\"nav-link\" data-bs-toggle=\"tab\" href=\"#client-rapide\">Client rapide</a>
                    </li>
                </ul>
                <div class=\"tab-content\">
                    <div class=\"tab-pane fade show active\" id=\"select-client\">
                        <input type=\"text\" 
                               id=\"client-search\" 
                               class=\"form-control mb-3\" 
                               placeholder=\"Rechercher par nom, téléphone, CIN...\">
                        <div id=\"clients-liste\" style=\"max-height: 300px; overflow-y: auto;\">
                            ";
        // line 362
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable((isset($context["clients"]) || array_key_exists("clients", $context) ? $context["clients"] : (function () { throw new RuntimeError('Variable "clients" does not exist.', 362, $this->source); })()));
        foreach ($context['_seq'] as $context["_key"] => $context["client"]) {
            // line 363
            yield "                            <div class=\"card mb-2 client-item\" 
                                 onclick=\"selectionnerClient(";
            // line 364
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "id", [], "any", false, false, false, 364), "html", null, true);
            yield ", '";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "nom", [], "any", false, false, false, 364), "html", null, true);
            yield "', '";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "telephone", [], "any", false, false, false, 364), "html", null, true);
            yield "')\"
                                 style=\"cursor: pointer;\">
                                <div class=\"card-body\">
                                    <h6 class=\"mb-1\">";
            // line 367
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "nom", [], "any", false, false, false, 367), "html", null, true);
            yield "</h6>
                                    <small class=\"text-muted\">";
            // line 368
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["client"], "telephone", [], "any", false, false, false, 368), "html", null, true);
            yield "</small>
                                </div>
                            </div>
                            ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['client'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 372
        yield "                        </div>
                    </div>
                    <div class=\"tab-pane fade\" id=\"new-client\">
                        <form id=\"form-new-client\" enctype=\"multipart/form-data\">
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Nom complet *</label>
                                <input type=\"text\" name=\"client[nom]\" class=\"form-control\" required>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Téléphone *</label>
                                <input type=\"text\" name=\"client[telephone]\" class=\"form-control\" required>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">CIN (optionnel)</label>
                                <input type=\"text\" name=\"client[cin]\" class=\"form-control\">
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Adresse (optionnel)</label>
                                <textarea name=\"client[adresse]\" class=\"form-control\" rows=\"2\"></textarea>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Email (optionnel)</label>
                                <input type=\"email\" name=\"client[email]\" class=\"form-control\">
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Photo de la CIN (optionnel)</label>
                                <input type=\"file\" name=\"client[photoCin]\" class=\"form-control\" accept=\"image/*\">
                            </div>
                            <button type=\"submit\" class=\"btn btn-primary w-100\">Créer et sélectionner</button>
                        </form>
                    </div>
                    <div class=\"tab-pane fade\" id=\"client-rapide\">
                        <div class=\"alert alert-info\">
                            <i class=\"bi bi-info-circle\"></i> 
                            Vente sans enregistrer de client. Les informations client peuvent être ajoutées dans les notes.
                        </div>
                        <div class=\"mb-3\">
                            <label class=\"form-label\">Nom du client (optionnel)</label>
                            <input type=\"text\" id=\"client-rapide-nom\" class=\"form-control\" placeholder=\"Pour référence uniquement\">
                        </div>
                        <button type=\"button\" class=\"btn btn-outline-primary w-100\" onclick=\"selectionnerClientRapide()\">
                            Utiliser client rapide
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let lignesVente = [];
let clientSelectionne = null;
let paiements = [];

// Attendre que le DOM soit chargé
document.addEventListener('DOMContentLoaded', function() {
    // Focus automatique sur le scanner et event listener
    const barcodeInput = document.getElementById('barcode-input');
    if (barcodeInput) {
        barcodeInput.focus();
        barcodeInput.addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        const codeBarres = this.value.trim();
        if (codeBarres) {
            ajouterProduitParCodeBarres(codeBarres);
            this.value = '';
        }
    }
});
    }

// Recherche de produits
let searchTimeout;
    const produitSearch = document.getElementById('produit-search');
    if (produitSearch) {
        produitSearch.addEventListener('input', function() {
    clearTimeout(searchTimeout);
    const query = this.value.trim();
    
    if (query.length < 2) {
                const results = document.getElementById('produit-search-results');
                if (results) {
                    results.style.display = 'none';
                }
        return;
    }

    searchTimeout = setTimeout(() => {
        fetch(`";
        // line 461
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_api_recherche_produit");
        yield "?q=\${encodeURIComponent(query)}`)
            .then(response => response.json())
            .then(data => {
                const container = document.getElementById('produit-search-results');
                const listGroup = container.querySelector('.list-group');
                listGroup.innerHTML = '';
                
                if (data.length > 0) {
                    container.style.display = 'block';
                    data.forEach(produit => {
                        const item = document.createElement('a');
                        item.className = 'list-group-item list-group-item-action';
                        item.innerHTML = `
                            <div class=\"d-flex justify-content-between\">
                                <div>
                                    <strong>\${produit.nom}</strong><br>
                                    <small class=\"text-muted\">\${produit.codeBarres} | \${produit.referenceInterne || ''}</small>
                                </div>
                                <div class=\"text-end\">
                                    <strong>\${parseFloat(produit.prixVenteRecommande || produit.prixAchat).toFixed(2)} MAD</strong>
                                </div>
                            </div>
                        `;
                        item.onclick = () => {
                            ajouterProduit(produit.id);
                            document.getElementById('produit-search').value = '';
                            container.style.display = 'none';
                        };
                        listGroup.appendChild(item);
                    });
                } else {
                    container.style.display = 'none';
                }
            });
    }, 300);
});
    }
}); // Fin du DOMContentLoaded

// Fonctions globales (définies en dehors du DOMContentLoaded)
// Ajouter produit par code-barres
async function ajouterProduitParCodeBarres(codeBarres) {
    try {
        const response = await fetch('";
        // line 504
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_nouvelle");
        yield "', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: new URLSearchParams({
                code_barres: codeBarres
            })
        });
        
        const data = await response.json();
        if (data.error) {
            alert(data.error);
            return;
        }
        
        ajouterLigneVente(data);
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'ajout du produit');
    }
}

// Charger les produits d'une sous-catégorie
async function chargerProduitsSousCategorie(sousCategorieId, sousCategorieNom) {
    try {
        const response = await fetch(`";
        // line 531
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_api_produits_sous_categorie", ["sousCategorieId" => "PLACEHOLDER"]);
        yield "`.replace('PLACEHOLDER', sousCategorieId), {
            method: 'GET',
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            credentials: 'same-origin'
        });
        
        const produits = await response.json();
        
        if (produits.error) {
            alert(produits.error);
            return;
        }
        
        // Afficher la section produits et masquer les sous-catégories
        document.getElementById('sous-categories-section').style.display = 'none';
        document.getElementById('produits-section').style.display = 'block';
        document.getElementById('sous-categorie-selectionnee').textContent = sousCategorieNom;
        
        // Afficher les produits
        const container = document.getElementById('produits-liste');
        container.innerHTML = '';
        
        if (produits.length === 0) {
            container.innerHTML = '<div class=\"alert alert-info\">Aucun produit disponible dans cette sous-catégorie</div>';
            return;
        }
        
        produits.forEach(produit => {
            const div = document.createElement('div');
            div.className = 'produit-card-select';
            div.setAttribute('data-produit-id', produit.id);
            div.onclick = () => ajouterProduit(produit.id);
            div.title = `\${produit.nom} - Stock: \${produit.quantite}`;
            div.innerHTML = `
                <div style=\"font-weight: 600; font-size: 0.875rem; margin-bottom: 0.25rem;\">
                    \${produit.nom.length > 30 ? produit.nom.substring(0, 30) + '...' : produit.nom}
                </div>
                <div style=\"font-size: 0.7rem; color: var(--text-secondary); margin-bottom: 0.25rem;\">
                    \${produit.codeBarres}
                </div>
                \${produit.referenceInterne ? `<div style=\"font-size: 0.7rem; color: var(--text-tertiary); margin-bottom: 0.25rem;\">Ref: \${produit.referenceInterne}</div>` : ''}
                <div style=\"font-size: 0.875rem; color: var(--primary); font-weight: 600; margin-top: 0.5rem;\">
                    \${parseFloat(produit.prixVenteRecommande || produit.prixAchat).toFixed(2)} MAD
                </div>
                <div style=\"font-size: 0.7rem; color: var(--success); margin-top: 0.25rem;\">
                    Stock: \${produit.quantite}
                </div>
            `;
            container.appendChild(div);
        });
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors du chargement des produits');
    }
}

function retourSousCategories() {
    document.getElementById('sous-categories-section').style.display = 'block';
    document.getElementById('produits-section').style.display = 'none';
    document.getElementById('produits-liste').innerHTML = '';
}

// Ajouter produit par ID
async function ajouterProduit(produitId) {
    try {
        const response = await fetch('";
        // line 599
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_nouvelle");
        yield "', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: new URLSearchParams({
                produit_id: produitId
            })
        });
        
        const data = await response.json();
        if (data.error) {
            alert(data.error);
            return;
        }
        
        ajouterLigneVente(data);
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'ajout du produit');
    }
}

// Ajouter une ligne de vente
function ajouterLigneVente(produit) {
    const ligne = {
        produit_id: produit.id,
        nom: produit.nom,
        codeBarres: produit.codeBarres,
        referenceInterne: produit.referenceInterne,
        imei: produit.imei,
        numeroSerie: produit.numeroSerie,
        prixAchat: parseFloat(produit.prixAchat),
        prixVenteRecommande: parseFloat(produit.prixVenteRecommande || produit.prixAchat),
        margeMinimale: parseFloat(produit.margeMinimale || 0),
        quantite: 1,
        prixVente: parseFloat(produit.prixVenteRecommande || produit.prixAchat),
        caracteristiques: produit.caracteristiques || {}
    };
    
    lignesVente.push(ligne);
    afficherLignesVente();
    calculerTotaux();
}

// Afficher les lignes de vente
function afficherLignesVente() {
    const container = document.getElementById('lignes-vente-container');
    container.innerHTML = '';
    
    lignesVente.forEach((ligne, index) => {
        const marge = ligne.prixVente - ligne.prixAchat;
        const margeTotal = marge * ligne.quantite;
        const total = ligne.prixVente * ligne.quantite;
        const alertMarge = marge < ligne.margeMinimale ? 
            `<div class=\"alert-marge\">⚠️ Marge inférieure au minimum (\${ligne.margeMinimale.toFixed(2)} MAD)</div>` : '';
        
        const div = document.createElement('div');
        div.className = 'ligne-vente';
        div.innerHTML = `
            <div>
                <strong>\${ligne.nom}</strong>
                \${ligne.imei ? `<br><small class=\"text-muted\">IMEI: \${ligne.imei}</small>` : ''}
                \${ligne.referenceInterne ? `<br><small class=\"text-muted\">Ref: \${ligne.referenceInterne}</small>` : ''}
                \${alertMarge}
            </div>
            <div>
                <input type=\"number\" 
                       class=\"form-control\" 
                       value=\"\${ligne.quantite}\" 
                       min=\"1\" 
                       max=\"\${ligne.quantite}\"
                       onchange=\"modifierQuantite(\${index}, this.value)\">
            </div>
            <div>
                <input type=\"number\" 
                       class=\"form-control\" 
                       value=\"\${ligne.prixVente.toFixed(2)}\" 
                       step=\"0.01\" 
                       min=\"0\"
                       onchange=\"modifierPrixVente(\${index}, this.value)\">
                <small class=\"text-muted\">Achat: \${ligne.prixAchat.toFixed(2)} MAD</small>
            </div>
            <div>
                <span style=\"color: \${marge >= 0 ? 'var(--success)' : 'var(--danger)'}; font-weight: 600;\">
                    \${margeTotal.toFixed(2)} MAD
                </span>
                <br><small class=\"text-muted\">\${((marge / ligne.prixAchat) * 100).toFixed(1)}%</small>
            </div>
            <div>
                <strong>\${total.toFixed(2)} MAD</strong>
            </div>
            <div>
                <button type=\"button\" 
                        class=\"btn btn-sm btn-danger\" 
                        onclick=\"supprimerLigne(\${index})\">
                    <i class=\"bi bi-trash\"></i>
                </button>
            </div>
        `;
        container.appendChild(div);
    });
}

function modifierQuantite(index, quantite) {
    lignesVente[index].quantite = parseInt(quantite);
    afficherLignesVente();
    calculerTotaux();
}

function modifierPrixVente(index, prix) {
    lignesVente[index].prixVente = parseFloat(prix);
    afficherLignesVente();
    calculerTotaux();
}

function supprimerLigne(index) {
    lignesVente.splice(index, 1);
    afficherLignesVente();
    calculerTotaux();
}

function calculerTotaux() {
    let total = 0;
    lignesVente.forEach(ligne => {
        total += ligne.prixVente * ligne.quantite;
    });
    
    const reductionType = document.getElementById('reduction-type').value;
    const reduction = parseFloat(document.getElementById('reduction').value || 0);
    let reductionAppliquee = 0;
    
    if (reductionType === 'pourcentage') {
        reductionAppliquee = (total * reduction) / 100;
    } else {
        reductionAppliquee = reduction;
    }
    
    const totalFinal = total - reductionAppliquee;
    
    document.getElementById('total-vente').textContent = total.toFixed(2) + ' MAD';
    document.getElementById('total-final').textContent = totalFinal.toFixed(2) + ' MAD';
    
    if (reductionAppliquee > 0) {
        document.getElementById('reduction-appliquee').textContent = 
            `Remise: -\${reductionAppliquee.toFixed(2)} MAD`;
    } else {
        document.getElementById('reduction-appliquee').textContent = '';
    }
    
    calculerPaiements();
}

function calculerPaiements() {
    const totalFinal = parseFloat(document.getElementById('total-final').textContent.replace(' MAD', ''));
    let montantPaye = 0;
    
    paiements.forEach(p => {
        montantPaye += parseFloat(p.montant);
    });
    
    const montantRestant = totalFinal - montantPaye;
    
    document.getElementById('montant-paye').textContent = montantPaye.toFixed(2) + ' MAD';
    document.getElementById('montant-restant').textContent = montantRestant.toFixed(2) + ' MAD';
    
    // Afficher/masquer date limite si crédit
    if (montantRestant > 0) {
        document.getElementById('date-limite-container').style.display = 'block';
    } else {
        document.getElementById('date-limite-container').style.display = 'none';
    }
}

// Gestion client
function ouvrirModalClient() {
    const modal = new bootstrap.Modal(document.getElementById('modalClient'));
    modal.show();
}

function selectionnerClient(id, nom, telephone) {
    console.log('🔄 selectionnerClient appelé avec:', { id, nom, telephone });
    
    try {
        // Mettre à jour la variable globale
    clientSelectionne = { id, nom, telephone };
        
        // Préparer les valeurs
        const nomValue = String(nom || '').trim() || 'Client sans nom';
        const telValue = String(telephone || '').trim() || 'Pas de téléphone';
        
        console.log('📋 Valeurs préparées:', { nom: nomValue, tel: telValue });
        
        // Fonction pour mettre à jour l'affichage - version simplifiée
        const updateDisplay = () => {
            const sidebar = document.querySelector('.vente-sidebar');
            if (!sidebar) {
                console.error('❌ Sidebar non trouvée');
                return false;
            }
            
            // Chercher ou créer le div client-selectionne
            let clientDiv = sidebar.querySelector('#client-selectionne');
            
            if (!clientDiv) {
                // Chercher la section client
                const sections = sidebar.querySelectorAll('.mb-3');
                let clientSection = null;
                
                for (let section of sections) {
                    const btn = section.querySelector('button[onclick*=\"ouvrirModalClient\"]');
                    if (btn) {
                        clientSection = section;
                        break;
                    }
                }
                
                if (clientSection) {
                    // Créer le div s'il n'existe pas
                    clientDiv = document.createElement('div');
                    clientDiv.id = 'client-selectionne';
                    clientDiv.style.display = 'block';
                    clientDiv.innerHTML = `
                        <div class=\"alert alert-info\">
                            <strong id=\"client-nom\" style=\"display: block;\"></strong>
                            <small id=\"client-info\" style=\"display: block;\"></small>
                            <button type=\"button\" class=\"btn btn-sm btn-link p-0\" onclick=\"retirerClient()\">
                                Retirer
                            </button>
                        </div>
                    `;
                    clientSection.appendChild(clientDiv);
                    console.log('✅ Div client créé');
                } else {
                    console.error('❌ Section client non trouvée');
                    return false;
                }
            }
            
            // Mettre à jour le contenu
            const nomEl = clientDiv.querySelector('#client-nom');
            const infoEl = clientDiv.querySelector('#client-info');
            
            if (nomEl && infoEl) {
                nomEl.textContent = nomValue;
                nomEl.innerHTML = nomValue;
                infoEl.textContent = telValue;
                infoEl.innerHTML = telValue;
                
                // Forcer l'affichage avec plusieurs méthodes
                clientDiv.style.display = 'block';
                clientDiv.style.visibility = 'visible';
                clientDiv.removeAttribute('hidden');
                clientDiv.setAttribute('data-client-id', id);
                clientDiv.classList.remove('d-none');
                clientDiv.classList.add('d-block');
                
                // Vérifier périodiquement que le div reste visible
                let checkCount = 0;
                const checkInterval = setInterval(() => {
                    checkCount++;
                    if (checkCount > 10) {
                        clearInterval(checkInterval);
                        return;
                    }
                    
                    if (clientDiv && clientDiv.style.display === 'none') {
                        console.warn('⚠️ Le div a été masqué, on le réaffiche');
                        clientDiv.style.display = 'block';
                        clientDiv.style.visibility = 'visible';
                    }
                }, 200);
                
                console.log('✅ Client affiché:', { id, nom: nomValue, tel: telValue });
                return true;
            } else {
                console.error('❌ Éléments nom/info non trouvés dans le div');
                return false;
            }
        };
        
        // Fermer la modal APRÈS avoir mis à jour l'affichage
        // Mettre à jour l'affichage d'abord
        if (updateDisplay()) {
            console.log('✅ Client affiché avant fermeture modal');
            // Fermer la modal après un court délai pour laisser l'affichage se stabiliser
            setTimeout(() => {
                const modalEl = document.getElementById('modalClient');
                const modal = modalEl ? bootstrap.Modal.getInstance(modalEl) : null;
                if (modal) {
                    modal.hide();
                }
            }, 100);
        } else {
            // Si l'affichage n'a pas fonctionné, fermer la modal et réessayer
            const modalEl = document.getElementById('modalClient');
            const modal = modalEl ? bootstrap.Modal.getInstance(modalEl) : null;
            if (modal) {
                modal.hide();
                
                // Attendre que la modal soit fermée puis réessayer
                const handleHidden = () => {
                    setTimeout(() => {
                        if (!updateDisplay()) {
                            setTimeout(() => updateDisplay(), 300);
                        }
                    }, 400);
                    modalEl.removeEventListener('hidden.bs.modal', handleHidden);
                };
                modalEl.addEventListener('hidden.bs.modal', handleHidden);
            } else {
                // Pas de modal, réessayer
                setTimeout(() => {
                    if (!updateDisplay()) {
                        setTimeout(() => updateDisplay(), 300);
                    }
                }, 200);
            }
        }
    } catch (error) {
        console.error('❌ Erreur dans selectionnerClient:', error);
        alert('Erreur: ' + error.message);
    }
}

function selectionnerClientRapide() {
    try {
        const nomInput = document.getElementById('client-rapide-nom');
        const nom = nomInput ? nomInput.value : '';
    clientSelectionne = { rapide: true, nom: nom || 'Client rapide' };
        
        // Fonction helper pour mettre à jour l'affichage
        const updateClientDisplay = () => {
            const clientNomEl = document.getElementById('client-nom');
            const clientInfoEl = document.getElementById('client-info');
            const clientSelectionneEl = document.getElementById('client-selectionne');
            
            if (clientNomEl && clientInfoEl && clientSelectionneEl) {
                clientNomEl.textContent = clientSelectionne.nom;
                clientInfoEl.textContent = 'Vente sans client enregistré';
                clientSelectionneEl.style.display = 'block';
                return true;
            }
            return false;
        };
        
        // Essayer immédiatement
        if (updateClientDisplay()) {
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
            if (modal) {
                modal.hide();
            }
            return;
        }
        
        // Si les éléments ne sont pas trouvés, attendre un peu et réessayer
        setTimeout(() => {
            if (!updateClientDisplay()) {
                setTimeout(() => {
                    if (!updateClientDisplay()) {
                        console.error('Éléments client non trouvés après plusieurs tentatives');
                        alert('Erreur: impossible de mettre à jour l\\'affichage. Veuillez recharger la page.');
                    } else {
                        const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
                        if (modal) {
                            modal.hide();
                        }
                    }
                }, 200);
            } else {
                const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
                if (modal) {
                    modal.hide();
                }
            }
        }, 100);
    } catch (error) {
        console.error('Erreur dans selectionnerClientRapide:', error);
        alert('Erreur lors de la sélection du client rapide: ' + error.message);
    }
}

function retirerClient() {
    clientSelectionne = null;
    document.getElementById('client-selectionne').style.display = 'none';
}

// Gestion paiements
function ajouterPaiement() {
    const montantRestant = parseFloat(document.getElementById('montant-restant').textContent.replace(' MAD', ''));
    
    const div = document.createElement('div');
    div.className = 'card mb-2';
    div.innerHTML = `
        <div class=\"card-body\">
            <div class=\"row g-2\">
                <div class=\"col-6\">
                    <input type=\"number\" class=\"form-control form-control-sm\" placeholder=\"Montant\" step=\"0.01\" min=\"0\" onchange=\"mettreAJourPaiement(this)\">
                </div>
                <div class=\"col-6\">
                    <select class=\"form-select form-select-sm\" onchange=\"mettreAJourPaiement(this)\">
                        <option value=\"cash\">Cash</option>
                        <option value=\"carte\">Carte</option>
                        <option value=\"virement\">Virement</option>
                        <option value=\"cheque\">Chèque</option>
                    </select>
                </div>
                <div class=\"col-12\">
                    <input type=\"text\" class=\"form-control form-control-sm\" placeholder=\"Référence (optionnel)\" onchange=\"mettreAJourPaiement(this)\">
                </div>
                <div class=\"col-12\">
                    <button type=\"button\" class=\"btn btn-sm btn-danger w-100\" onclick=\"supprimerPaiement(this)\">
                        <i class=\"bi bi-trash\"></i> Supprimer
                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.getElementById('paiements-container').appendChild(div);
    mettreAJourPaiements();
}

function mettreAJourPaiement(input) {
    mettreAJourPaiements();
}

function mettreAJourPaiements() {
    paiements = [];
    document.querySelectorAll('#paiements-container .card').forEach(card => {
        const inputs = card.querySelectorAll('input, select');
        if (inputs.length >= 2) {
            paiements.push({
                montant: parseFloat(inputs[0].value || 0),
                mode: inputs[1].value || 'cash',
                reference: inputs[2] ? inputs[2].value : null
            });
        }
    });
    calculerPaiements();
}

function supprimerPaiement(btn) {
    btn.closest('.card').remove();
    mettreAJourPaiements();
}

// Finaliser la vente
async function finaliserVente() {
    if (lignesVente.length === 0) {
        alert('Veuillez ajouter au moins un produit');
        return;
    }
    
    const montantRestant = parseFloat(document.getElementById('montant-restant').textContent.replace(' MAD', ''));
    if (montantRestant > 0 && !clientSelectionne) {
        alert('Un client est obligatoire pour les ventes à crédit');
        return;
    }
    
    const data = {
        lignes: lignesVente.map(l => ({
            produit_id: l.produit_id,
            quantite: l.quantite,
            prix_vente: l.prixVente
        })),
        client_id: clientSelectionne && !clientSelectionne.rapide ? clientSelectionne.id : null,
        client_rapide: clientSelectionne && clientSelectionne.rapide ? { nom: clientSelectionne.nom } : null,
        reduction: document.getElementById('reduction').value,
        reduction_type: document.getElementById('reduction-type').value,
        paiements: paiements,
        date_limite_paiement: document.getElementById('date-limite-paiement').value || null,
        mode_paiement: montantRestant > 0 ? 'credit' : 'cash',
        notes: document.getElementById('notes-vente').value
    };
    
    try {
        const response = await fetch('";
        // line 1077
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_finaliser");
        yield "', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert(result.error);
            return;
        }
        
        if (result.success) {
            window.location.href = result.redirect;
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de la finalisation de la vente');
    }
}

// Event listeners pour les formulaires (ajoutés dans un DOMContentLoaded séparé)
document.addEventListener('DOMContentLoaded', function() {
// Créer nouveau client
    const formNewClient = document.getElementById('form-new-client');
    if (formNewClient) {
        formNewClient.addEventListener('submit', async function(e) {
    e.preventDefault();
            
            // Désactiver le bouton pour éviter les doubles soumissions
            const submitBtn = this.querySelector('button[type=\"submit\"]');
            const originalText = submitBtn.textContent;
            submitBtn.disabled = true;
            submitBtn.textContent = 'Création...';
            
    const formData = new FormData(this);
    
    try {
        const response = await fetch('";
        // line 1119
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("clients_new");
        yield "', {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        });
                
                // Vérifier le statut de la réponse
                if (!response.ok) {
                    const errorText = await response.text();
                    console.error('Erreur HTTP:', response.status, errorText);
                    throw new Error('Erreur serveur: ' + response.status);
                }
        
        const contentType = response.headers.get('content-type');
                let data;
                
        if (contentType && contentType.includes('application/json')) {
                    data = await response.json();
            } else {
                    // Si ce n'est pas du JSON, essayer de parser quand même
            const text = await response.text();
            console.error('Réponse non-JSON:', text.substring(0, 500));
                    try {
                        data = JSON.parse(text);
                    } catch (parseError) {
                        console.error('Erreur de parsing JSON:', parseError);
                        throw new Error('Réponse serveur invalide. Code: ' + response.status + ' - ' + text.substring(0, 100));
                    }
                }
                
                console.log('Réponse serveur:', data);
                
                if (data.success && data.client) {
                    // Réinitialiser le formulaire
                    this.reset();
                    
                    // Vérifier que les données client sont bien présentes
                    console.log('✅ Données client reçues:', data.client);
                    
                    const clientId = data.client.id;
                    const clientNom = String(data.client.nom || '').trim();
                    const clientTel = String(data.client.telephone || '').trim();
                    
                    console.log('📋 Valeurs extraites:', { id: clientId, nom: clientNom, tel: clientTel });
                    
                    if (!clientId) {
                        console.error('❌ ID client manquant:', data.client);
                        alert('Erreur: ID client manquant');
                        return;
                    }
                    
                    if (!clientNom) {
                        console.warn('⚠️ Nom client vide, utilisation de la valeur par défaut');
                    }
                    
                    // Sélectionner le client créé (la fonction gère la fermeture de la modal)
                    console.log('🔄 Appel de selectionnerClient avec:', { id: clientId, nom: clientNom, tel: clientTel });
                    selectionnerClient(clientId, clientNom, clientTel);
                } else {
                    const errorMsg = data.errors || data.error || 'Erreur lors de la création du client';
                    console.error('Erreur de création:', errorMsg);
                    alert('Erreur: ' + errorMsg);
        }
    } catch (error) {
                console.error('Erreur complète:', error);
                alert('Erreur lors de la création du client: ' + (error.message || 'Erreur inconnue'));
            } finally {
                // Réactiver le bouton
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
            }
        });
    }
    
    // Recherche de clients
    const clientSearch = document.getElementById('client-search');
    if (clientSearch) {
        clientSearch.addEventListener('input', function() {
            const query = this.value.toLowerCase();
            const items = document.querySelectorAll('.client-item');
            items.forEach(item => {
                const text = item.textContent.toLowerCase();
                item.style.display = text.includes(query) ? 'block' : 'none';
            });
        });
    }
}); // Fin du DOMContentLoaded pour les event listeners
</script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "vente/nouvelle.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  1310 => 1119,  1265 => 1077,  784 => 599,  713 => 531,  683 => 504,  637 => 461,  546 => 372,  536 => 368,  532 => 367,  522 => 364,  519 => 363,  515 => 362,  343 => 192,  336 => 187,  332 => 185,  319 => 178,  313 => 175,  305 => 172,  301 => 171,  298 => 170,  294 => 169,  291 => 168,  289 => 167,  284 => 165,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Nouvelle vente - Red Store{% endblock %}
{% block page_title %}Nouvelle vente{% endblock %}

{% block content %}
<style>
    .vente-container {
        display: grid;
        grid-template-columns: 1fr 400px;
        gap: 1.5rem;
        height: calc(100vh - 200px);
    }

    .vente-main {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .vente-sidebar {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        overflow-y: auto;
    }

    .search-section {
        background: white;
        border-radius: 1rem;
        padding: 1.5rem;
        border: 1px solid var(--border);
        margin-bottom: 1rem;
    }

    .barcode-scanner {
        position: relative;
    }

    .barcode-scanner input {
        font-size: 1.25rem;
        letter-spacing: 2px;
        text-align: center;
    }

    .produits-liste {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 1rem;
        max-height: 300px;
        overflow-y: auto;
        padding: 1rem;
        background: var(--bg-secondary);
        border-radius: 0.5rem;
    }

    .produit-card-select {
        background: white;
        border: 2px solid var(--border);
        border-radius: 0.5rem;
        padding: 1rem;
        cursor: pointer;
        transition: all 0.2s;
    }

    .produit-card-select:hover {
        border-color: var(--primary);
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .lignes-vente {
        flex: 1;
        overflow-y: auto;
        background: white;
        border-radius: 1rem;
        padding: 1rem;
        border: 1px solid var(--border);
    }

    .ligne-vente {
        display: grid;
        grid-template-columns: 2fr 1fr 1fr 1fr 1fr auto;
        gap: 1rem;
        padding: 1rem;
        border-bottom: 1px solid var(--border);
        align-items: center;
    }

    .ligne-vente:last-child {
        border-bottom: none;
    }

    .ligne-vente-header {
        font-weight: 600;
        color: var(--text-secondary);
        font-size: 0.875rem;
        text-transform: uppercase;
        margin-bottom: 0.5rem;
    }

    .alert-marge {
        background: #fee2e2;
        color: #991b1b;
        padding: 0.5rem;
        border-radius: 0.25rem;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    .summary-card {
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border-radius: 1rem;
        padding: 1.5rem;
        margin-bottom: 1rem;
    }

    .summary-value {
        font-size: 2rem;
        font-weight: 700;
    }
</style>

<div class=\"vente-container\">
    <div class=\"vente-main\">
        <!-- Section 1: Recherche et sélection de produits -->
        <div class=\"search-section\">
            <h5 class=\"mb-3\">
                <i class=\"bi bi-search\"></i> Rechercher un produit
            </h5>
            
            <!-- Scanner code-barres -->
            <div class=\"mb-3\">
                <label class=\"form-label\">Scanner code-barres</label>
                <div class=\"barcode-scanner\">
                    <input type=\"text\" 
                           id=\"barcode-input\" 
                           class=\"form-control\" 
                           placeholder=\"Scannez ou saisissez le code-barres\"
                           autofocus>
                </div>
            </div>

            <!-- Recherche par nom / IMEI / Référence -->
            <div class=\"mb-3\">
                <label class=\"form-label\">Recherche par nom, IMEI, référence</label>
                <input type=\"text\" 
                       id=\"produit-search\" 
                       class=\"form-control\" 
                       placeholder=\"Tapez pour rechercher...\">
                <div id=\"produit-search-results\" class=\"mt-2\" style=\"display: none;\">
                    <div class=\"list-group\">
                        <!-- Résultats de recherche -->
                    </div>
                </div>
            </div>

            <!-- Liste des sous-catégories (affichage initial) -->
            <div id=\"sous-categories-section\">
                <label class=\"form-label\">
                    Choisir une sous-catégorie
                    <span class=\"badge bg-primary\">{{ sousCategories|length }} sous-catégorie(s) disponible(s)</span>
                </label>
                {% if sousCategories|length > 0 %}
                <div class=\"produits-liste\" id=\"sous-categories-liste\">
                    {% for sousCategorie in sousCategories %}
                    <div class=\"produit-card-select\" 
                         data-sous-categorie-id=\"{{ sousCategorie.id }}\"
                         onclick=\"chargerProduitsSousCategorie({{ sousCategorie.id }}, '{{ sousCategorie.nom }}')\"
                         style=\"cursor: pointer; border: 2px solid var(--primary);\">
                        <div style=\"font-weight: 700; font-size: 1rem; margin-bottom: 0.5rem; color: var(--primary);\">
                            <i class=\"bi bi-folder-fill\"></i> {{ sousCategorie.nom }}
                        </div>
                        <div style=\"font-size: 0.75rem; color: var(--text-secondary);\">
                            Catégorie: {{ sousCategorie.categorie.nom }}
                        </div>
                        <div style=\"font-size: 0.875rem; color: var(--success); margin-top: 0.5rem; font-weight: 600;\">
                            <i class=\"bi bi-box-seam\"></i> Produits disponibles
                        </div>
                    </div>
                    {% endfor %}
                </div>
                {% else %}
                <div class=\"alert alert-warning\">
                    <i class=\"bi bi-exclamation-triangle\"></i> 
                    Aucune sous-catégorie avec produits disponibles.
                </div>
                {% endif %}
            </div>

            <!-- Liste des produits d'une sous-catégorie (affichage après sélection) -->
            <div id=\"produits-section\" style=\"display: none;\">
                <div class=\"d-flex justify-content-between align-items-center mb-2\">
                    <label class=\"form-label mb-0\">
                        Produits de: <strong id=\"sous-categorie-selectionnee\"></strong>
                    </label>
                    <button type=\"button\" class=\"btn btn-sm btn-outline-secondary\" onclick=\"retourSousCategories()\">
                        <i class=\"bi bi-arrow-left\"></i> Retour aux sous-catégories
                    </button>
                </div>
                <div class=\"produits-liste\" id=\"produits-liste\">
                    <!-- Les produits seront chargés dynamiquement ici -->
                </div>
            </div>
        </div>

        <!-- Section 2: Lignes de vente -->
        <div class=\"lignes-vente\">
            <div class=\"ligne-vente-header\">
                <div class=\"ligne-vente\">
                    <div>Produit</div>
                    <div>Quantité</div>
                    <div>Prix unitaire</div>
                    <div>Marge</div>
                    <div>Total</div>
                    <div></div>
                </div>
            </div>
            <div id=\"lignes-vente-container\">
                <!-- Les lignes de vente seront ajoutées ici -->
            </div>
        </div>
    </div>

    <!-- Sidebar: Résumé et paiement -->
    <div class=\"vente-sidebar\">
        <div class=\"summary-card\">
            <div style=\"font-size: 0.875rem; opacity: 0.9; margin-bottom: 0.5rem;\">Total de la vente</div>
            <div class=\"summary-value\" id=\"total-vente\">0.00 MAD</div>
        </div>

        <!-- Gestion client -->
        <div class=\"mb-3\">
            <h6 class=\"mb-2\">
                <i class=\"bi bi-person\"></i> Client
            </h6>
            <button type=\"button\" 
                    class=\"btn btn-outline-primary btn-sm w-100 mb-2\" 
                    onclick=\"ouvrirModalClient()\">
                <i class=\"bi bi-person-plus\"></i> Sélectionner/Ajouter client
            </button>
            <div id=\"client-selectionne\" style=\"display: none;\">
                <div class=\"alert alert-info\">
                    <strong id=\"client-nom\" style=\"display: block;\"></strong>
                    <small id=\"client-info\" style=\"display: block;\"></small>
                    <button type=\"button\" class=\"btn btn-sm btn-link p-0\" onclick=\"retirerClient()\">
                        Retirer
                    </button>
                </div>
            </div>
        </div>

        <!-- Remise -->
        <div class=\"mb-3\">
            <label class=\"form-label\">Remise</label>
            <div class=\"input-group mb-2\">
                <select class=\"form-select\" id=\"reduction-type\" style=\"max-width: 100px;\">
                    <option value=\"montant\">MAD</option>
                    <option value=\"pourcentage\">%</option>
                </select>
                <input type=\"number\" 
                       id=\"reduction\" 
                       class=\"form-control\" 
                       step=\"0.01\" 
                       min=\"0\" 
                       value=\"0\"
                       oninput=\"calculerTotaux()\">
            </div>
            <div id=\"reduction-appliquee\" style=\"font-size: 0.875rem; color: var(--success);\"></div>
        </div>

        <!-- Total après remise -->
        <div class=\"mb-3\">
            <div style=\"display: flex; justify-content: space-between; font-weight: 600; font-size: 1.125rem;\">
                <span>Total à payer:</span>
                <span id=\"total-final\">0.00 MAD</span>
            </div>
        </div>

        <!-- Paiements -->
        <div class=\"mb-3\">
            <h6 class=\"mb-2\">
                <i class=\"bi bi-cash-coin\"></i> Paiements
            </h6>
            <div id=\"paiements-container\">
                <!-- Les paiements seront ajoutés ici -->
            </div>
            <button type=\"button\" 
                    class=\"btn btn-outline-primary btn-sm w-100 mt-2\" 
                    onclick=\"ajouterPaiement()\">
                <i class=\"bi bi-plus-circle\"></i> Ajouter paiement
            </button>
            <div class=\"mt-2\">
                <div style=\"display: flex; justify-content: space-between; font-size: 0.875rem;\">
                    <span>Payé:</span>
                    <span id=\"montant-paye\" style=\"color: var(--success); font-weight: 600;\">0.00 MAD</span>
                </div>
                <div style=\"display: flex; justify-content: space-between; font-size: 0.875rem;\">
                    <span>Reste:</span>
                    <span id=\"montant-restant\" style=\"color: var(--danger); font-weight: 600;\">0.00 MAD</span>
                </div>
            </div>
        </div>

        <!-- Date limite paiement (si crédit) -->
        <div class=\"mb-3\" id=\"date-limite-container\" style=\"display: none;\">
            <label class=\"form-label\">Date limite de paiement</label>
            <input type=\"date\" 
                   id=\"date-limite-paiement\" 
                   class=\"form-control\">
        </div>

        <!-- Notes -->
        <div class=\"mb-3\">
            <label class=\"form-label\">Notes</label>
            <textarea id=\"notes-vente\" 
                      class=\"form-control\" 
                      rows=\"3\" 
                      placeholder=\"Notes internes...\"></textarea>
        </div>

        <!-- Bouton finaliser -->
        <button type=\"button\" 
                class=\"btn btn-primary-modern btn-modern w-100\" 
                onclick=\"finaliserVente()\"
                id=\"btn-finaliser\">
            <i class=\"bi bi-check-circle-fill\"></i> Confirmer la vente
        </button>
    </div>
</div>

<!-- Modal Client -->
<div class=\"modal fade\" id=\"modalClient\" tabindex=\"-1\">
    <div class=\"modal-dialog modal-lg\">
        <div class=\"modal-content\">
            <div class=\"modal-header\">
                <h5 class=\"modal-title\">Gérer le client</h5>
                <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button>
            </div>
            <div class=\"modal-body\">
                <ul class=\"nav nav-tabs mb-3\">
                    <li class=\"nav-item\">
                        <a class=\"nav-link active\" data-bs-toggle=\"tab\" href=\"#select-client\">Sélectionner</a>
                    </li>
                    <li class=\"nav-item\">
                        <a class=\"nav-link\" data-bs-toggle=\"tab\" href=\"#new-client\">Nouveau client</a>
                    </li>
                    <li class=\"nav-item\">
                        <a class=\"nav-link\" data-bs-toggle=\"tab\" href=\"#client-rapide\">Client rapide</a>
                    </li>
                </ul>
                <div class=\"tab-content\">
                    <div class=\"tab-pane fade show active\" id=\"select-client\">
                        <input type=\"text\" 
                               id=\"client-search\" 
                               class=\"form-control mb-3\" 
                               placeholder=\"Rechercher par nom, téléphone, CIN...\">
                        <div id=\"clients-liste\" style=\"max-height: 300px; overflow-y: auto;\">
                            {% for client in clients %}
                            <div class=\"card mb-2 client-item\" 
                                 onclick=\"selectionnerClient({{ client.id }}, '{{ client.nom }}', '{{ client.telephone }}')\"
                                 style=\"cursor: pointer;\">
                                <div class=\"card-body\">
                                    <h6 class=\"mb-1\">{{ client.nom }}</h6>
                                    <small class=\"text-muted\">{{ client.telephone }}</small>
                                </div>
                            </div>
                            {% endfor %}
                        </div>
                    </div>
                    <div class=\"tab-pane fade\" id=\"new-client\">
                        <form id=\"form-new-client\" enctype=\"multipart/form-data\">
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Nom complet *</label>
                                <input type=\"text\" name=\"client[nom]\" class=\"form-control\" required>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Téléphone *</label>
                                <input type=\"text\" name=\"client[telephone]\" class=\"form-control\" required>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">CIN (optionnel)</label>
                                <input type=\"text\" name=\"client[cin]\" class=\"form-control\">
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Adresse (optionnel)</label>
                                <textarea name=\"client[adresse]\" class=\"form-control\" rows=\"2\"></textarea>
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Email (optionnel)</label>
                                <input type=\"email\" name=\"client[email]\" class=\"form-control\">
                            </div>
                            <div class=\"mb-3\">
                                <label class=\"form-label\">Photo de la CIN (optionnel)</label>
                                <input type=\"file\" name=\"client[photoCin]\" class=\"form-control\" accept=\"image/*\">
                            </div>
                            <button type=\"submit\" class=\"btn btn-primary w-100\">Créer et sélectionner</button>
                        </form>
                    </div>
                    <div class=\"tab-pane fade\" id=\"client-rapide\">
                        <div class=\"alert alert-info\">
                            <i class=\"bi bi-info-circle\"></i> 
                            Vente sans enregistrer de client. Les informations client peuvent être ajoutées dans les notes.
                        </div>
                        <div class=\"mb-3\">
                            <label class=\"form-label\">Nom du client (optionnel)</label>
                            <input type=\"text\" id=\"client-rapide-nom\" class=\"form-control\" placeholder=\"Pour référence uniquement\">
                        </div>
                        <button type=\"button\" class=\"btn btn-outline-primary w-100\" onclick=\"selectionnerClientRapide()\">
                            Utiliser client rapide
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let lignesVente = [];
let clientSelectionne = null;
let paiements = [];

// Attendre que le DOM soit chargé
document.addEventListener('DOMContentLoaded', function() {
    // Focus automatique sur le scanner et event listener
    const barcodeInput = document.getElementById('barcode-input');
    if (barcodeInput) {
        barcodeInput.focus();
        barcodeInput.addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        const codeBarres = this.value.trim();
        if (codeBarres) {
            ajouterProduitParCodeBarres(codeBarres);
            this.value = '';
        }
    }
});
    }

// Recherche de produits
let searchTimeout;
    const produitSearch = document.getElementById('produit-search');
    if (produitSearch) {
        produitSearch.addEventListener('input', function() {
    clearTimeout(searchTimeout);
    const query = this.value.trim();
    
    if (query.length < 2) {
                const results = document.getElementById('produit-search-results');
                if (results) {
                    results.style.display = 'none';
                }
        return;
    }

    searchTimeout = setTimeout(() => {
        fetch(`{{ path('ventes_api_recherche_produit') }}?q=\${encodeURIComponent(query)}`)
            .then(response => response.json())
            .then(data => {
                const container = document.getElementById('produit-search-results');
                const listGroup = container.querySelector('.list-group');
                listGroup.innerHTML = '';
                
                if (data.length > 0) {
                    container.style.display = 'block';
                    data.forEach(produit => {
                        const item = document.createElement('a');
                        item.className = 'list-group-item list-group-item-action';
                        item.innerHTML = `
                            <div class=\"d-flex justify-content-between\">
                                <div>
                                    <strong>\${produit.nom}</strong><br>
                                    <small class=\"text-muted\">\${produit.codeBarres} | \${produit.referenceInterne || ''}</small>
                                </div>
                                <div class=\"text-end\">
                                    <strong>\${parseFloat(produit.prixVenteRecommande || produit.prixAchat).toFixed(2)} MAD</strong>
                                </div>
                            </div>
                        `;
                        item.onclick = () => {
                            ajouterProduit(produit.id);
                            document.getElementById('produit-search').value = '';
                            container.style.display = 'none';
                        };
                        listGroup.appendChild(item);
                    });
                } else {
                    container.style.display = 'none';
                }
            });
    }, 300);
});
    }
}); // Fin du DOMContentLoaded

// Fonctions globales (définies en dehors du DOMContentLoaded)
// Ajouter produit par code-barres
async function ajouterProduitParCodeBarres(codeBarres) {
    try {
        const response = await fetch('{{ path('ventes_nouvelle') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: new URLSearchParams({
                code_barres: codeBarres
            })
        });
        
        const data = await response.json();
        if (data.error) {
            alert(data.error);
            return;
        }
        
        ajouterLigneVente(data);
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'ajout du produit');
    }
}

// Charger les produits d'une sous-catégorie
async function chargerProduitsSousCategorie(sousCategorieId, sousCategorieNom) {
    try {
        const response = await fetch(`{{ path('ventes_api_produits_sous_categorie', {'sousCategorieId': 'PLACEHOLDER'}) }}`.replace('PLACEHOLDER', sousCategorieId), {
            method: 'GET',
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            credentials: 'same-origin'
        });
        
        const produits = await response.json();
        
        if (produits.error) {
            alert(produits.error);
            return;
        }
        
        // Afficher la section produits et masquer les sous-catégories
        document.getElementById('sous-categories-section').style.display = 'none';
        document.getElementById('produits-section').style.display = 'block';
        document.getElementById('sous-categorie-selectionnee').textContent = sousCategorieNom;
        
        // Afficher les produits
        const container = document.getElementById('produits-liste');
        container.innerHTML = '';
        
        if (produits.length === 0) {
            container.innerHTML = '<div class=\"alert alert-info\">Aucun produit disponible dans cette sous-catégorie</div>';
            return;
        }
        
        produits.forEach(produit => {
            const div = document.createElement('div');
            div.className = 'produit-card-select';
            div.setAttribute('data-produit-id', produit.id);
            div.onclick = () => ajouterProduit(produit.id);
            div.title = `\${produit.nom} - Stock: \${produit.quantite}`;
            div.innerHTML = `
                <div style=\"font-weight: 600; font-size: 0.875rem; margin-bottom: 0.25rem;\">
                    \${produit.nom.length > 30 ? produit.nom.substring(0, 30) + '...' : produit.nom}
                </div>
                <div style=\"font-size: 0.7rem; color: var(--text-secondary); margin-bottom: 0.25rem;\">
                    \${produit.codeBarres}
                </div>
                \${produit.referenceInterne ? `<div style=\"font-size: 0.7rem; color: var(--text-tertiary); margin-bottom: 0.25rem;\">Ref: \${produit.referenceInterne}</div>` : ''}
                <div style=\"font-size: 0.875rem; color: var(--primary); font-weight: 600; margin-top: 0.5rem;\">
                    \${parseFloat(produit.prixVenteRecommande || produit.prixAchat).toFixed(2)} MAD
                </div>
                <div style=\"font-size: 0.7rem; color: var(--success); margin-top: 0.25rem;\">
                    Stock: \${produit.quantite}
                </div>
            `;
            container.appendChild(div);
        });
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors du chargement des produits');
    }
}

function retourSousCategories() {
    document.getElementById('sous-categories-section').style.display = 'block';
    document.getElementById('produits-section').style.display = 'none';
    document.getElementById('produits-liste').innerHTML = '';
}

// Ajouter produit par ID
async function ajouterProduit(produitId) {
    try {
        const response = await fetch('{{ path('ventes_nouvelle') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: new URLSearchParams({
                produit_id: produitId
            })
        });
        
        const data = await response.json();
        if (data.error) {
            alert(data.error);
            return;
        }
        
        ajouterLigneVente(data);
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de l\\'ajout du produit');
    }
}

// Ajouter une ligne de vente
function ajouterLigneVente(produit) {
    const ligne = {
        produit_id: produit.id,
        nom: produit.nom,
        codeBarres: produit.codeBarres,
        referenceInterne: produit.referenceInterne,
        imei: produit.imei,
        numeroSerie: produit.numeroSerie,
        prixAchat: parseFloat(produit.prixAchat),
        prixVenteRecommande: parseFloat(produit.prixVenteRecommande || produit.prixAchat),
        margeMinimale: parseFloat(produit.margeMinimale || 0),
        quantite: 1,
        prixVente: parseFloat(produit.prixVenteRecommande || produit.prixAchat),
        caracteristiques: produit.caracteristiques || {}
    };
    
    lignesVente.push(ligne);
    afficherLignesVente();
    calculerTotaux();
}

// Afficher les lignes de vente
function afficherLignesVente() {
    const container = document.getElementById('lignes-vente-container');
    container.innerHTML = '';
    
    lignesVente.forEach((ligne, index) => {
        const marge = ligne.prixVente - ligne.prixAchat;
        const margeTotal = marge * ligne.quantite;
        const total = ligne.prixVente * ligne.quantite;
        const alertMarge = marge < ligne.margeMinimale ? 
            `<div class=\"alert-marge\">⚠️ Marge inférieure au minimum (\${ligne.margeMinimale.toFixed(2)} MAD)</div>` : '';
        
        const div = document.createElement('div');
        div.className = 'ligne-vente';
        div.innerHTML = `
            <div>
                <strong>\${ligne.nom}</strong>
                \${ligne.imei ? `<br><small class=\"text-muted\">IMEI: \${ligne.imei}</small>` : ''}
                \${ligne.referenceInterne ? `<br><small class=\"text-muted\">Ref: \${ligne.referenceInterne}</small>` : ''}
                \${alertMarge}
            </div>
            <div>
                <input type=\"number\" 
                       class=\"form-control\" 
                       value=\"\${ligne.quantite}\" 
                       min=\"1\" 
                       max=\"\${ligne.quantite}\"
                       onchange=\"modifierQuantite(\${index}, this.value)\">
            </div>
            <div>
                <input type=\"number\" 
                       class=\"form-control\" 
                       value=\"\${ligne.prixVente.toFixed(2)}\" 
                       step=\"0.01\" 
                       min=\"0\"
                       onchange=\"modifierPrixVente(\${index}, this.value)\">
                <small class=\"text-muted\">Achat: \${ligne.prixAchat.toFixed(2)} MAD</small>
            </div>
            <div>
                <span style=\"color: \${marge >= 0 ? 'var(--success)' : 'var(--danger)'}; font-weight: 600;\">
                    \${margeTotal.toFixed(2)} MAD
                </span>
                <br><small class=\"text-muted\">\${((marge / ligne.prixAchat) * 100).toFixed(1)}%</small>
            </div>
            <div>
                <strong>\${total.toFixed(2)} MAD</strong>
            </div>
            <div>
                <button type=\"button\" 
                        class=\"btn btn-sm btn-danger\" 
                        onclick=\"supprimerLigne(\${index})\">
                    <i class=\"bi bi-trash\"></i>
                </button>
            </div>
        `;
        container.appendChild(div);
    });
}

function modifierQuantite(index, quantite) {
    lignesVente[index].quantite = parseInt(quantite);
    afficherLignesVente();
    calculerTotaux();
}

function modifierPrixVente(index, prix) {
    lignesVente[index].prixVente = parseFloat(prix);
    afficherLignesVente();
    calculerTotaux();
}

function supprimerLigne(index) {
    lignesVente.splice(index, 1);
    afficherLignesVente();
    calculerTotaux();
}

function calculerTotaux() {
    let total = 0;
    lignesVente.forEach(ligne => {
        total += ligne.prixVente * ligne.quantite;
    });
    
    const reductionType = document.getElementById('reduction-type').value;
    const reduction = parseFloat(document.getElementById('reduction').value || 0);
    let reductionAppliquee = 0;
    
    if (reductionType === 'pourcentage') {
        reductionAppliquee = (total * reduction) / 100;
    } else {
        reductionAppliquee = reduction;
    }
    
    const totalFinal = total - reductionAppliquee;
    
    document.getElementById('total-vente').textContent = total.toFixed(2) + ' MAD';
    document.getElementById('total-final').textContent = totalFinal.toFixed(2) + ' MAD';
    
    if (reductionAppliquee > 0) {
        document.getElementById('reduction-appliquee').textContent = 
            `Remise: -\${reductionAppliquee.toFixed(2)} MAD`;
    } else {
        document.getElementById('reduction-appliquee').textContent = '';
    }
    
    calculerPaiements();
}

function calculerPaiements() {
    const totalFinal = parseFloat(document.getElementById('total-final').textContent.replace(' MAD', ''));
    let montantPaye = 0;
    
    paiements.forEach(p => {
        montantPaye += parseFloat(p.montant);
    });
    
    const montantRestant = totalFinal - montantPaye;
    
    document.getElementById('montant-paye').textContent = montantPaye.toFixed(2) + ' MAD';
    document.getElementById('montant-restant').textContent = montantRestant.toFixed(2) + ' MAD';
    
    // Afficher/masquer date limite si crédit
    if (montantRestant > 0) {
        document.getElementById('date-limite-container').style.display = 'block';
    } else {
        document.getElementById('date-limite-container').style.display = 'none';
    }
}

// Gestion client
function ouvrirModalClient() {
    const modal = new bootstrap.Modal(document.getElementById('modalClient'));
    modal.show();
}

function selectionnerClient(id, nom, telephone) {
    console.log('🔄 selectionnerClient appelé avec:', { id, nom, telephone });
    
    try {
        // Mettre à jour la variable globale
    clientSelectionne = { id, nom, telephone };
        
        // Préparer les valeurs
        const nomValue = String(nom || '').trim() || 'Client sans nom';
        const telValue = String(telephone || '').trim() || 'Pas de téléphone';
        
        console.log('📋 Valeurs préparées:', { nom: nomValue, tel: telValue });
        
        // Fonction pour mettre à jour l'affichage - version simplifiée
        const updateDisplay = () => {
            const sidebar = document.querySelector('.vente-sidebar');
            if (!sidebar) {
                console.error('❌ Sidebar non trouvée');
                return false;
            }
            
            // Chercher ou créer le div client-selectionne
            let clientDiv = sidebar.querySelector('#client-selectionne');
            
            if (!clientDiv) {
                // Chercher la section client
                const sections = sidebar.querySelectorAll('.mb-3');
                let clientSection = null;
                
                for (let section of sections) {
                    const btn = section.querySelector('button[onclick*=\"ouvrirModalClient\"]');
                    if (btn) {
                        clientSection = section;
                        break;
                    }
                }
                
                if (clientSection) {
                    // Créer le div s'il n'existe pas
                    clientDiv = document.createElement('div');
                    clientDiv.id = 'client-selectionne';
                    clientDiv.style.display = 'block';
                    clientDiv.innerHTML = `
                        <div class=\"alert alert-info\">
                            <strong id=\"client-nom\" style=\"display: block;\"></strong>
                            <small id=\"client-info\" style=\"display: block;\"></small>
                            <button type=\"button\" class=\"btn btn-sm btn-link p-0\" onclick=\"retirerClient()\">
                                Retirer
                            </button>
                        </div>
                    `;
                    clientSection.appendChild(clientDiv);
                    console.log('✅ Div client créé');
                } else {
                    console.error('❌ Section client non trouvée');
                    return false;
                }
            }
            
            // Mettre à jour le contenu
            const nomEl = clientDiv.querySelector('#client-nom');
            const infoEl = clientDiv.querySelector('#client-info');
            
            if (nomEl && infoEl) {
                nomEl.textContent = nomValue;
                nomEl.innerHTML = nomValue;
                infoEl.textContent = telValue;
                infoEl.innerHTML = telValue;
                
                // Forcer l'affichage avec plusieurs méthodes
                clientDiv.style.display = 'block';
                clientDiv.style.visibility = 'visible';
                clientDiv.removeAttribute('hidden');
                clientDiv.setAttribute('data-client-id', id);
                clientDiv.classList.remove('d-none');
                clientDiv.classList.add('d-block');
                
                // Vérifier périodiquement que le div reste visible
                let checkCount = 0;
                const checkInterval = setInterval(() => {
                    checkCount++;
                    if (checkCount > 10) {
                        clearInterval(checkInterval);
                        return;
                    }
                    
                    if (clientDiv && clientDiv.style.display === 'none') {
                        console.warn('⚠️ Le div a été masqué, on le réaffiche');
                        clientDiv.style.display = 'block';
                        clientDiv.style.visibility = 'visible';
                    }
                }, 200);
                
                console.log('✅ Client affiché:', { id, nom: nomValue, tel: telValue });
                return true;
            } else {
                console.error('❌ Éléments nom/info non trouvés dans le div');
                return false;
            }
        };
        
        // Fermer la modal APRÈS avoir mis à jour l'affichage
        // Mettre à jour l'affichage d'abord
        if (updateDisplay()) {
            console.log('✅ Client affiché avant fermeture modal');
            // Fermer la modal après un court délai pour laisser l'affichage se stabiliser
            setTimeout(() => {
                const modalEl = document.getElementById('modalClient');
                const modal = modalEl ? bootstrap.Modal.getInstance(modalEl) : null;
                if (modal) {
                    modal.hide();
                }
            }, 100);
        } else {
            // Si l'affichage n'a pas fonctionné, fermer la modal et réessayer
            const modalEl = document.getElementById('modalClient');
            const modal = modalEl ? bootstrap.Modal.getInstance(modalEl) : null;
            if (modal) {
                modal.hide();
                
                // Attendre que la modal soit fermée puis réessayer
                const handleHidden = () => {
                    setTimeout(() => {
                        if (!updateDisplay()) {
                            setTimeout(() => updateDisplay(), 300);
                        }
                    }, 400);
                    modalEl.removeEventListener('hidden.bs.modal', handleHidden);
                };
                modalEl.addEventListener('hidden.bs.modal', handleHidden);
            } else {
                // Pas de modal, réessayer
                setTimeout(() => {
                    if (!updateDisplay()) {
                        setTimeout(() => updateDisplay(), 300);
                    }
                }, 200);
            }
        }
    } catch (error) {
        console.error('❌ Erreur dans selectionnerClient:', error);
        alert('Erreur: ' + error.message);
    }
}

function selectionnerClientRapide() {
    try {
        const nomInput = document.getElementById('client-rapide-nom');
        const nom = nomInput ? nomInput.value : '';
    clientSelectionne = { rapide: true, nom: nom || 'Client rapide' };
        
        // Fonction helper pour mettre à jour l'affichage
        const updateClientDisplay = () => {
            const clientNomEl = document.getElementById('client-nom');
            const clientInfoEl = document.getElementById('client-info');
            const clientSelectionneEl = document.getElementById('client-selectionne');
            
            if (clientNomEl && clientInfoEl && clientSelectionneEl) {
                clientNomEl.textContent = clientSelectionne.nom;
                clientInfoEl.textContent = 'Vente sans client enregistré';
                clientSelectionneEl.style.display = 'block';
                return true;
            }
            return false;
        };
        
        // Essayer immédiatement
        if (updateClientDisplay()) {
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
            if (modal) {
                modal.hide();
            }
            return;
        }
        
        // Si les éléments ne sont pas trouvés, attendre un peu et réessayer
        setTimeout(() => {
            if (!updateClientDisplay()) {
                setTimeout(() => {
                    if (!updateClientDisplay()) {
                        console.error('Éléments client non trouvés après plusieurs tentatives');
                        alert('Erreur: impossible de mettre à jour l\\'affichage. Veuillez recharger la page.');
                    } else {
                        const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
                        if (modal) {
                            modal.hide();
                        }
                    }
                }, 200);
            } else {
                const modal = bootstrap.Modal.getInstance(document.getElementById('modalClient'));
                if (modal) {
                    modal.hide();
                }
            }
        }, 100);
    } catch (error) {
        console.error('Erreur dans selectionnerClientRapide:', error);
        alert('Erreur lors de la sélection du client rapide: ' + error.message);
    }
}

function retirerClient() {
    clientSelectionne = null;
    document.getElementById('client-selectionne').style.display = 'none';
}

// Gestion paiements
function ajouterPaiement() {
    const montantRestant = parseFloat(document.getElementById('montant-restant').textContent.replace(' MAD', ''));
    
    const div = document.createElement('div');
    div.className = 'card mb-2';
    div.innerHTML = `
        <div class=\"card-body\">
            <div class=\"row g-2\">
                <div class=\"col-6\">
                    <input type=\"number\" class=\"form-control form-control-sm\" placeholder=\"Montant\" step=\"0.01\" min=\"0\" onchange=\"mettreAJourPaiement(this)\">
                </div>
                <div class=\"col-6\">
                    <select class=\"form-select form-select-sm\" onchange=\"mettreAJourPaiement(this)\">
                        <option value=\"cash\">Cash</option>
                        <option value=\"carte\">Carte</option>
                        <option value=\"virement\">Virement</option>
                        <option value=\"cheque\">Chèque</option>
                    </select>
                </div>
                <div class=\"col-12\">
                    <input type=\"text\" class=\"form-control form-control-sm\" placeholder=\"Référence (optionnel)\" onchange=\"mettreAJourPaiement(this)\">
                </div>
                <div class=\"col-12\">
                    <button type=\"button\" class=\"btn btn-sm btn-danger w-100\" onclick=\"supprimerPaiement(this)\">
                        <i class=\"bi bi-trash\"></i> Supprimer
                    </button>
                </div>
            </div>
        </div>
    `;
    
    document.getElementById('paiements-container').appendChild(div);
    mettreAJourPaiements();
}

function mettreAJourPaiement(input) {
    mettreAJourPaiements();
}

function mettreAJourPaiements() {
    paiements = [];
    document.querySelectorAll('#paiements-container .card').forEach(card => {
        const inputs = card.querySelectorAll('input, select');
        if (inputs.length >= 2) {
            paiements.push({
                montant: parseFloat(inputs[0].value || 0),
                mode: inputs[1].value || 'cash',
                reference: inputs[2] ? inputs[2].value : null
            });
        }
    });
    calculerPaiements();
}

function supprimerPaiement(btn) {
    btn.closest('.card').remove();
    mettreAJourPaiements();
}

// Finaliser la vente
async function finaliserVente() {
    if (lignesVente.length === 0) {
        alert('Veuillez ajouter au moins un produit');
        return;
    }
    
    const montantRestant = parseFloat(document.getElementById('montant-restant').textContent.replace(' MAD', ''));
    if (montantRestant > 0 && !clientSelectionne) {
        alert('Un client est obligatoire pour les ventes à crédit');
        return;
    }
    
    const data = {
        lignes: lignesVente.map(l => ({
            produit_id: l.produit_id,
            quantite: l.quantite,
            prix_vente: l.prixVente
        })),
        client_id: clientSelectionne && !clientSelectionne.rapide ? clientSelectionne.id : null,
        client_rapide: clientSelectionne && clientSelectionne.rapide ? { nom: clientSelectionne.nom } : null,
        reduction: document.getElementById('reduction').value,
        reduction_type: document.getElementById('reduction-type').value,
        paiements: paiements,
        date_limite_paiement: document.getElementById('date-limite-paiement').value || null,
        mode_paiement: montantRestant > 0 ? 'credit' : 'cash',
        notes: document.getElementById('notes-vente').value
    };
    
    try {
        const response = await fetch('{{ path('ventes_finaliser') }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.error) {
            alert(result.error);
            return;
        }
        
        if (result.success) {
            window.location.href = result.redirect;
        }
    } catch (error) {
        console.error('Erreur:', error);
        alert('Erreur lors de la finalisation de la vente');
    }
}

// Event listeners pour les formulaires (ajoutés dans un DOMContentLoaded séparé)
document.addEventListener('DOMContentLoaded', function() {
// Créer nouveau client
    const formNewClient = document.getElementById('form-new-client');
    if (formNewClient) {
        formNewClient.addEventListener('submit', async function(e) {
    e.preventDefault();
            
            // Désactiver le bouton pour éviter les doubles soumissions
            const submitBtn = this.querySelector('button[type=\"submit\"]');
            const originalText = submitBtn.textContent;
            submitBtn.disabled = true;
            submitBtn.textContent = 'Création...';
            
    const formData = new FormData(this);
    
    try {
        const response = await fetch('{{ path('clients_new') }}', {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: formData
        });
                
                // Vérifier le statut de la réponse
                if (!response.ok) {
                    const errorText = await response.text();
                    console.error('Erreur HTTP:', response.status, errorText);
                    throw new Error('Erreur serveur: ' + response.status);
                }
        
        const contentType = response.headers.get('content-type');
                let data;
                
        if (contentType && contentType.includes('application/json')) {
                    data = await response.json();
            } else {
                    // Si ce n'est pas du JSON, essayer de parser quand même
            const text = await response.text();
            console.error('Réponse non-JSON:', text.substring(0, 500));
                    try {
                        data = JSON.parse(text);
                    } catch (parseError) {
                        console.error('Erreur de parsing JSON:', parseError);
                        throw new Error('Réponse serveur invalide. Code: ' + response.status + ' - ' + text.substring(0, 100));
                    }
                }
                
                console.log('Réponse serveur:', data);
                
                if (data.success && data.client) {
                    // Réinitialiser le formulaire
                    this.reset();
                    
                    // Vérifier que les données client sont bien présentes
                    console.log('✅ Données client reçues:', data.client);
                    
                    const clientId = data.client.id;
                    const clientNom = String(data.client.nom || '').trim();
                    const clientTel = String(data.client.telephone || '').trim();
                    
                    console.log('📋 Valeurs extraites:', { id: clientId, nom: clientNom, tel: clientTel });
                    
                    if (!clientId) {
                        console.error('❌ ID client manquant:', data.client);
                        alert('Erreur: ID client manquant');
                        return;
                    }
                    
                    if (!clientNom) {
                        console.warn('⚠️ Nom client vide, utilisation de la valeur par défaut');
                    }
                    
                    // Sélectionner le client créé (la fonction gère la fermeture de la modal)
                    console.log('🔄 Appel de selectionnerClient avec:', { id: clientId, nom: clientNom, tel: clientTel });
                    selectionnerClient(clientId, clientNom, clientTel);
                } else {
                    const errorMsg = data.errors || data.error || 'Erreur lors de la création du client';
                    console.error('Erreur de création:', errorMsg);
                    alert('Erreur: ' + errorMsg);
        }
    } catch (error) {
                console.error('Erreur complète:', error);
                alert('Erreur lors de la création du client: ' + (error.message || 'Erreur inconnue'));
            } finally {
                // Réactiver le bouton
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
            }
        });
    }
    
    // Recherche de clients
    const clientSearch = document.getElementById('client-search');
    if (clientSearch) {
        clientSearch.addEventListener('input', function() {
            const query = this.value.toLowerCase();
            const items = document.querySelectorAll('.client-item');
            items.forEach(item => {
                const text = item.textContent.toLowerCase();
                item.style.display = text.includes(query) ? 'block' : 'none';
            });
        });
    }
}); // Fin du DOMContentLoaded pour les event listeners
</script>
{% endblock %}

", "vente/nouvelle.html.twig", "/var/www/html/templates/vente/nouvelle.html.twig");
    }
}
