<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* dashboard/index.html.twig */
class __TwigTemplate_c26db80f19d8dba2d9a5b3a1bc0d6ec6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "dashboard/index.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "dashboard/index.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Dashboard - Red Store";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Dashboard";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "    <!-- Filtres du Dashboard -->
    <div class=\"card-modern mb-4\">
        <div class=\"card-body-modern\">
            <form method=\"get\" id=\"dashboardFilters\" class=\"row g-3\">
                <!-- Période -->
                <div class=\"col-md-3\">
                    <label class=\"form-label\"><i class=\"bi bi-calendar\"></i> Période</label>
                    <select name=\"period\" id=\"period-select\" class=\"form-select\" onchange=\"updatePeriodDates()\">
                        <option value=\"today\" ";
        // line 15
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 15, $this->source); })()), "period", [], "any", false, false, false, 15) == "today")) ? ("selected") : (""));
        yield ">Aujourd'hui</option>
                        <option value=\"yesterday\" ";
        // line 16
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 16, $this->source); })()), "period", [], "any", false, false, false, 16) == "yesterday")) ? ("selected") : (""));
        yield ">Hier</option>
                        <option value=\"this_week\" ";
        // line 17
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 17, $this->source); })()), "period", [], "any", false, false, false, 17) == "this_week")) ? ("selected") : (""));
        yield ">Cette semaine</option>
                        <option value=\"this_month\" ";
        // line 18
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 18, $this->source); })()), "period", [], "any", false, false, false, 18) == "this_month")) ? ("selected") : (""));
        yield ">Ce mois</option>
                        <option value=\"this_quarter\" ";
        // line 19
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 19, $this->source); })()), "period", [], "any", false, false, false, 19) == "this_quarter")) ? ("selected") : (""));
        yield ">Ce trimestre</option>
                        <option value=\"this_year\" ";
        // line 20
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 20, $this->source); })()), "period", [], "any", false, false, false, 20) == "this_year")) ? ("selected") : (""));
        yield ">Cette année</option>
                        <option value=\"custom\" ";
        // line 21
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 21, $this->source); })()), "period", [], "any", false, false, false, 21) == "custom")) ? ("selected") : (""));
        yield ">Plage personnalisée</option>
                    </select>
                </div>
                
                <!-- Dates personnalisées -->
                <div class=\"col-md-2\" id=\"custom-dates\" style=\"display: ";
        // line 26
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 26, $this->source); })()), "period", [], "any", false, false, false, 26) == "custom")) ? ("block") : ("none"));
        yield ";\">
                    <label class=\"form-label\">Du</label>
                    <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"";
        // line 28
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 28, $this->source); })()), "date_debut", [], "any", false, false, false, 28), "html", null, true);
        yield "\">
                </div>
                <div class=\"col-md-2\" id=\"custom-dates-end\" style=\"display: ";
        // line 30
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 30, $this->source); })()), "period", [], "any", false, false, false, 30) == "custom")) ? ("block") : ("none"));
        yield ";\">
                    <label class=\"form-label\">Au</label>
                    <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"";
        // line 32
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 32, $this->source); })()), "date_fin", [], "any", false, false, false, 32), "html", null, true);
        yield "\">
                </div>
                
                <!-- Magasin -->
                ";
        // line 36
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["magasins"]) || array_key_exists("magasins", $context) ? $context["magasins"] : (function () { throw new RuntimeError('Variable "magasins" does not exist.', 36, $this->source); })())) > 1)) {
            // line 37
            yield "                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-shop\"></i> Magasin</label>
                    <select name=\"magasin\" class=\"form-select\">
                        <option value=\"\">Tous les magasins</option>
                        ";
            // line 41
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["magasins"]) || array_key_exists("magasins", $context) ? $context["magasins"] : (function () { throw new RuntimeError('Variable "magasins" does not exist.', 41, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["magasin"]) {
                // line 42
                yield "                        <option value=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["magasin"], "id", [], "any", false, false, false, 42), "html", null, true);
                yield "\" ";
                yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 42, $this->source); })()), "magasin", [], "any", false, false, false, 42) == CoreExtension::getAttribute($this->env, $this->source, $context["magasin"], "id", [], "any", false, false, false, 42))) ? ("selected") : (""));
                yield ">
                            ";
                // line 43
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["magasin"], "nom", [], "any", false, false, false, 43), "html", null, true);
                yield "
                        </option>
                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['magasin'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 46
            yield "                    </select>
                </div>
                ";
        }
        // line 49
        yield "                
                <!-- Utilisateur -->
                ";
        // line 51
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["users"]) || array_key_exists("users", $context) ? $context["users"] : (function () { throw new RuntimeError('Variable "users" does not exist.', 51, $this->source); })())) > 1)) {
            // line 52
            yield "                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-person\"></i> Utilisateur</label>
                    <select name=\"user\" class=\"form-select\">
                        <option value=\"\">Tous les utilisateurs</option>
                        ";
            // line 56
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["users"]) || array_key_exists("users", $context) ? $context["users"] : (function () { throw new RuntimeError('Variable "users" does not exist.', 56, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["user"]) {
                // line 57
                yield "                        <option value=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["user"], "id", [], "any", false, false, false, 57), "html", null, true);
                yield "\" ";
                yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 57, $this->source); })()), "user", [], "any", false, false, false, 57) == CoreExtension::getAttribute($this->env, $this->source, $context["user"], "id", [], "any", false, false, false, 57))) ? ("selected") : (""));
                yield ">
                            ";
                // line 58
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["user"], "prenom", [], "any", false, false, false, 58), "html", null, true);
                yield " ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["user"], "nom", [], "any", false, false, false, 58), "html", null, true);
                yield "
                        </option>
                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['user'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 61
            yield "                    </select>
                </div>
                ";
        }
        // line 64
        yield "                
                <!-- Catégorie -->
                ";
        // line 66
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["categories"]) || array_key_exists("categories", $context) ? $context["categories"] : (function () { throw new RuntimeError('Variable "categories" does not exist.', 66, $this->source); })())) > 0)) {
            // line 67
            yield "                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-tags\"></i> Catégorie</label>
                    <select name=\"categorie\" class=\"form-select\">
                        <option value=\"\">Toutes les catégories</option>
                        ";
            // line 71
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["categories"]) || array_key_exists("categories", $context) ? $context["categories"] : (function () { throw new RuntimeError('Variable "categories" does not exist.', 71, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["categorie"]) {
                // line 72
                yield "                        <option value=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["categorie"], "id", [], "any", false, false, false, 72), "html", null, true);
                yield "\" ";
                yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["filters"]) || array_key_exists("filters", $context) ? $context["filters"] : (function () { throw new RuntimeError('Variable "filters" does not exist.', 72, $this->source); })()), "categorie", [], "any", false, false, false, 72) == CoreExtension::getAttribute($this->env, $this->source, $context["categorie"], "id", [], "any", false, false, false, 72))) ? ("selected") : (""));
                yield ">
                            ";
                // line 73
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["categorie"], "nom", [], "any", false, false, false, 73), "html", null, true);
                yield "
                        </option>
                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['categorie'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 76
            yield "                    </select>
                </div>
                ";
        }
        // line 79
        yield "                
                <div class=\"col-md-1 d-flex align-items-end\">
                    <button type=\"submit\" class=\"btn btn-primary-modern w-100\">
                        <i class=\"bi bi-funnel\"></i> Filtrer
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Alertes -->
    ";
        // line 90
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 90, $this->source); })())) > 0)) {
            // line 91
            yield "    <div class=\"alert alert-warning alert-dismissible fade show\" role=\"alert\">
        <h5 class=\"alert-heading\"><i class=\"bi bi-exclamation-triangle\"></i> Alertes (";
            // line 92
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 92, $this->source); })())), "html", null, true);
            yield ")</h5>
        <ul class=\"mb-0\">
            ";
            // line 94
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(Twig\Extension\CoreExtension::slice($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 94, $this->source); })()), 0, 5));
            foreach ($context['_seq'] as $context["_key"] => $context["alerte"]) {
                // line 95
                yield "            <li>";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["alerte"], "message", [], "any", false, false, false, 95), "html", null, true);
                yield "</li>
            ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['alerte'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 97
            yield "            ";
            if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 97, $this->source); })())) > 5)) {
                // line 98
                yield "            <li><em>... et ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["alertes"]) || array_key_exists("alertes", $context) ? $context["alertes"] : (function () { throw new RuntimeError('Variable "alertes" does not exist.', 98, $this->source); })())) - 5), "html", null, true);
                yield " autres alertes</em></li>
            ";
            }
            // line 100
            yield "        </ul>
        <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
    </div>
    ";
        }
        // line 104
        yield "
    <!-- KPIs Principaux -->
    <div class=\"row g-4 mb-4\">
        <!-- Total Ventes -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Total Ventes</h6>
                            <h3 class=\"mb-0\">";
        // line 114
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 114, $this->source); })()), "totalVentes", [], "any", false, false, false, 114), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-primary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-cart-check text-primary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    ";
        // line 120
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 120, $this->source); })()), "evolutionVentes", [], "any", false, false, false, 120) != 0)) {
            // line 121
            yield "                    <small class=\"text-";
            yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 121, $this->source); })()), "evolutionVentes", [], "any", false, false, false, 121) > 0)) ? ("success") : ("danger"));
            yield "\">
                        <i class=\"bi bi-arrow-";
            // line 122
            yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 122, $this->source); })()), "evolutionVentes", [], "any", false, false, false, 122) > 0)) ? ("up") : ("down"));
            yield "\"></i>
                        ";
            // line 123
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 123, $this->source); })()), "evolutionVentes", [], "any", false, false, false, 123), 1), "html", null, true);
            yield "% vs période précédente
                    </small>
                    ";
        }
        // line 126
        yield "                </div>
            </div>
        </div>
        
        <!-- Produits Vendus -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Produits Vendus</h6>
                            <h3 class=\"mb-0\">";
        // line 137
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 137, $this->source); })()), "nombreProduitsVendus", [], "any", false, false, false, 137), "html", null, true);
        yield "</h3>
                        </div>
                        <div class=\"bg-success bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-box-seam text-success\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Profit -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Profit Réalisé</h6>
                            <h3 class=\"mb-0\">";
        // line 154
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 154, $this->source); })()), "profit", [], "any", false, false, false, 154), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-success bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-graph-up-arrow text-success\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">Marge moyenne: ";
        // line 160
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 160, $this->source); })()), "margeMoyenne", [], "any", false, false, false, 160), 2, ",", " "), "html", null, true);
        yield " MAD</small>
                </div>
            </div>
        </div>
        
        <!-- Paiements Reçus -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Paiements Reçus</h6>
                            <h3 class=\"mb-0\">";
        // line 172
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 172, $this->source); })()), "paiementsRecus", [], "any", false, false, false, 172), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-info bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-cash-coin text-info\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Dettes Clients -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Dettes Clients</h6>
                            <h3 class=\"mb-0\">";
        // line 189
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 189, $this->source); })()), "dettesClients", [], "any", false, false, false, 189), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-warning bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-credit-card text-warning\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">";
        // line 195
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 195, $this->source); })()), "nombreClientsCredit", [], "any", false, false, false, 195), "html", null, true);
        yield " client(s) en crédit</small>
                </div>
            </div>
        </div>
        
        <!-- Dettes Fournisseurs -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Dettes Fournisseurs</h6>
                            <h3 class=\"mb-0\">";
        // line 207
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 207, $this->source); })()), "dettesFournisseurs", [], "any", false, false, false, 207), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-danger bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-receipt text-danger\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">";
        // line 213
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 213, $this->source); })()), "nombreFacturesOuvertes", [], "any", false, false, false, 213), "html", null, true);
        yield " facture(s) ouverte(s)</small>
                </div>
            </div>
        </div>
        
        <!-- Valeur Stock -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Valeur Stock</h6>
                            <h3 class=\"mb-0\">";
        // line 225
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 225, $this->source); })()), "valeurStock", [], "any", false, false, false, 225), 2, ",", " "), "html", null, true);
        yield " MAD</h3>
                        </div>
                        <div class=\"bg-secondary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-archive text-secondary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">";
        // line 231
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 231, $this->source); })()), "produitsEnStock", [], "any", false, false, false, 231), "html", null, true);
        yield " produit(s) en stock</small>
                </div>
            </div>
        </div>
        
        <!-- Produits en Stock -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Produits en Stock</h6>
                            <h3 class=\"mb-0\">";
        // line 243
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 243, $this->source); })()), "produitsEnStock", [], "any", false, false, false, 243), "html", null, true);
        yield "</h3>
                        </div>
                        <div class=\"bg-primary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-box text-primary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">Neuf: ";
        // line 249
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 249, $this->source); })()), "produitsNeufs", [], "any", false, false, false, 249), "html", null, true);
        yield " | Occasion: ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["kpis"]) || array_key_exists("kpis", $context) ? $context["kpis"] : (function () { throw new RuntimeError('Variable "kpis" does not exist.', 249, $this->source); })()), "produitsOccasion", [], "any", false, false, false, 249), "html", null, true);
        yield "</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Graphiques -->
    <div class=\"row g-4 mb-4\">
        <!-- Ventes par Période -->
        <div class=\"col-md-8\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-graph-up\"></i> Ventes par Période</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"ventesPeriodeChart\" height=\"80\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Ventes par Catégorie -->
        <div class=\"col-md-4\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-pie-chart\"></i> Ventes par Catégorie</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"ventesCategorieChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class=\"row g-4 mb-4\">
        <!-- Top Produits -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-trophy\"></i> Top 10 Produits</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"topProduitsChart\" height=\"300\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Paiements par Mode -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-credit-card\"></i> Paiements par Mode</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"paiementsModeChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class=\"row g-4 mb-4\">
        <!-- Provenance Achats -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-arrow-down-up\"></i> Provenance des Achats</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"provenanceAchatsChart\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Dépenses par Type -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-cash-stack\"></i> Dépenses par Type</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"depensesTypeChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Rentabilité -->
    <div class=\"row g-4 mb-4\">
        <div class=\"col-md-12\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-graph-up-arrow\"></i> Rentabilité</h5>
                </div>
                <div class=\"card-body-modern\">
                    <div class=\"row g-3 mb-3\">
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Total Ventes</h6>
                                <h4 class=\"mb-0 text-primary\">";
        // line 346
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 346, $this->source); })()), "rentabilite", [], "any", false, false, false, 346), "ventes", [], "any", false, false, false, 346), 2, ",", " "), "html", null, true);
        yield " MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Total Dépenses</h6>
                                <h4 class=\"mb-0 text-danger\">";
        // line 352
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 352, $this->source); })()), "rentabilite", [], "any", false, false, false, 352), "depenses", [], "any", false, false, false, 352), 2, ",", " "), "html", null, true);
        yield " MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Profit Brut</h6>
                                <h4 class=\"mb-0 text-success\">";
        // line 358
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 358, $this->source); })()), "rentabilite", [], "any", false, false, false, 358), "profit", [], "any", false, false, false, 358), 2, ",", " "), "html", null, true);
        yield " MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Résultat Net</h6>
                                <h4 class=\"mb-0 ";
        // line 364
        yield (((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 364, $this->source); })()), "rentabilite", [], "any", false, false, false, 364), "resultatNet", [], "any", false, false, false, 364) >= 0)) ? ("text-success") : ("text-danger"));
        yield "\">
                                    ";
        // line 365
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 365, $this->source); })()), "rentabilite", [], "any", false, false, false, 365), "resultatNet", [], "any", false, false, false, 365), 2, ",", " "), "html", null, true);
        yield " MAD
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Données pour les graphiques
        const ventesPeriodeData = ";
        // line 377
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 377, $this->source); })()), "ventesParPeriode", [], "any", false, false, false, 377));
        yield ";
        const ventesCategorieData = ";
        // line 378
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 378, $this->source); })()), "ventesParCategorie", [], "any", false, false, false, 378));
        yield ";
        const topProduitsData = ";
        // line 379
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 379, $this->source); })()), "topProduits", [], "any", false, false, false, 379));
        yield ";
        const paiementsModeData = ";
        // line 380
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 380, $this->source); })()), "paiementsParMode", [], "any", false, false, false, 380));
        yield ";
        const provenanceAchatsData = ";
        // line 381
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 381, $this->source); })()), "provenanceAchats", [], "any", false, false, false, 381));
        yield ";
        const depensesTypeData = ";
        // line 382
        yield json_encode(CoreExtension::getAttribute($this->env, $this->source, (isset($context["graphiques"]) || array_key_exists("graphiques", $context) ? $context["graphiques"] : (function () { throw new RuntimeError('Variable "graphiques" does not exist.', 382, $this->source); })()), "depensesParType", [], "any", false, false, false, 382));
        yield ";

        // Graphique Ventes par Période
        const ctxVentesPeriode = document.getElementById('ventesPeriodeChart');
        if (ctxVentesPeriode) {
            new Chart(ctxVentesPeriode, {
                type: 'line',
                data: {
                    labels: ventesPeriodeData.map(v => v.date),
                    datasets: [{
                        label: 'Montant (MAD)',
                        data: ventesPeriodeData.map(v => parseFloat(v.total)),
                        borderColor: '#2563eb',
                        backgroundColor: 'rgba(37, 99, 235, 0.1)',
                        tension: 0.4,
                        fill: true
                    }, {
                        label: 'Nombre de ventes',
                        data: ventesPeriodeData.map(v => parseInt(v.nombre)),
                        borderColor: '#10b981',
                        backgroundColor: 'rgba(16, 185, 129, 0.1)',
                        tension: 0.4,
                        yAxisID: 'y1'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            position: 'left'
                        },
                        y1: {
                            type: 'linear',
                            display: true,
                            position: 'right',
                            beginAtZero: true,
                            grid: {
                                drawOnChartArea: false
                            }
                        }
                    }
                }
            });
        }

        // Graphique Ventes par Catégorie
        const ctxVentesCategorie = document.getElementById('ventesCategorieChart');
        if (ctxVentesCategorie) {
            new Chart(ctxVentesCategorie, {
                type: 'doughnut',
                data: {
                    labels: ventesCategorieData.map(v => v.categorie),
                    datasets: [{
                        data: ventesCategorieData.map(v => parseFloat(v.total)),
                        backgroundColor: [
                            '#2563eb', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6',
                            '#ec4899', '#06b6d4', '#84cc16', '#f97316', '#6366f1'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Top Produits
        const ctxTopProduits = document.getElementById('topProduitsChart');
        if (ctxTopProduits) {
            new Chart(ctxTopProduits, {
                type: 'bar',
                data: {
                    labels: topProduitsData.map(p => p.nom.length > 20 ? p.nom.substring(0, 20) + '...' : p.nom),
                    datasets: [{
                        label: 'Total vendu (MAD)',
                        data: topProduitsData.map(p => parseFloat(p.total)),
                        backgroundColor: '#2563eb'
                    }, {
                        label: 'Profit (MAD)',
                        data: topProduitsData.map(p => parseFloat(p.profit)),
                        backgroundColor: '#10b981'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        // Graphique Paiements par Mode
        const ctxPaiementsMode = document.getElementById('paiementsModeChart');
        if (ctxPaiementsMode) {
            const labels = Object.keys(paiementsModeData);
            const data = Object.values(paiementsModeData).map(v => parseFloat(v));
            new Chart(ctxPaiementsMode, {
                type: 'pie',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: [
                            '#2563eb', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#ec4899'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Provenance Achats
        const ctxProvenanceAchats = document.getElementById('provenanceAchatsChart');
        if (ctxProvenanceAchats) {
            new Chart(ctxProvenanceAchats, {
                type: 'doughnut',
                data: {
                    labels: ['Fournisseurs', 'Particuliers'],
                    datasets: [{
                        data: [
                            parseFloat(provenanceAchatsData.fournisseurs),
                            parseFloat(provenanceAchatsData.particuliers)
                        ],
                        backgroundColor: ['#2563eb', '#10b981']
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Dépenses par Type
        const ctxDepensesType = document.getElementById('depensesTypeChart');
        if (ctxDepensesType) {
            const labels = Object.keys(depensesTypeData);
            const data = Object.values(depensesTypeData).map(v => parseFloat(v));
            new Chart(ctxDepensesType, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Montant (MAD)',
                        data: data,
                        backgroundColor: '#ef4444'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        // Fonction pour afficher/masquer les dates personnalisées
        function updatePeriodDates() {
            const period = document.getElementById('period-select').value;
            const customDates = document.getElementById('custom-dates');
            const customDatesEnd = document.getElementById('custom-dates-end');
            if (period === 'custom') {
                customDates.style.display = 'block';
                customDatesEnd.style.display = 'block';
            } else {
                customDates.style.display = 'none';
                customDatesEnd.style.display = 'none';
            }
        }
    </script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "dashboard/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  712 => 382,  708 => 381,  704 => 380,  700 => 379,  696 => 378,  692 => 377,  677 => 365,  673 => 364,  664 => 358,  655 => 352,  646 => 346,  544 => 249,  535 => 243,  520 => 231,  511 => 225,  496 => 213,  487 => 207,  472 => 195,  463 => 189,  443 => 172,  428 => 160,  419 => 154,  399 => 137,  386 => 126,  380 => 123,  376 => 122,  371 => 121,  369 => 120,  360 => 114,  348 => 104,  342 => 100,  336 => 98,  333 => 97,  324 => 95,  320 => 94,  315 => 92,  312 => 91,  310 => 90,  297 => 79,  292 => 76,  283 => 73,  276 => 72,  272 => 71,  266 => 67,  264 => 66,  260 => 64,  255 => 61,  244 => 58,  237 => 57,  233 => 56,  227 => 52,  225 => 51,  221 => 49,  216 => 46,  207 => 43,  200 => 42,  196 => 41,  190 => 37,  188 => 36,  181 => 32,  176 => 30,  171 => 28,  166 => 26,  158 => 21,  154 => 20,  150 => 19,  146 => 18,  142 => 17,  138 => 16,  134 => 15,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Dashboard - Red Store{% endblock %}
{% block page_title %}Dashboard{% endblock %}

{% block content %}
    <!-- Filtres du Dashboard -->
    <div class=\"card-modern mb-4\">
        <div class=\"card-body-modern\">
            <form method=\"get\" id=\"dashboardFilters\" class=\"row g-3\">
                <!-- Période -->
                <div class=\"col-md-3\">
                    <label class=\"form-label\"><i class=\"bi bi-calendar\"></i> Période</label>
                    <select name=\"period\" id=\"period-select\" class=\"form-select\" onchange=\"updatePeriodDates()\">
                        <option value=\"today\" {{ filters.period == 'today' ? 'selected' : '' }}>Aujourd'hui</option>
                        <option value=\"yesterday\" {{ filters.period == 'yesterday' ? 'selected' : '' }}>Hier</option>
                        <option value=\"this_week\" {{ filters.period == 'this_week' ? 'selected' : '' }}>Cette semaine</option>
                        <option value=\"this_month\" {{ filters.period == 'this_month' ? 'selected' : '' }}>Ce mois</option>
                        <option value=\"this_quarter\" {{ filters.period == 'this_quarter' ? 'selected' : '' }}>Ce trimestre</option>
                        <option value=\"this_year\" {{ filters.period == 'this_year' ? 'selected' : '' }}>Cette année</option>
                        <option value=\"custom\" {{ filters.period == 'custom' ? 'selected' : '' }}>Plage personnalisée</option>
                    </select>
                </div>
                
                <!-- Dates personnalisées -->
                <div class=\"col-md-2\" id=\"custom-dates\" style=\"display: {{ filters.period == 'custom' ? 'block' : 'none' }};\">
                    <label class=\"form-label\">Du</label>
                    <input type=\"date\" name=\"date_debut\" class=\"form-control\" value=\"{{ filters.date_debut }}\">
                </div>
                <div class=\"col-md-2\" id=\"custom-dates-end\" style=\"display: {{ filters.period == 'custom' ? 'block' : 'none' }};\">
                    <label class=\"form-label\">Au</label>
                    <input type=\"date\" name=\"date_fin\" class=\"form-control\" value=\"{{ filters.date_fin }}\">
                </div>
                
                <!-- Magasin -->
                {% if magasins|length > 1 %}
                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-shop\"></i> Magasin</label>
                    <select name=\"magasin\" class=\"form-select\">
                        <option value=\"\">Tous les magasins</option>
                        {% for magasin in magasins %}
                        <option value=\"{{ magasin.id }}\" {{ filters.magasin == magasin.id ? 'selected' : '' }}>
                            {{ magasin.nom }}
                        </option>
                        {% endfor %}
                    </select>
                </div>
                {% endif %}
                
                <!-- Utilisateur -->
                {% if users|length > 1 %}
                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-person\"></i> Utilisateur</label>
                    <select name=\"user\" class=\"form-select\">
                        <option value=\"\">Tous les utilisateurs</option>
                        {% for user in users %}
                        <option value=\"{{ user.id }}\" {{ filters.user == user.id ? 'selected' : '' }}>
                            {{ user.prenom }} {{ user.nom }}
                        </option>
                        {% endfor %}
                    </select>
                </div>
                {% endif %}
                
                <!-- Catégorie -->
                {% if categories|length > 0 %}
                <div class=\"col-md-2\">
                    <label class=\"form-label\"><i class=\"bi bi-tags\"></i> Catégorie</label>
                    <select name=\"categorie\" class=\"form-select\">
                        <option value=\"\">Toutes les catégories</option>
                        {% for categorie in categories %}
                        <option value=\"{{ categorie.id }}\" {{ filters.categorie == categorie.id ? 'selected' : '' }}>
                            {{ categorie.nom }}
                        </option>
                        {% endfor %}
                    </select>
                </div>
                {% endif %}
                
                <div class=\"col-md-1 d-flex align-items-end\">
                    <button type=\"submit\" class=\"btn btn-primary-modern w-100\">
                        <i class=\"bi bi-funnel\"></i> Filtrer
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Alertes -->
    {% if alertes|length > 0 %}
    <div class=\"alert alert-warning alert-dismissible fade show\" role=\"alert\">
        <h5 class=\"alert-heading\"><i class=\"bi bi-exclamation-triangle\"></i> Alertes ({{ alertes|length }})</h5>
        <ul class=\"mb-0\">
            {% for alerte in alertes|slice(0, 5) %}
            <li>{{ alerte.message }}</li>
            {% endfor %}
            {% if alertes|length > 5 %}
            <li><em>... et {{ alertes|length - 5 }} autres alertes</em></li>
            {% endif %}
        </ul>
        <button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\"></button>
    </div>
    {% endif %}

    <!-- KPIs Principaux -->
    <div class=\"row g-4 mb-4\">
        <!-- Total Ventes -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Total Ventes</h6>
                            <h3 class=\"mb-0\">{{ kpis.totalVentes|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-primary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-cart-check text-primary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    {% if kpis.evolutionVentes != 0 %}
                    <small class=\"text-{{ kpis.evolutionVentes > 0 ? 'success' : 'danger' }}\">
                        <i class=\"bi bi-arrow-{{ kpis.evolutionVentes > 0 ? 'up' : 'down' }}\"></i>
                        {{ kpis.evolutionVentes|number_format(1) }}% vs période précédente
                    </small>
                    {% endif %}
                </div>
            </div>
        </div>
        
        <!-- Produits Vendus -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Produits Vendus</h6>
                            <h3 class=\"mb-0\">{{ kpis.nombreProduitsVendus }}</h3>
                        </div>
                        <div class=\"bg-success bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-box-seam text-success\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Profit -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Profit Réalisé</h6>
                            <h3 class=\"mb-0\">{{ kpis.profit|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-success bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-graph-up-arrow text-success\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">Marge moyenne: {{ kpis.margeMoyenne|number_format(2, ',', ' ') }} MAD</small>
                </div>
            </div>
        </div>
        
        <!-- Paiements Reçus -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Paiements Reçus</h6>
                            <h3 class=\"mb-0\">{{ kpis.paiementsRecus|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-info bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-cash-coin text-info\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Dettes Clients -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Dettes Clients</h6>
                            <h3 class=\"mb-0\">{{ kpis.dettesClients|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-warning bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-credit-card text-warning\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">{{ kpis.nombreClientsCredit }} client(s) en crédit</small>
                </div>
            </div>
        </div>
        
        <!-- Dettes Fournisseurs -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Dettes Fournisseurs</h6>
                            <h3 class=\"mb-0\">{{ kpis.dettesFournisseurs|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-danger bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-receipt text-danger\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">{{ kpis.nombreFacturesOuvertes }} facture(s) ouverte(s)</small>
                </div>
            </div>
        </div>
        
        <!-- Valeur Stock -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Valeur Stock</h6>
                            <h3 class=\"mb-0\">{{ kpis.valeurStock|number_format(2, ',', ' ') }} MAD</h3>
                        </div>
                        <div class=\"bg-secondary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-archive text-secondary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">{{ kpis.produitsEnStock }} produit(s) en stock</small>
                </div>
            </div>
        </div>
        
        <!-- Produits en Stock -->
        <div class=\"col-md-3\">
            <div class=\"card-modern h-100\">
                <div class=\"card-body-modern\">
                    <div class=\"d-flex justify-content-between align-items-start mb-2\">
                        <div>
                            <h6 class=\"text-muted mb-1\">Produits en Stock</h6>
                            <h3 class=\"mb-0\">{{ kpis.produitsEnStock }}</h3>
                        </div>
                        <div class=\"bg-primary bg-opacity-10 p-2 rounded\">
                            <i class=\"bi bi-box text-primary\" style=\"font-size: 1.5rem;\"></i>
                        </div>
                    </div>
                    <small class=\"text-muted\">Neuf: {{ kpis.produitsNeufs }} | Occasion: {{ kpis.produitsOccasion }}</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Graphiques -->
    <div class=\"row g-4 mb-4\">
        <!-- Ventes par Période -->
        <div class=\"col-md-8\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-graph-up\"></i> Ventes par Période</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"ventesPeriodeChart\" height=\"80\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Ventes par Catégorie -->
        <div class=\"col-md-4\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-pie-chart\"></i> Ventes par Catégorie</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"ventesCategorieChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class=\"row g-4 mb-4\">
        <!-- Top Produits -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-trophy\"></i> Top 10 Produits</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"topProduitsChart\" height=\"300\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Paiements par Mode -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-credit-card\"></i> Paiements par Mode</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"paiementsModeChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class=\"row g-4 mb-4\">
        <!-- Provenance Achats -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-arrow-down-up\"></i> Provenance des Achats</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"provenanceAchatsChart\"></canvas>
                </div>
            </div>
        </div>
        
        <!-- Dépenses par Type -->
        <div class=\"col-md-6\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-cash-stack\"></i> Dépenses par Type</h5>
                </div>
                <div class=\"card-body-modern\">
                    <canvas id=\"depensesTypeChart\"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Rentabilité -->
    <div class=\"row g-4 mb-4\">
        <div class=\"col-md-12\">
            <div class=\"card-modern\">
                <div class=\"card-header-modern\">
                    <h5 class=\"mb-0\"><i class=\"bi bi-graph-up-arrow\"></i> Rentabilité</h5>
                </div>
                <div class=\"card-body-modern\">
                    <div class=\"row g-3 mb-3\">
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Total Ventes</h6>
                                <h4 class=\"mb-0 text-primary\">{{ graphiques.rentabilite.ventes|number_format(2, ',', ' ') }} MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Total Dépenses</h6>
                                <h4 class=\"mb-0 text-danger\">{{ graphiques.rentabilite.depenses|number_format(2, ',', ' ') }} MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Profit Brut</h6>
                                <h4 class=\"mb-0 text-success\">{{ graphiques.rentabilite.profit|number_format(2, ',', ' ') }} MAD</h4>
                            </div>
                        </div>
                        <div class=\"col-md-3\">
                            <div class=\"text-center p-3 bg-light rounded\">
                                <h6 class=\"text-muted mb-1\">Résultat Net</h6>
                                <h4 class=\"mb-0 {{ graphiques.rentabilite.resultatNet >= 0 ? 'text-success' : 'text-danger' }}\">
                                    {{ graphiques.rentabilite.resultatNet|number_format(2, ',', ' ') }} MAD
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Données pour les graphiques
        const ventesPeriodeData = {{ graphiques.ventesParPeriode|json_encode|raw }};
        const ventesCategorieData = {{ graphiques.ventesParCategorie|json_encode|raw }};
        const topProduitsData = {{ graphiques.topProduits|json_encode|raw }};
        const paiementsModeData = {{ graphiques.paiementsParMode|json_encode|raw }};
        const provenanceAchatsData = {{ graphiques.provenanceAchats|json_encode|raw }};
        const depensesTypeData = {{ graphiques.depensesParType|json_encode|raw }};

        // Graphique Ventes par Période
        const ctxVentesPeriode = document.getElementById('ventesPeriodeChart');
        if (ctxVentesPeriode) {
            new Chart(ctxVentesPeriode, {
                type: 'line',
                data: {
                    labels: ventesPeriodeData.map(v => v.date),
                    datasets: [{
                        label: 'Montant (MAD)',
                        data: ventesPeriodeData.map(v => parseFloat(v.total)),
                        borderColor: '#2563eb',
                        backgroundColor: 'rgba(37, 99, 235, 0.1)',
                        tension: 0.4,
                        fill: true
                    }, {
                        label: 'Nombre de ventes',
                        data: ventesPeriodeData.map(v => parseInt(v.nombre)),
                        borderColor: '#10b981',
                        backgroundColor: 'rgba(16, 185, 129, 0.1)',
                        tension: 0.4,
                        yAxisID: 'y1'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            position: 'left'
                        },
                        y1: {
                            type: 'linear',
                            display: true,
                            position: 'right',
                            beginAtZero: true,
                            grid: {
                                drawOnChartArea: false
                            }
                        }
                    }
                }
            });
        }

        // Graphique Ventes par Catégorie
        const ctxVentesCategorie = document.getElementById('ventesCategorieChart');
        if (ctxVentesCategorie) {
            new Chart(ctxVentesCategorie, {
                type: 'doughnut',
                data: {
                    labels: ventesCategorieData.map(v => v.categorie),
                    datasets: [{
                        data: ventesCategorieData.map(v => parseFloat(v.total)),
                        backgroundColor: [
                            '#2563eb', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6',
                            '#ec4899', '#06b6d4', '#84cc16', '#f97316', '#6366f1'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Top Produits
        const ctxTopProduits = document.getElementById('topProduitsChart');
        if (ctxTopProduits) {
            new Chart(ctxTopProduits, {
                type: 'bar',
                data: {
                    labels: topProduitsData.map(p => p.nom.length > 20 ? p.nom.substring(0, 20) + '...' : p.nom),
                    datasets: [{
                        label: 'Total vendu (MAD)',
                        data: topProduitsData.map(p => parseFloat(p.total)),
                        backgroundColor: '#2563eb'
                    }, {
                        label: 'Profit (MAD)',
                        data: topProduitsData.map(p => parseFloat(p.profit)),
                        backgroundColor: '#10b981'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        // Graphique Paiements par Mode
        const ctxPaiementsMode = document.getElementById('paiementsModeChart');
        if (ctxPaiementsMode) {
            const labels = Object.keys(paiementsModeData);
            const data = Object.values(paiementsModeData).map(v => parseFloat(v));
            new Chart(ctxPaiementsMode, {
                type: 'pie',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: [
                            '#2563eb', '#10b981', '#f59e0b', '#ef4444', '#8b5cf6', '#ec4899'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Provenance Achats
        const ctxProvenanceAchats = document.getElementById('provenanceAchatsChart');
        if (ctxProvenanceAchats) {
            new Chart(ctxProvenanceAchats, {
                type: 'doughnut',
                data: {
                    labels: ['Fournisseurs', 'Particuliers'],
                    datasets: [{
                        data: [
                            parseFloat(provenanceAchatsData.fournisseurs),
                            parseFloat(provenanceAchatsData.particuliers)
                        ],
                        backgroundColor: ['#2563eb', '#10b981']
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true
                }
            });
        }

        // Graphique Dépenses par Type
        const ctxDepensesType = document.getElementById('depensesTypeChart');
        if (ctxDepensesType) {
            const labels = Object.keys(depensesTypeData);
            const data = Object.values(depensesTypeData).map(v => parseFloat(v));
            new Chart(ctxDepensesType, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Montant (MAD)',
                        data: data,
                        backgroundColor: '#ef4444'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }

        // Fonction pour afficher/masquer les dates personnalisées
        function updatePeriodDates() {
            const period = document.getElementById('period-select').value;
            const customDates = document.getElementById('custom-dates');
            const customDatesEnd = document.getElementById('custom-dates-end');
            if (period === 'custom') {
                customDates.style.display = 'block';
                customDatesEnd.style.display = 'block';
            } else {
                customDates.style.display = 'none';
                customDatesEnd.style.display = 'none';
            }
        }
    </script>
{% endblock %}
", "dashboard/index.html.twig", "/var/www/html/templates/dashboard/index.html.twig");
    }
}
