<?php

namespace App\Validator\Constraints;

use App\Entity\Categorie;
use App\Repository\CategorieRepository;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

class UniqueCategorieNomValidator extends ConstraintValidator
{
    public function __construct(
        private CategorieRepository $categorieRepository
    ) {
    }

    public function validate($value, Constraint $constraint): void
    {
        if (!$constraint instanceof UniqueCategorieNom) {
            throw new UnexpectedTypeException($constraint, UniqueCategorieNom::class);
        }

        if (!$value instanceof Categorie) {
            return;
        }

        $magasin = $value->getMagasin();
        if (!$magasin) {
            return;
        }

        $existing = $this->categorieRepository->findOneBy([
            'nom' => $value->getNom(),
            'magasin' => $magasin
        ]);

        if ($existing && $existing->getId() !== $value->getId()) {
            $this->context->buildViolation($constraint->message)
                ->atPath('nom')
                ->addViolation();
        }
    }
}

