<?php

namespace App\Service;

use App\Entity\Produit;
use App\Entity\User;
use App\Entity\Magasin;
use App\Entity\MouvementStock;
use Doctrine\ORM\EntityManagerInterface;

class StockService
{
    public function __construct(
        private EntityManagerInterface $em
    ) {
    }

    public function enregistrerMouvement(
        Produit $produit,
        string $type,
        int $quantite,
        User $utilisateur,
        ?string $justification = null,
        ?\App\Entity\Vente $vente = null,
        ?\App\Entity\Achat $achat = null
    ): void {
        $quantiteAvant = $produit->getQuantite();
        
        if (in_array($type, [MouvementStock::TYPE_ENTREE_ACHAT, MouvementStock::TYPE_CORRECTION])) {
            $produit->setQuantite($quantiteAvant + $quantite);
        } elseif (in_array($type, [MouvementStock::TYPE_SORTIE_VENTE, MouvementStock::TYPE_RETOUR_FOURNISSEUR])) {
            $produit->setQuantite(max(0, $quantiteAvant - $quantite));
        }
        
        $quantiteApres = $produit->getQuantite();
        
        $mouvement = new MouvementStock();
        $mouvement->setProduit($produit);
        $mouvement->setType($type);
        $mouvement->setQuantite($quantite);
        $mouvement->setQuantiteAvant($quantiteAvant);
        $mouvement->setQuantiteApres($quantiteApres);
        $mouvement->setUtilisateur($utilisateur);
        $mouvement->setMagasin($produit->getMagasin());
        $mouvement->setJustification($justification);
        
        // Ne pas persister la vente/achat ici, ils doivent déjà être persistés
        if ($vente) {
            $mouvement->setVente($vente);
        }
        if ($achat) {
            $mouvement->setAchat($achat);
        }
        
        $this->em->persist($mouvement);
        $this->em->persist($produit);
        // Ne pas flush ici, laisser le contrôleur gérer le flush
    }
}

