<?php

namespace App\Repository;

use App\Entity\SousCategorie;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<SousCategorie>
 */
class SousCategorieRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, SousCategorie::class);
    }

    /**
     * Find all sous-categories for a specific category
     */
    public function findByCategorie(int $categorieId): array
    {
        return $this->createQueryBuilder('s')
            ->andWhere('s.categorie = :categorieId')
            ->setParameter('categorieId', $categorieId)
            ->orderBy('s.nom', 'ASC')
            ->getQuery()
            ->getResult();
    }
}

