<?php

namespace App\Controller;

use App\Entity\Achat;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/achats', name: 'achats_')]
#[IsGranted('ROLE_USER')]
class AchatController extends AbstractController
{
    #[Route('/{id}', name: 'show', methods: ['GET'])]
    public function show(Achat $achat): Response
    {
        $user = $this->getUser();
        if ($achat->getMagasin() !== $user->getMagasin()) {
            throw $this->createAccessDeniedException();
        }

        return $this->render('achat/show.html.twig', [
            'achat' => $achat,
        ]);
    }
}

