<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203032840 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE clients (id INT AUTO_INCREMENT NOT NULL, magasin_id INT NOT NULL, nom VARCHAR(255) NOT NULL, telephone VARCHAR(50) NOT NULL, cin VARCHAR(50) DEFAULT NULL, adresse LONGTEXT DEFAULT NULL, email VARCHAR(255) DEFAULT NULL, photo_cin VARCHAR(255) DEFAULT NULL, date_inscription DATETIME NOT NULL, INDEX IDX_C82E7420096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE paiements_client (id INT AUTO_INCREMENT NOT NULL, client_id INT NOT NULL, vente_id INT NOT NULL, utilisateur_id INT NOT NULL, montant NUMERIC(10, 2) NOT NULL, date_paiement DATETIME NOT NULL, mode VARCHAR(50) NOT NULL, reference VARCHAR(255) DEFAULT NULL, notes LONGTEXT DEFAULT NULL, date_creation DATETIME NOT NULL, INDEX IDX_8D94243E19EB6921 (client_id), INDEX IDX_8D94243E7DC7170A (vente_id), INDEX IDX_8D94243EFB88E14F (utilisateur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE clients ADD CONSTRAINT FK_C82E7420096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE paiements_client ADD CONSTRAINT FK_8D94243E19EB6921 FOREIGN KEY (client_id) REFERENCES clients (id)');
        $this->addSql('ALTER TABLE paiements_client ADD CONSTRAINT FK_8D94243E7DC7170A FOREIGN KEY (vente_id) REFERENCES ventes (id)');
        $this->addSql('ALTER TABLE paiements_client ADD CONSTRAINT FK_8D94243EFB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE ventes ADD client_id INT DEFAULT NULL, ADD statut_paiement VARCHAR(50) NOT NULL, ADD montant_paye NUMERIC(10, 2) NOT NULL, ADD montant_restant NUMERIC(10, 2) NOT NULL, ADD date_limite_paiement DATETIME DEFAULT NULL');
        $this->addSql('ALTER TABLE ventes ADD CONSTRAINT FK_64EC489A19EB6921 FOREIGN KEY (client_id) REFERENCES clients (id)');
        $this->addSql('CREATE INDEX IDX_64EC489A19EB6921 ON ventes (client_id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE ventes DROP FOREIGN KEY FK_64EC489A19EB6921');
        $this->addSql('ALTER TABLE clients DROP FOREIGN KEY FK_C82E7420096AE3');
        $this->addSql('ALTER TABLE paiements_client DROP FOREIGN KEY FK_8D94243E19EB6921');
        $this->addSql('ALTER TABLE paiements_client DROP FOREIGN KEY FK_8D94243E7DC7170A');
        $this->addSql('ALTER TABLE paiements_client DROP FOREIGN KEY FK_8D94243EFB88E14F');
        $this->addSql('DROP TABLE clients');
        $this->addSql('DROP TABLE paiements_client');
        $this->addSql('DROP INDEX IDX_64EC489A19EB6921 ON ventes');
        $this->addSql('ALTER TABLE ventes DROP client_id, DROP statut_paiement, DROP montant_paye, DROP montant_restant, DROP date_limite_paiement');
    }
}
