<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203024004 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        // Vérifier si les tables existent déjà
        $tableAchatsParticuliers = $this->connection->executeQuery("SHOW TABLES LIKE 'achats_particuliers'")->rowCount();
        if ($tableAchatsParticuliers == 0) {
            $this->addSql('CREATE TABLE achats_particuliers (id INT AUTO_INCREMENT NOT NULL, produit_id INT NOT NULL, utilisateur_id INT NOT NULL, magasin_id INT NOT NULL, nom_client VARCHAR(255) NOT NULL, telephone VARCHAR(50) NOT NULL, cin VARCHAR(50) DEFAULT NULL, adresse LONGTEXT DEFAULT NULL, prix_paye NUMERIC(10, 2) NOT NULL, photo_cin VARCHAR(255) DEFAULT NULL, date_achat DATETIME NOT NULL, UNIQUE INDEX UNIQ_192067BCF347EFB (produit_id), INDEX IDX_192067BCFB88E14F (utilisateur_id), INDEX IDX_192067BC20096AE3 (magasin_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        }
        
        // Vérifier si les contraintes existent déjà (même si la table existe)
        $constraintProduit = $this->connection->executeQuery("SELECT COUNT(*) FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_NAME = 'FK_192067BCF347EFB' AND TABLE_SCHEMA = DATABASE()")->fetchOne();
        if ($constraintProduit == 0) {
            $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BCF347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        }
        
        $constraintUser = $this->connection->executeQuery("SELECT COUNT(*) FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_NAME = 'FK_192067BCFB88E14F' AND TABLE_SCHEMA = DATABASE()")->fetchOne();
        if ($constraintUser == 0) {
            $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BCFB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        }
        
        $constraintMagasin = $this->connection->executeQuery("SELECT COUNT(*) FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_NAME = 'FK_192067BC20096AE3' AND TABLE_SCHEMA = DATABASE()")->fetchOne();
        if ($constraintMagasin == 0) {
            $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BC20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        }
        
        $tableImagesProduit = $this->connection->executeQuery("SHOW TABLES LIKE 'images_produit'")->rowCount();
        if ($tableImagesProduit == 0) {
            $this->addSql('CREATE TABLE images_produit (id INT AUTO_INCREMENT NOT NULL, produit_id INT NOT NULL, nom_fichier VARCHAR(255) NOT NULL, chemin VARCHAR(255) NOT NULL, ordre INT NOT NULL, principale TINYINT(1) NOT NULL, date_creation DATETIME NOT NULL, INDEX IDX_B6D8F245F347EFB (produit_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        }
        
        $constraintImage = $this->connection->executeQuery("SELECT COUNT(*) FROM information_schema.TABLE_CONSTRAINTS WHERE CONSTRAINT_NAME = 'FK_B6D8F245F347EFB' AND TABLE_SCHEMA = DATABASE()")->fetchOne();
        if ($constraintImage == 0) {
            $this->addSql('ALTER TABLE images_produit ADD CONSTRAINT FK_B6D8F245F347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        }
        $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BCF347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BCFB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        $this->addSql('ALTER TABLE achats_particuliers ADD CONSTRAINT FK_192067BC20096AE3 FOREIGN KEY (magasin_id) REFERENCES magasins (id)');
        $this->addSql('ALTER TABLE images_produit ADD CONSTRAINT FK_B6D8F245F347EFB FOREIGN KEY (produit_id) REFERENCES produits (id)');
        // Ajouter les nouveaux champs avec valeurs par défaut
        $this->addSql('ALTER TABLE produits ADD achat_fournisseur_id INT DEFAULT NULL, ADD reference_interne VARCHAR(255) DEFAULT NULL, ADD imei VARCHAR(50) DEFAULT NULL, ADD numero_serie VARCHAR(100) DEFAULT NULL, ADD marge_minimale NUMERIC(10, 2) DEFAULT NULL, ADD prix_vente_recommandé NUMERIC(10, 2) DEFAULT NULL, ADD origine_achat VARCHAR(50) DEFAULT NULL, ADD date_achat DATETIME DEFAULT NULL, CHANGE sous_categorie_id sous_categorie_id INT NOT NULL, CHANGE prix_vente prix_vente NUMERIC(10, 2) DEFAULT NULL, CHANGE etat statut VARCHAR(50) DEFAULT NULL');
        
        // Initialiser les valeurs pour les produits existants
        $this->addSql('UPDATE produits SET date_achat = date_entree WHERE date_achat IS NULL');
        $this->addSql('UPDATE produits SET origine_achat = "fournisseur" WHERE origine_achat IS NULL');
        $this->addSql('UPDATE produits SET statut = "en_stock" WHERE statut IS NULL');
        
        // Modifier la table produits (vérifier l'existence des colonnes d'abord)
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'achat_fournisseur_id'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD achat_fournisseur_id INT DEFAULT NULL');
            $this->addSql('ALTER TABLE produits ADD CONSTRAINT FK_BE2DDF8CEE4462DB FOREIGN KEY (achat_fournisseur_id) REFERENCES achats (id)');
            $this->addSql('CREATE INDEX IDX_BE2DDF8CEE4462DB ON produits (achat_fournisseur_id)');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'reference_interne'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD reference_interne VARCHAR(255) DEFAULT NULL');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'imei'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD imei VARCHAR(50) DEFAULT NULL');
            $this->addSql('CREATE UNIQUE INDEX UNIQ_BE2DDF8CB8179F8 ON produits (imei)');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'numero_serie'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD numero_serie VARCHAR(100) DEFAULT NULL');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'marge_minimale'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD marge_minimale NUMERIC(10, 2) DEFAULT NULL');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'prix_vente_recommandé'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD prix_vente_recommandé NUMERIC(10, 2) DEFAULT NULL');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'origine_achat'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD origine_achat VARCHAR(50) DEFAULT NULL');
            $this->addSql('UPDATE produits SET origine_achat = "fournisseur" WHERE origine_achat IS NULL');
            $this->addSql('ALTER TABLE produits MODIFY origine_achat VARCHAR(50) NOT NULL');
        }
        
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'date_achat'")->rowCount();
        if ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD date_achat DATETIME DEFAULT NULL');
            $this->addSql('UPDATE produits SET date_achat = date_entree WHERE date_achat IS NULL');
            $this->addSql('ALTER TABLE produits MODIFY date_achat DATETIME NOT NULL');
        }
        
        // Vérifier si la colonne statut existe, sinon renommer etat en statut
        $produitsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'statut'")->rowCount();
        $produitsColumnsEtat = $this->connection->executeQuery("SHOW COLUMNS FROM produits LIKE 'etat'")->rowCount();
        if ($produitsColumns == 0 && $produitsColumnsEtat > 0) {
            $this->addSql('ALTER TABLE produits CHANGE etat statut VARCHAR(50) DEFAULT NULL');
            $this->addSql('UPDATE produits SET statut = "en_stock" WHERE statut IS NULL');
            $this->addSql('ALTER TABLE produits MODIFY statut VARCHAR(50) NOT NULL');
        } elseif ($produitsColumns == 0) {
            $this->addSql('ALTER TABLE produits ADD statut VARCHAR(50) DEFAULT NULL');
            $this->addSql('UPDATE produits SET statut = "en_stock" WHERE statut IS NULL');
            $this->addSql('ALTER TABLE produits MODIFY statut VARCHAR(50) NOT NULL');
        }
        
        // Modifier sous_categorie_id pour être NOT NULL
        $this->addSql('UPDATE produits SET sous_categorie_id = (SELECT id FROM sous_categories WHERE categorie_id = produits.categorie_id LIMIT 1) WHERE sous_categorie_id IS NULL');
        $this->addSql('ALTER TABLE produits MODIFY sous_categorie_id INT NOT NULL');
        
        // Modifier prix_vente pour être nullable
        $this->addSql('ALTER TABLE produits MODIFY prix_vente NUMERIC(10, 2) DEFAULT NULL');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE achats_particuliers DROP FOREIGN KEY FK_192067BCF347EFB');
        $this->addSql('ALTER TABLE achats_particuliers DROP FOREIGN KEY FK_192067BCFB88E14F');
        $this->addSql('ALTER TABLE achats_particuliers DROP FOREIGN KEY FK_192067BC20096AE3');
        $this->addSql('ALTER TABLE images_produit DROP FOREIGN KEY FK_B6D8F245F347EFB');
        $this->addSql('DROP TABLE achats_particuliers');
        $this->addSql('DROP TABLE images_produit');
        $this->addSql('ALTER TABLE produits DROP FOREIGN KEY FK_BE2DDF8CEE4462DB');
        $this->addSql('DROP INDEX UNIQ_BE2DDF8CB8179F8 ON produits');
        $this->addSql('DROP INDEX IDX_BE2DDF8CEE4462DB ON produits');
        $this->addSql('ALTER TABLE produits ADD etat VARCHAR(50) NOT NULL, DROP achat_fournisseur_id, DROP reference_interne, DROP imei, DROP numero_serie, DROP marge_minimale, DROP prix_vente_recommandé, DROP statut, DROP origine_achat, DROP date_achat, CHANGE sous_categorie_id sous_categorie_id INT DEFAULT NULL, CHANGE prix_vente prix_vente NUMERIC(10, 2) NOT NULL');
    }
}
