<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20251203021334 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        // Vérifier si la table paiements existe déjà
        $tableExists = $this->connection->executeQuery("SHOW TABLES LIKE 'paiements'")->rowCount() > 0;
        
        if (!$tableExists) {
            $this->addSql('CREATE TABLE paiements (id INT AUTO_INCREMENT NOT NULL, fournisseur_id INT NOT NULL, achat_id INT NOT NULL, utilisateur_id INT NOT NULL, montant NUMERIC(10, 2) NOT NULL, date_paiement DATETIME NOT NULL, mode VARCHAR(50) NOT NULL, reference VARCHAR(255) DEFAULT NULL, notes LONGTEXT DEFAULT NULL, date_creation DATETIME NOT NULL, INDEX IDX_E1B02E12670C757F (fournisseur_id), INDEX IDX_E1B02E12FE95D117 (achat_id), INDEX IDX_E1B02E12FB88E14F (utilisateur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
            $this->addSql('ALTER TABLE paiements ADD CONSTRAINT FK_E1B02E12670C757F FOREIGN KEY (fournisseur_id) REFERENCES fournisseurs (id)');
            $this->addSql('ALTER TABLE paiements ADD CONSTRAINT FK_E1B02E12FE95D117 FOREIGN KEY (achat_id) REFERENCES achats (id)');
            $this->addSql('ALTER TABLE paiements ADD CONSTRAINT FK_E1B02E12FB88E14F FOREIGN KEY (utilisateur_id) REFERENCES users (id)');
        }
        // Ajouter les nouveaux champs à achats (vérifier l'existence d'abord)
        $achatsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM achats LIKE 'reference_facture'")->rowCount();
        if ($achatsColumns == 0) {
            $this->addSql('ALTER TABLE achats ADD reference_facture VARCHAR(255) DEFAULT NULL');
        }
        
        $achatsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM achats LIKE 'montant_restant'")->rowCount();
        if ($achatsColumns == 0) {
            $this->addSql('ALTER TABLE achats ADD montant_restant NUMERIC(10, 2) DEFAULT NULL');
            // Initialiser montant_restant avec montant_total pour les achats existants
            $this->addSql('UPDATE achats SET montant_restant = montant_total WHERE montant_restant IS NULL');
            // Rendre montant_restant NOT NULL après initialisation
            $this->addSql('ALTER TABLE achats MODIFY montant_restant NUMERIC(10, 2) NOT NULL');
        }
        
        $achatsColumns = $this->connection->executeQuery("SHOW COLUMNS FROM achats LIKE 'date_limite_paiement'")->rowCount();
        if ($achatsColumns == 0) {
            $this->addSql('ALTER TABLE achats ADD date_limite_paiement DATETIME DEFAULT NULL');
        }
        
        // Ajouter les nouveaux champs à fournisseurs (vérifier l'existence d'abord)
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'type'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD type VARCHAR(50) DEFAULT NULL');
            // Migrer les données existantes
            $this->addSql('UPDATE fournisseurs SET type = "distributeur" WHERE type IS NULL');
            $this->addSql('ALTER TABLE fournisseurs MODIFY type VARCHAR(50) NOT NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'telephones'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD telephones JSON DEFAULT NULL');
            // Migrer téléphone vers telephones JSON
            $this->addSql('UPDATE fournisseurs SET telephones = JSON_ARRAY(telephone) WHERE telephone IS NOT NULL AND telephones IS NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'ville'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD ville VARCHAR(100) DEFAULT NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'pays'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD pays VARCHAR(100) DEFAULT NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'notes'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD notes LONGTEXT DEFAULT NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'statut'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD statut VARCHAR(20) DEFAULT NULL');
            // Migrer les données existantes
            $this->addSql('UPDATE fournisseurs SET statut = IF(actif = 1, "actif", "desactive") WHERE statut IS NULL');
            $this->addSql('ALTER TABLE fournisseurs MODIFY statut VARCHAR(20) NOT NULL');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'date_modification'")->rowCount();
        if ($fournisseursColumns == 0) {
            $this->addSql('ALTER TABLE fournisseurs ADD date_modification DATETIME DEFAULT NULL');
        }
        
        // Supprimer les anciens champs s'ils existent
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'contact'")->rowCount();
        if ($fournisseursColumns > 0) {
            $this->addSql('ALTER TABLE fournisseurs DROP contact');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'telephone'")->rowCount();
        if ($fournisseursColumns > 0) {
            $this->addSql('ALTER TABLE fournisseurs DROP telephone');
        }
        
        $fournisseursColumns = $this->connection->executeQuery("SHOW COLUMNS FROM fournisseurs LIKE 'actif'")->rowCount();
        if ($fournisseursColumns > 0) {
            $this->addSql('ALTER TABLE fournisseurs DROP actif');
        }
        
        // Nettoyer les doublons avant d'ajouter la contrainte unique
        // Identifier les doublons et garder le premier, réassigner les relations
        $this->addSql('
            UPDATE achats a
            INNER JOIN (
                SELECT MIN(id) as keep_id, nom, magasin_id
                FROM fournisseurs
                GROUP BY nom, magasin_id
                HAVING COUNT(*) > 1
            ) dup ON a.fournisseur_id != dup.keep_id AND EXISTS (
                SELECT 1 FROM fournisseurs f 
                WHERE f.id = a.fournisseur_id 
                AND f.nom = dup.nom 
                AND f.magasin_id = dup.magasin_id
            )
            SET a.fournisseur_id = dup.keep_id
        ');
        
        $this->addSql('
            UPDATE produits p
            INNER JOIN (
                SELECT MIN(id) as keep_id, nom, magasin_id
                FROM fournisseurs
                GROUP BY nom, magasin_id
                HAVING COUNT(*) > 1
            ) dup ON p.fournisseur_id != dup.keep_id AND EXISTS (
                SELECT 1 FROM fournisseurs f 
                WHERE f.id = p.fournisseur_id 
                AND f.nom = dup.nom 
                AND f.magasin_id = dup.magasin_id
            )
            SET p.fournisseur_id = dup.keep_id
        ');
        
        // Supprimer les doublons
        $this->addSql('
            DELETE f1 FROM fournisseurs f1
            INNER JOIN fournisseurs f2 
            WHERE f1.id > f2.id 
            AND f1.nom = f2.nom 
            AND f1.magasin_id = f2.magasin_id
        ');
        
        // Maintenant on peut ajouter la contrainte unique
        $this->addSql('CREATE UNIQUE INDEX unique_nom_magasin ON fournisseurs (nom, magasin_id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE paiements DROP FOREIGN KEY FK_E1B02E12670C757F');
        $this->addSql('ALTER TABLE paiements DROP FOREIGN KEY FK_E1B02E12FE95D117');
        $this->addSql('ALTER TABLE paiements DROP FOREIGN KEY FK_E1B02E12FB88E14F');
        $this->addSql('DROP TABLE paiements');
        $this->addSql('ALTER TABLE achats DROP reference_facture, DROP montant_restant, DROP date_limite_paiement');
        $this->addSql('DROP INDEX unique_nom_magasin ON fournisseurs');
        $this->addSql('ALTER TABLE fournisseurs ADD contact VARCHAR(255) DEFAULT NULL, ADD telephone VARCHAR(20) DEFAULT NULL, ADD actif TINYINT(1) NOT NULL, DROP type, DROP telephones, DROP ville, DROP pays, DROP notes, DROP statut, DROP date_modification');
    }
}
