# Guide de Déploiement en Production

Ce guide vous explique comment déployer l'application de gestion de stock sur un serveur de production.

## Prérequis

- Serveur Linux (Ubuntu 20.04+ recommandé)
- Docker et Docker Compose installés
- Accès root ou utilisateur avec droits sudo
- Nom de domaine configuré (optionnel mais recommandé)

## 1. Préparation du serveur

### Installer Docker et Docker Compose

```bash
# Mettre à jour le système
sudo apt update && sudo apt upgrade -y

# Installer Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh

# Installer Docker Compose
sudo curl -L "https://github.com/docker/compose/releases/latest/download/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
sudo chmod +x /usr/local/bin/docker-compose

# Vérifier l'installation
docker --version
docker-compose --version
```

## 2. Cloner le projet

```bash
# Créer un répertoire pour l'application
sudo mkdir -p /var/www
cd /var/www

# Cloner le repository (remplacer par votre URL)
git clone <votre-repository-url> facture
cd facture
```

## 3. Configuration de l'environnement

### Créer le fichier .env

```bash
# Copier le fichier d'exemple
cp .env.example .env

# Éditer le fichier .env avec vos valeurs
nano .env
```

### Variables d'environnement importantes à configurer :

```env
APP_ENV=prod
APP_SECRET=votre-secret-aleatoire-très-long-et-sécurisé
APP_DEBUG=false

DATABASE_URL="mysql://utilisateur:motdepasse@db:3306/nom_base?serverVersion=8.0"

MYSQL_ROOT_PASSWORD=votre-mot-de-passe-root-très-sécurisé
MYSQL_DATABASE=saasinfo
MYSQL_USER=saasinfo
MYSQL_PASSWORD=votre-mot-de-passe-sécurisé

JWT_PASSPHRASE=votre-passphrase-jwt-sécurisé
```

### Générer un APP_SECRET sécurisé

```bash
# Générer un secret aléatoire
php -r "echo bin2hex(random_bytes(32)) . PHP_EOL;"
```

### Configurer JWT (si nécessaire)

```bash
# Créer le répertoire pour les clés JWT
mkdir -p config/jwt

# Générer les clés JWT (remplacer YOUR_PASSPHRASE)
php bin/console lexik:jwt:generate-keypair --skip-if-exists
```

## 4. Configuration Nginx pour la production

Créer le fichier de configuration Nginx optimisé pour la production :

```bash
nano docker/nginx/nginx.prod.conf
```

## 5. Construire et démarrer les conteneurs

```bash
# Construire les images
docker-compose -f docker-compose.prod.yml build

# Démarrer les conteneurs
docker-compose -f docker-compose.prod.yml up -d

# Vérifier que les conteneurs sont en cours d'exécution
docker-compose -f docker-compose.prod.yml ps
```

## 6. Installation de l'application

```bash
# Installer les dépendances (déjà fait dans le Dockerfile, mais au cas où)
docker-compose -f docker-compose.prod.yml exec php composer install --no-dev --optimize-autoloader

# Créer la base de données (si elle n'existe pas déjà)
docker-compose -f docker-compose.prod.yml exec php php bin/console doctrine:database:create --if-not-exists

# Exécuter les migrations
docker-compose -f docker-compose.prod.yml exec php php bin/console doctrine:migrations:migrate --no-interaction

# Vider et réchauffer le cache
docker-compose -f docker-compose.prod.yml exec php php bin/console cache:clear --env=prod
docker-compose -f docker-compose.prod.yml exec php php bin/console cache:warmup --env=prod

# Créer un utilisateur administrateur
docker-compose -f docker-compose.prod.yml exec php php bin/console app:create-admin
```

## 7. Configuration des permissions

```bash
# Définir les bonnes permissions
sudo chown -R www-data:www-data /var/www/facture
sudo chmod -R 755 /var/www/facture
sudo chmod -R 775 /var/www/facture/var
sudo chmod -R 775 /var/www/facture/public/uploads
```

## 8. Configuration SSL avec Let's Encrypt (Optionnel mais recommandé)

### Installer Certbot

```bash
sudo apt install certbot python3-certbot-nginx -y
```

### Obtenir un certificat SSL

```bash
sudo certbot --nginx -d votre-domaine.com -d www.votre-domaine.com
```

## 9. Configuration du firewall

```bash
# Autoriser HTTP et HTTPS
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp

# Activer le firewall
sudo ufw enable
```

## 10. Surveillance et logs

### Voir les logs

```bash
# Logs de tous les conteneurs
docker-compose -f docker-compose.prod.yml logs -f

# Logs d'un conteneur spécifique
docker-compose -f docker-compose.prod.yml logs -f php
docker-compose -f docker-compose.prod.yml logs -f nginx
```

### Vérifier l'état des conteneurs

```bash
docker-compose -f docker-compose.prod.yml ps
docker stats
```

## 11. Sauvegarde de la base de données

Créer un script de sauvegarde automatique :

```bash
# Créer le script de sauvegarde
sudo nano /usr/local/bin/backup-facture.sh
```

Contenu du script :

```bash
#!/bin/bash
BACKUP_DIR="/var/backups/facture"
DATE=$(date +%Y%m%d_%H%M%S)
DB_NAME="saasinfo"
DB_USER="saasinfo"
DB_PASS="votre-mot-de-passe"

mkdir -p $BACKUP_DIR

docker-compose -f /var/www/facture/docker-compose.prod.yml exec -T db mysqldump -u$DB_USER -p$DB_PASS $DB_NAME > $BACKUP_DIR/backup_$DATE.sql

# Supprimer les sauvegardes de plus de 30 jours
find $BACKUP_DIR -name "backup_*.sql" -mtime +30 -delete
```

Rendre le script exécutable :

```bash
sudo chmod +x /usr/local/bin/backup-facture.sh
```

Ajouter une tâche cron pour la sauvegarde quotidienne :

```bash
sudo crontab -e
# Ajouter cette ligne pour une sauvegarde quotidienne à 2h du matin
0 2 * * * /usr/local/bin/backup-facture.sh
```

## 12. Mise à jour de l'application

Pour mettre à jour l'application :

```bash
cd /var/www/facture

# Récupérer les dernières modifications
git pull origin main

# Reconstruire les images
docker-compose -f docker-compose.prod.yml build

# Redémarrer les conteneurs
docker-compose -f docker-compose.prod.yml up -d

# Exécuter les migrations
docker-compose -f docker-compose.prod.yml exec php php bin/console doctrine:migrations:migrate --no-interaction

# Vider le cache
docker-compose -f docker-compose.prod.yml exec php php bin/console cache:clear --env=prod
docker-compose -f docker-compose.prod.yml exec php php bin/console cache:warmup --env=prod
```

## 13. Dépannage

### Le site ne charge pas

```bash
# Vérifier les logs
docker-compose -f docker-compose.prod.yml logs nginx
docker-compose -f docker-compose.prod.yml logs php

# Vérifier que les conteneurs sont en cours d'exécution
docker-compose -f docker-compose.prod.yml ps

# Redémarrer les conteneurs
docker-compose -f docker-compose.prod.yml restart
```

### Problèmes de permissions

```bash
sudo chown -R www-data:www-data /var/www/facture
sudo chmod -R 755 /var/www/facture
sudo chmod -R 775 /var/www/facture/var
```

### Problèmes de base de données

```bash
# Vérifier la connexion à la base de données
docker-compose -f docker-compose.prod.yml exec php php bin/console doctrine:query:sql "SELECT 1"

# Vérifier les logs de la base de données
docker-compose -f docker-compose.prod.yml logs db
```

## 14. Sécurité

- ✅ Changez tous les mots de passe par défaut
- ✅ Utilisez des mots de passe forts
- ✅ Activez le firewall
- ✅ Configurez SSL/HTTPS
- ✅ Gardez Docker et les images à jour
- ✅ Limitez l'accès SSH
- ✅ Configurez des sauvegardes automatiques
- ✅ Surveillez les logs régulièrement

## 15. Script de déploiement automatique

Un script `deploy.sh` est fourni pour faciliter le déploiement. Consultez le fichier pour plus de détails.

## Support

Pour toute question ou problème, consultez la documentation ou contactez le support technique.

