<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* vente/show.html.twig */
class __TwigTemplate_524d276341f12de963cd196f04f692bf extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/show.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "vente/show.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Facture ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 3, $this->source); })()), "numeroFacture", [], "any", false, false, false, 3), "html", null, true);
        yield " - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Facture ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 4, $this->source); })()), "numeroFacture", [], "any", false, false, false, 4), "html", null, true);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<div class=\"fade-in\">
    <div class=\"row justify-content-center\">
        <div class=\"col-lg-8\">
            <div class=\"stat-card\">
                <div class=\"text-center mb-4 pb-4 border-bottom\">
                    <h3 class=\"fw-bold mb-2\">Facture ";
        // line 12
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 12, $this->source); })()), "numeroFacture", [], "any", false, false, false, 12), "html", null, true);
        yield "</h3>
                    <p class=\"text-muted mb-0\">";
        // line 13
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 13, $this->source); })()), "dateVente", [], "any", false, false, false, 13), "d/m/Y à H:i"), "html", null, true);
        yield "</p>
                </div>

                <div class=\"row mb-4\">
                    <div class=\"col-md-6\">
                        <strong>Vendeur:</strong>
                        <p class=\"mb-0\">";
        // line 19
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 19, $this->source); })()), "vendeur", [], "any", false, false, false, 19), "getFullName", [], "method", false, false, false, 19), "html", null, true);
        yield "</p>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Mode de paiement:</strong>
                        <p class=\"mb-0\">
                            <span class=\"badge bg-info badge-modern\">";
        // line 24
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 24, $this->source); })()), "modePaiement", [], "any", false, false, false, 24), "html", null, true);
        yield "</span>
                        </p>
                    </div>
                </div>

                <div class=\"table-responsive\">
                    <table class=\"table table-modern\">
                        <thead>
                            <tr>
                                <th>Produit</th>
                                <th>Quantité</th>
                                <th>Prix unitaire</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            ";
        // line 40
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 40, $this->source); })()), "lignesVente", [], "any", false, false, false, 40));
        foreach ($context['_seq'] as $context["_key"] => $context["ligne"]) {
            // line 41
            yield "                            <tr>
                                <td><strong>";
            // line 42
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "produit", [], "any", false, false, false, 42), "nom", [], "any", false, false, false, 42), "html", null, true);
            yield "</strong></td>
                                <td>";
            // line 43
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "quantite", [], "any", false, false, false, 43), "html", null, true);
            yield "</td>
                                <td>";
            // line 44
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "prixUnitaire", [], "any", false, false, false, 44), 2, ",", " "), "html", null, true);
            yield " MAD</td>
                                <td><strong>";
            // line 45
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["ligne"], "montantTotal", [], "any", false, false, false, 45), 2, ",", " "), "html", null, true);
            yield " MAD</strong></td>
                            </tr>
                            ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['ligne'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 48
        yield "                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan=\"3\" class=\"text-end\">Sous-total</th>
                                <th>";
        // line 52
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 52, $this->source); })()), "montantTotal", [], "any", false, false, false, 52), 2, ",", " "), "html", null, true);
        yield " MAD</th>
                            </tr>
                            ";
        // line 54
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 54, $this->source); })()), "reduction", [], "any", false, false, false, 54) > 0)) {
            // line 55
            yield "                            <tr>
                                <th colspan=\"3\" class=\"text-end\">Réduction</th>
                                <th class=\"text-danger\">-";
            // line 57
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 57, $this->source); })()), "reduction", [], "any", false, false, false, 57), 2, ",", " "), "html", null, true);
            yield " MAD</th>
                            </tr>
                            ";
        }
        // line 60
        yield "                            <tr class=\"table-primary\">
                                <th colspan=\"3\" class=\"text-end\">Total</th>
                                <th class=\"h5\">";
        // line 62
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 62, $this->source); })()), "montantFinal", [], "any", false, false, false, 62), 2, ",", " "), "html", null, true);
        yield " MAD</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class=\"card mt-4\">
                    <div class=\"card-header\">
                        <h5 class=\"mb-0\">Informations de paiement</h5>
                    </div>
                    <div class=\"card-body\">
                        <div class=\"row mb-3\">
                            <div class=\"col-md-6\">
                                <strong>Statut:</strong>
                                <span class=\"badge badge-";
        // line 76
        yield (((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 76, $this->source); })()), "statutPaiement", [], "any", false, false, false, 76) == "paye")) ? ("success") : ((((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 76, $this->source); })()), "statutPaiement", [], "any", false, false, false, 76) == "partiel")) ? ("warning") : ("danger"))));
        yield "\">
                                    ";
        // line 77
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 77, $this->source); })()), "statutPaiement", [], "any", false, false, false, 77) == "paye")) {
            yield "Payé
                                    ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source,         // line 78
(isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 78, $this->source); })()), "statutPaiement", [], "any", false, false, false, 78) == "partiel")) {
            yield "Partiel
                                    ";
        } else {
            // line 79
            yield "Impayé
                                    ";
        }
        // line 81
        yield "                                </span>
                            </div>
                            <div class=\"col-md-6\">
                                <strong>Montant total:</strong>
                                <span class=\"text-primary fw-bold\">";
        // line 85
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 85, $this->source); })()), "montantFinal", [], "any", false, false, false, 85), 2, ",", " "), "html", null, true);
        yield " MAD</span>
                            </div>
                        </div>
                        <div class=\"row mb-3\">
                            <div class=\"col-md-6\">
                                <strong>Montant payé:</strong>
                                <span class=\"text-success fw-bold\">";
        // line 91
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 91, $this->source); })()), "montantPaye", [], "any", false, false, false, 91), 2, ",", " "), "html", null, true);
        yield " MAD</span>
                            </div>
                            <div class=\"col-md-6\">
                                <strong>Montant restant:</strong>
                                ";
        // line 95
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 95, $this->source); })()), "montantRestant", [], "any", false, false, false, 95) > 0)) {
            // line 96
            yield "                                <span class=\"text-danger fw-bold\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 96, $this->source); })()), "montantRestant", [], "any", false, false, false, 96), 2, ",", " "), "html", null, true);
            yield " MAD</span>
                                ";
        } else {
            // line 98
            yield "                                <span class=\"text-success fw-bold\">0,00 MAD</span>
                                ";
        }
        // line 100
        yield "                            </div>
                        </div>
                        
                        ";
        // line 103
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 103, $this->source); })()), "paiementsClient", [], "any", false, false, false, 103)) > 0)) {
            // line 104
            yield "                        <div class=\"mt-4\">
                            <h6 class=\"mb-3\">Historique des paiements</h6>
                            <div class=\"table-responsive\">
                                <table class=\"table table-sm\">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Montant</th>
                                            <th>Mode</th>
                                            <th>Référence</th>
                                            <th>Par</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ";
            // line 118
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(Twig\Extension\CoreExtension::sort($this->env, CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 118, $this->source); })()), "paiementsClient", [], "any", false, false, false, 118), function ($__a__, $__b__) use ($context, $macros) { $context["a"] = $__a__; $context["b"] = $__b__; return (CoreExtension::getAttribute($this->env, $this->source, (isset($context["b"]) || array_key_exists("b", $context) ? $context["b"] : (function () { throw new RuntimeError('Variable "b" does not exist.', 118, $this->source); })()), "datePaiement", [], "any", false, false, false, 118) <=> CoreExtension::getAttribute($this->env, $this->source, (isset($context["a"]) || array_key_exists("a", $context) ? $context["a"] : (function () { throw new RuntimeError('Variable "a" does not exist.', 118, $this->source); })()), "datePaiement", [], "any", false, false, false, 118)); }));
            foreach ($context['_seq'] as $context["_key"] => $context["paiement"]) {
                // line 119
                yield "                                        <tr>
                                            <td>";
                // line 120
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "datePaiement", [], "any", false, false, false, 120), "d/m/Y à H:i"), "html", null, true);
                yield "</td>
                                            <td class=\"fw-bold text-success\">";
                // line 121
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatNumber(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "montant", [], "any", false, false, false, 121), 2, ",", " "), "html", null, true);
                yield " MAD</td>
                                            <td>
                                                ";
                // line 123
                if ((CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "mode", [], "any", false, false, false, 123) == "cash")) {
                    yield "Espèces
                                                ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 124
$context["paiement"], "mode", [], "any", false, false, false, 124) == "carte")) {
                    yield "Carte
                                                ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 125
$context["paiement"], "mode", [], "any", false, false, false, 125) == "virement")) {
                    yield "Virement
                                                ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 126
$context["paiement"], "mode", [], "any", false, false, false, 126) == "cheque")) {
                    yield "Chèque
                                                ";
                } else {
                    // line 127
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "mode", [], "any", false, false, false, 127), "html", null, true);
                    yield "
                                                ";
                }
                // line 129
                yield "                                            </td>
                                            <td>";
                // line 130
                yield (((CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", true, true, false, 130) &&  !(null === CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", false, false, false, 130)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "reference", [], "any", false, false, false, 130), "html", null, true)) : ("-"));
                yield "</td>
                                            <td>";
                // line 131
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["paiement"], "utilisateur", [], "any", false, false, false, 131), "getFullName", [], "method", false, false, false, 131), "html", null, true);
                yield "</td>
                                        </tr>
                                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['paiement'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 134
            yield "                                    </tbody>
                                </table>
                            </div>
                        </div>
                        ";
        }
        // line 139
        yield "                    </div>
                </div>

                <div class=\"d-flex gap-2 mt-4\">
                    <a href=\"";
        // line 143
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_index");
        yield "\" class=\"btn btn-outline-secondary btn-modern\">
                        <i class=\"bi bi-arrow-left\"></i> Retour
                    </a>
                    <a href=\"";
        // line 146
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("ventes_imprimer", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["vente"]) || array_key_exists("vente", $context) ? $context["vente"] : (function () { throw new RuntimeError('Variable "vente" does not exist.', 146, $this->source); })()), "id", [], "any", false, false, false, 146)]), "html", null, true);
        yield "\" class=\"btn btn-outline-primary btn-modern\" target=\"_blank\">
                        <i class=\"bi bi-printer\"></i> Imprimer
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "vente/show.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  393 => 146,  387 => 143,  381 => 139,  374 => 134,  365 => 131,  361 => 130,  358 => 129,  353 => 127,  348 => 126,  344 => 125,  340 => 124,  336 => 123,  331 => 121,  327 => 120,  324 => 119,  320 => 118,  304 => 104,  302 => 103,  297 => 100,  293 => 98,  287 => 96,  285 => 95,  278 => 91,  269 => 85,  263 => 81,  259 => 79,  254 => 78,  250 => 77,  246 => 76,  229 => 62,  225 => 60,  219 => 57,  215 => 55,  213 => 54,  208 => 52,  202 => 48,  193 => 45,  189 => 44,  185 => 43,  181 => 42,  178 => 41,  174 => 40,  155 => 24,  147 => 19,  138 => 13,  134 => 12,  127 => 7,  114 => 6,  90 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Facture {{ vente.numeroFacture }} - Stock Manager{% endblock %}
{% block page_title %}Facture {{ vente.numeroFacture }}{% endblock %}

{% block content %}
<div class=\"fade-in\">
    <div class=\"row justify-content-center\">
        <div class=\"col-lg-8\">
            <div class=\"stat-card\">
                <div class=\"text-center mb-4 pb-4 border-bottom\">
                    <h3 class=\"fw-bold mb-2\">Facture {{ vente.numeroFacture }}</h3>
                    <p class=\"text-muted mb-0\">{{ vente.dateVente|date('d/m/Y à H:i') }}</p>
                </div>

                <div class=\"row mb-4\">
                    <div class=\"col-md-6\">
                        <strong>Vendeur:</strong>
                        <p class=\"mb-0\">{{ vente.vendeur.getFullName() }}</p>
                    </div>
                    <div class=\"col-md-6\">
                        <strong>Mode de paiement:</strong>
                        <p class=\"mb-0\">
                            <span class=\"badge bg-info badge-modern\">{{ vente.modePaiement }}</span>
                        </p>
                    </div>
                </div>

                <div class=\"table-responsive\">
                    <table class=\"table table-modern\">
                        <thead>
                            <tr>
                                <th>Produit</th>
                                <th>Quantité</th>
                                <th>Prix unitaire</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            {% for ligne in vente.lignesVente %}
                            <tr>
                                <td><strong>{{ ligne.produit.nom }}</strong></td>
                                <td>{{ ligne.quantite }}</td>
                                <td>{{ ligne.prixUnitaire|number_format(2, ',', ' ') }} MAD</td>
                                <td><strong>{{ ligne.montantTotal|number_format(2, ',', ' ') }} MAD</strong></td>
                            </tr>
                            {% endfor %}
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan=\"3\" class=\"text-end\">Sous-total</th>
                                <th>{{ vente.montantTotal|number_format(2, ',', ' ') }} MAD</th>
                            </tr>
                            {% if vente.reduction > 0 %}
                            <tr>
                                <th colspan=\"3\" class=\"text-end\">Réduction</th>
                                <th class=\"text-danger\">-{{ vente.reduction|number_format(2, ',', ' ') }} MAD</th>
                            </tr>
                            {% endif %}
                            <tr class=\"table-primary\">
                                <th colspan=\"3\" class=\"text-end\">Total</th>
                                <th class=\"h5\">{{ vente.montantFinal|number_format(2, ',', ' ') }} MAD</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class=\"card mt-4\">
                    <div class=\"card-header\">
                        <h5 class=\"mb-0\">Informations de paiement</h5>
                    </div>
                    <div class=\"card-body\">
                        <div class=\"row mb-3\">
                            <div class=\"col-md-6\">
                                <strong>Statut:</strong>
                                <span class=\"badge badge-{{ vente.statutPaiement == 'paye' ? 'success' : (vente.statutPaiement == 'partiel' ? 'warning' : 'danger') }}\">
                                    {% if vente.statutPaiement == 'paye' %}Payé
                                    {% elseif vente.statutPaiement == 'partiel' %}Partiel
                                    {% else %}Impayé
                                    {% endif %}
                                </span>
                            </div>
                            <div class=\"col-md-6\">
                                <strong>Montant total:</strong>
                                <span class=\"text-primary fw-bold\">{{ vente.montantFinal|number_format(2, ',', ' ') }} MAD</span>
                            </div>
                        </div>
                        <div class=\"row mb-3\">
                            <div class=\"col-md-6\">
                                <strong>Montant payé:</strong>
                                <span class=\"text-success fw-bold\">{{ vente.montantPaye|number_format(2, ',', ' ') }} MAD</span>
                            </div>
                            <div class=\"col-md-6\">
                                <strong>Montant restant:</strong>
                                {% if vente.montantRestant > 0 %}
                                <span class=\"text-danger fw-bold\">{{ vente.montantRestant|number_format(2, ',', ' ') }} MAD</span>
                                {% else %}
                                <span class=\"text-success fw-bold\">0,00 MAD</span>
                                {% endif %}
                            </div>
                        </div>
                        
                        {% if vente.paiementsClient|length > 0 %}
                        <div class=\"mt-4\">
                            <h6 class=\"mb-3\">Historique des paiements</h6>
                            <div class=\"table-responsive\">
                                <table class=\"table table-sm\">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Montant</th>
                                            <th>Mode</th>
                                            <th>Référence</th>
                                            <th>Par</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {% for paiement in vente.paiementsClient|sort((a, b) => b.datePaiement <=> a.datePaiement) %}
                                        <tr>
                                            <td>{{ paiement.datePaiement|date('d/m/Y à H:i') }}</td>
                                            <td class=\"fw-bold text-success\">{{ paiement.montant|number_format(2, ',', ' ') }} MAD</td>
                                            <td>
                                                {% if paiement.mode == 'cash' %}Espèces
                                                {% elseif paiement.mode == 'carte' %}Carte
                                                {% elseif paiement.mode == 'virement' %}Virement
                                                {% elseif paiement.mode == 'cheque' %}Chèque
                                                {% else %}{{ paiement.mode }}
                                                {% endif %}
                                            </td>
                                            <td>{{ paiement.reference ?? '-' }}</td>
                                            <td>{{ paiement.utilisateur.getFullName() }}</td>
                                        </tr>
                                        {% endfor %}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        {% endif %}
                    </div>
                </div>

                <div class=\"d-flex gap-2 mt-4\">
                    <a href=\"{{ path('ventes_index') }}\" class=\"btn btn-outline-secondary btn-modern\">
                        <i class=\"bi bi-arrow-left\"></i> Retour
                    </a>
                    <a href=\"{{ path('ventes_imprimer', {'id': vente.id}) }}\" class=\"btn btn-outline-primary btn-modern\" target=\"_blank\">
                        <i class=\"bi bi-printer\"></i> Imprimer
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
{% endblock %}
", "vente/show.html.twig", "/var/www/html/templates/vente/show.html.twig");
    }
}
