<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* produit/new.html.twig */
class __TwigTemplate_20baa1c98683a75807d5ed89b5f7c8d1 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'page_title' => [$this, 'block_page_title'],
            'content' => [$this, 'block_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/new.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "produit/new.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Nouveau produit - Stock Manager";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 4
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_page_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "page_title"));

        yield "Nouveau produit";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 6
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "content"));

        // line 7
        yield "<style>
    .form-container {
        max-width: 900px;
        margin: 0 auto;
        padding: 2rem 0;
    }
    
    .form-card {
        background: white;
        border-radius: 1rem;
        padding: 2rem;
        border: 1px solid var(--border);
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .form-header {
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .form-header h2 {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    
    .form-header p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 0.9375rem;
    }
    
    .form-section {
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 1px solid var(--border);
    }
    
    .form-section:last-child {
        border-bottom: none;
    }
    
    .form-section-title {
        font-size: 1.125rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .form-section-title i {
        color: var(--primary);
    }
    
    .form-group {
        margin-bottom: 1.5rem;
    }
    
    .form-label {
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
        font-size: 0.9375rem;
        display: block;
    }
    
    .form-control, .form-select {
        padding: 0.75rem 1rem;
        border: 1px solid var(--border);
        border-radius: 0.5rem;
        font-size: 0.9375rem;
        transition: all 0.2s ease;
        width: 100%;
    }
    
    .form-control:focus, .form-select:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
    }
    
    .caracteristiques-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
        margin-top: 1rem;
    }
    
    .caracteristique-field {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .caracteristique-label {
        font-weight: 500;
        color: var(--text-primary);
        font-size: 0.875rem;
    }
    
    .caracteristique-label .required {
        color: #dc2626;
    }
    
    .form-actions {
        display: flex;
        gap: 1rem;
        margin-top: 2rem;
        padding-top: 1.5rem;
        border-top: 1px solid var(--border);
    }
    
    .btn-submit {
        flex: 1;
        padding: 0.75rem 1.5rem;
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border: none;
        border-radius: 0.5rem;
        font-weight: 600;
        font-size: 0.9375rem;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
    }
    
    .btn-submit:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary) 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(37, 99, 235, 0.3);
    }
    
    .btn-cancel {
        padding: 0.75rem 1.5rem;
        background: var(--bg-secondary);
        color: var(--text-primary);
        border: 1px solid var(--border);
        border-radius: 0.5rem;
        font-weight: 500;
        font-size: 0.9375rem;
        text-decoration: none;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-cancel:hover {
        background: var(--bg-tertiary);
        border-color: var(--primary);
        color: var(--primary);
    }
</style>

<div class=\"form-container\">
    <div class=\"form-card\">
        <div class=\"form-header\">
            <h2>
                <i class=\"bi bi-plus-circle-fill\" style=\"color: var(--primary);\"></i>
                Créer un nouveau produit
            </h2>
            <p>Remplissez les informations ci-dessous</p>
        </div>

        ";
        // line 180
        yield         $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->renderBlock((isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 180, $this->source); })()), 'form_start', ["attr" => ["class" => "modern-form", "id" => "produit-form", "enctype" => "multipart/form-data"]]);
        yield "
        
        <!-- Section 1: Sélection Catégorie / Sous-catégorie -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-tags\"></i>
                <span>1. Sélection de la catégorie</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 191
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 191, $this->source); })()), "categorie", [], "any", false, false, false, 191), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 192
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 192, $this->source); })()), "categorie", [], "any", false, false, false, 192), 'widget', ["attr" => ["class" => "form-select"]]);
        yield "
                        ";
        // line 193
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 193, $this->source); })()), "categorie", [], "any", false, false, false, 193), 'errors');
        yield "
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 198
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 198, $this->source); })()), "sousCategorie", [], "any", false, false, false, 198), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 199
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 199, $this->source); })()), "sousCategorie", [], "any", false, false, false, 199), 'widget', ["attr" => ["class" => "form-select"]]);
        yield "
                        ";
        // line 200
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 200, $this->source); })()), "sousCategorie", [], "any", false, false, false, 200), 'errors');
        yield "
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 2: Caractéristiques dynamiques -->
        <div class=\"form-section\" id=\"caracteristiques-section\" style=\"display: none;\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-list-check\"></i>
                <span>2. Caractéristiques du produit</span>
            </div>
            <div class=\"caracteristiques-container\" id=\"caracteristiques-container\">
                <!-- Les caractéristiques seront ajoutées dynamiquement ici -->
            </div>
        </div>

        <!-- Section 3: Informations principales -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-info-circle\"></i>
                <span>3. Informations principales</span>
            </div>
                <div class=\"row\">
                    <div class=\"col-md-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\">
                                Nom du produit 
                                <span class=\"text-muted\">(généré automatiquement)</span>
                            </label>
                            <input type=\"text\" 
                                   id=\"produit-nom-preview\" 
                                   class=\"form-control\" 
                                   readonly 
                                   placeholder=\"Le nom sera généré automatiquement à partir de la sous-catégorie et des caractéristiques\"
                                   style=\"background-color: var(--bg-secondary);\">
                            <small class=\"form-text text-muted\">
                                <i class=\"bi bi-info-circle\"></i> 
                                Le nom sera automatiquement créé à partir de la sous-catégorie et des caractéristiques sélectionnées.
                            </small>
                            ";
        // line 240
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 240, $this->source); })()), "nom", [], "any", false, false, false, 240), 'widget', ["attr" => ["style" => "display: none;"]]);
        yield "
                            ";
        // line 241
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 241, $this->source); })()), "nom", [], "any", false, false, false, 241), 'errors');
        yield "
                        </div>
                    </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 246
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 246, $this->source); })()), "referenceInterne", [], "any", false, false, false, 246), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 247
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 247, $this->source); })()), "referenceInterne", [], "any", false, false, false, 247), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 248
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 248, $this->source); })()), "referenceInterne", [], "any", false, false, false, 248), 'errors');
        yield "
                        <small class=\"form-text text-muted\">Générée automatiquement à partir du code-barres</small>
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        <label class=\"form-label\">Code-barres</label>
                        <div class=\"d-flex align-items-center gap-3\">
                            <input type=\"text\" class=\"form-control\" value=\"";
        // line 256
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["produit"]) || array_key_exists("produit", $context) ? $context["produit"] : (function () { throw new RuntimeError('Variable "produit" does not exist.', 256, $this->source); })()), "codeBarres", [], "any", false, false, false, 256), "html", null, true);
        yield "\" readonly id=\"code-barres-display\">
                            <div id=\"barcode-preview\" style=\"display: none;\">
                                <svg id=\"barcode-svg\"></svg>
                            </div>
                        </div>
                        <small class=\"form-text text-muted\">Code-barres unique pour le suivi et la vente</small>
                    </div>
                </div>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 268
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 268, $this->source); })()), "imei", [], "any", false, false, false, 268), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 269
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 269, $this->source); })()), "imei", [], "any", false, false, false, 269), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 270
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 270, $this->source); })()), "imei", [], "any", false, false, false, 270), 'errors');
        yield "
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 275
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 275, $this->source); })()), "numeroSerie", [], "any", false, false, false, 275), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 276
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 276, $this->source); })()), "numeroSerie", [], "any", false, false, false, 276), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 277
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 277, $this->source); })()), "numeroSerie", [], "any", false, false, false, 277), 'errors');
        yield "
                    </div>
                </div>
            </div>
            <div class=\"form-group\">
                ";
        // line 282
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 282, $this->source); })()), "description", [], "any", false, false, false, 282), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                ";
        // line 283
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 283, $this->source); })()), "description", [], "any", false, false, false, 283), 'widget', ["attr" => ["class" => "form-control", "rows" => 4]]);
        yield "
                ";
        // line 284
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 284, $this->source); })()), "description", [], "any", false, false, false, 284), 'errors');
        yield "
            </div>
        </div>

        <!-- Section 4: Gestion financière -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-cash-coin\"></i>
                <span>4. Prix & marge</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        ";
        // line 297
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 297, $this->source); })()), "prixAchat", [], "any", false, false, false, 297), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 298
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 298, $this->source); })()), "prixAchat", [], "any", false, false, false, 298), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 299
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 299, $this->source); })()), "prixAchat", [], "any", false, false, false, 299), 'errors');
        yield "
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        ";
        // line 304
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 304, $this->source); })()), "margeMinimale", [], "any", false, false, false, 304), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 305
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 305, $this->source); })()), "margeMinimale", [], "any", false, false, false, 305), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 306
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 306, $this->source); })()), "margeMinimale", [], "any", false, false, false, 306), 'errors');
        yield "
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        ";
        // line 311
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 311, $this->source); })()), "prixVenteRecommande", [], "any", false, false, false, 311), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 312
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 312, $this->source); })()), "prixVenteRecommande", [], "any", false, false, false, 312), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 313
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 313, $this->source); })()), "prixVenteRecommande", [], "any", false, false, false, 313), 'errors');
        yield "
                    </div>
                </div>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 320
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 320, $this->source); })()), "prixVente", [], "any", false, false, false, 320), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 321
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 321, $this->source); })()), "prixVente", [], "any", false, false, false, 321), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 322
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 322, $this->source); })()), "prixVente", [], "any", false, false, false, 322), 'errors');
        yield "
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 327
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 327, $this->source); })()), "dateAchat", [], "any", false, false, false, 327), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 328
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 328, $this->source); })()), "dateAchat", [], "any", false, false, false, 328), 'widget', ["attr" => ["class" => "form-control"]]);
        yield "
                        ";
        // line 329
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 329, $this->source); })()), "dateAchat", [], "any", false, false, false, 329), 'errors');
        yield "
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 5: Origine d'achat -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-truck\"></i>
                <span>5. Origine d'achat</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 344
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 344, $this->source); })()), "origineAchat", [], "any", false, false, false, 344), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 345
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 345, $this->source); })()), "origineAchat", [], "any", false, false, false, 345), 'widget', ["attr" => ["class" => "form-select"]]);
        yield "
                        ";
        // line 346
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 346, $this->source); })()), "origineAchat", [], "any", false, false, false, 346), 'errors');
        yield "
                    </div>
                </div>
                ";
        // line 349
        if (CoreExtension::getAttribute($this->env, $this->source, ($context["form"] ?? null), "fournisseur", [], "any", true, true, false, 349)) {
            // line 350
            yield "                <div class=\"col-md-6\" id=\"fournisseur-field\">
                    <div class=\"form-group\">
                        ";
            // line 352
            yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 352, $this->source); })()), "fournisseur", [], "any", false, false, false, 352), 'label', ["label_attr" => ["class" => "form-label"]]);
            yield "
                        ";
            // line 353
            yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 353, $this->source); })()), "fournisseur", [], "any", false, false, false, 353), 'widget', ["attr" => ["class" => "form-select"]]);
            yield "
                        ";
            // line 354
            yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 354, $this->source); })()), "fournisseur", [], "any", false, false, false, 354), 'errors');
            yield "
                    </div>
                </div>
                ";
        }
        // line 358
        yield "            </div>
            <div id=\"fournisseur-paiement-fields\" style=\"display: none;\">
                <div class=\"alert alert-info\">
                    <i class=\"bi bi-info-circle\"></i> 
                    Vous pouvez créer un achat et enregistrer un paiement pour ce fournisseur lors de la création du produit.
                </div>
                <div class=\"row\">
                    <div class=\"col-12 mb-3\">
                        <div class=\"form-check\">
                            <input class=\"form-check-input\" type=\"checkbox\" id=\"creer_achat\" name=\"creer_achat\" value=\"1\">
                            <label class=\"form-check-label\" for=\"creer_achat\">
                                Créer un achat pour ce produit
                            </label>
                        </div>
                    </div>
                </div>
                <div id=\"paiement-fields\" style=\"display: none;\">
                    <div class=\"row\">
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"montant_paiement\">Montant à payer (optionnel)</label>
                                <input type=\"number\" id=\"montant_paiement\" name=\"montant_paiement\" class=\"form-control\" step=\"0.01\" min=\"0\">
                                <small class=\"form-text text-muted\">Laissez vide si vous ne payez pas maintenant</small>
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"mode_paiement\">Mode de paiement</label>
                                <select id=\"mode_paiement\" name=\"mode_paiement\" class=\"form-select\">
                                    <option value=\"especes\">Espèces</option>
                                    <option value=\"virement\">Virement</option>
                                    <option value=\"carte\">Carte</option>
                                    <option value=\"cheque\">Chèque</option>
                                    <option value=\"autre\">Autre</option>
                                </select>
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"reference_paiement\">Référence (optionnel)</label>
                                <input type=\"text\" id=\"reference_paiement\" name=\"reference_paiement\" class=\"form-control\">
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"notes_paiement\">Notes (optionnel)</label>
                                <input type=\"text\" id=\"notes_paiement\" name=\"notes_paiement\" class=\"form-control\">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id=\"particulier-fields\" style=\"display: none;\">
                <div class=\"row\">
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"nom_client\">Nom du client particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"text\" id=\"nom_client\" name=\"nom_client\" class=\"form-control\" required>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"telephone_client\">Téléphone du client particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"text\" id=\"telephone_client\" name=\"telephone_client\" class=\"form-control\" required>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"cin_client\">CIN du client particulier (optionnel)</label>
                            <input type=\"text\" id=\"cin_client\" name=\"cin_client\" class=\"form-control\">
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"prix_paye_particulier\">Prix payé au particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"number\" id=\"prix_paye_particulier\" name=\"prix_paye_particulier\" class=\"form-control\" step=\"0.01\" min=\"0\" required>
                        </div>
                    </div>
                    <div class=\"col-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"adresse_client\">Adresse du client particulier (optionnel)</label>
                            <textarea id=\"adresse_client\" name=\"adresse_client\" class=\"form-control\" rows=\"2\"></textarea>
                        </div>
                    </div>
                    <div class=\"col-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"photo_cin\">Photo de la CIN (optionnel)</label>
                            <input type=\"file\" id=\"photo_cin\" name=\"photo_cin\" class=\"form-control\" accept=\"image/*\">
                            <small class=\"form-text text-muted\">Formats acceptés: JPG, PNG, PDF (max 5MB)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 6: Statut -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-check-circle\"></i>
                <span>6. Statut</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        ";
        // line 462
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 462, $this->source); })()), "statut", [], "any", false, false, false, 462), 'label', ["label_attr" => ["class" => "form-label"]]);
        yield "
                        ";
        // line 463
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 463, $this->source); })()), "statut", [], "any", false, false, false, 463), 'widget', ["attr" => ["class" => "form-select"]]);
        yield "
                        ";
        // line 464
        yield $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->searchAndRenderBlock(CoreExtension::getAttribute($this->env, $this->source, (isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 464, $this->source); })()), "statut", [], "any", false, false, false, 464), 'errors');
        yield "
                    </div>
                </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"quantite\">Quantité à créer <span class=\"text-muted\">(nombre de produits distincts)</span></label>
                            <input type=\"number\" 
                                   id=\"quantite\" 
                                   name=\"quantite\" 
                                   class=\"form-control\" 
                                   min=\"1\" 
                                   value=\"1\" 
                                   required>
                            <small class=\"form-text text-muted\">
                                <i class=\"bi bi-info-circle\"></i> 
                                Si vous mettez \"2\", le système créera 2 produits distincts avec des codes-barres différents.
                            </small>
                        </div>
                    </div>
            </div>
        </div>

        <!-- Champ caché pour stocker les valeurs des caractéristiques -->
        <input type=\"hidden\" name=\"caracteristiques_valeurs\" id=\"caracteristiques_valeurs\" value=\"{}\">

        <div class=\"form-actions\">
            <button type=\"submit\" class=\"btn-submit\">
                <i class=\"bi bi-check-circle-fill\"></i>
                <span>Créer le produit</span>
            </button>
            <a href=\"";
        // line 494
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("produits_index");
        yield "\" class=\"btn-cancel\">
                <span>Annuler</span>
            </a>
        </div>
        ";
        // line 498
        yield         $this->env->getRuntime('Symfony\Component\Form\FormRenderer')->renderBlock((isset($context["form"]) || array_key_exists("form", $context) ? $context["form"] : (function () { throw new RuntimeError('Variable "form" does not exist.', 498, $this->source); })()), 'form_end');
        yield "
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const categorieSelect = document.querySelector('[data-produit-categorie]');
    const sousCategorieSelect = document.querySelector('[data-produit-sous-categorie]');
    const caracteristiquesContainer = document.getElementById('caracteristiques-container');
    const caracteristiquesSection = document.getElementById('caracteristiques-section');
    const caracteristiquesValeursInput = document.getElementById('caracteristiques_valeurs');
    const prixAchatInput = document.querySelector('[data-prix-achat]');
    const margeMinimaleInput = document.querySelector('[data-marge-minimale]');
    const prixVenteRecommandéInput = document.querySelector('[data-prix-vente-recommande]');
    const origineAchatSelect = document.querySelector('[data-origine-achat]');
    const fournisseurField = document.getElementById('fournisseur-field');
    const particulierFields = document.getElementById('particulier-fields');

    let caracteristiquesValeurs = {};

    // Charger les sous-catégories quand la catégorie change
    if (categorieSelect) {
        categorieSelect.addEventListener('change', function() {
            const categorieId = this.value;
            if (categorieId) {
                sousCategorieSelect.innerHTML = '<option value=\"\">Chargement...</option>';
                sousCategorieSelect.disabled = true;
                
                const url = `/produits/api/sous-categories/\${categorieId}`;
                fetch(url, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin'
                })
                    .then(async response => {
                        const contentType = response.headers.get('content-type');
                        if (!contentType || !contentType.includes('application/json')) {
                            const text = await response.text();
                            console.error('Réponse non-JSON reçue:', text.substring(0, 200));
                            throw new Error('Le serveur a retourné une réponse invalide. Vérifiez que vous êtes bien connecté.');
                        }
                        
                        if (!response.ok) {
                            const err = await response.json();
                            throw new Error(err.error || 'Erreur lors du chargement');
                        }
                        return response.json();
                    })
                    .then(data => {
                        sousCategorieSelect.innerHTML = '<option value=\"\">Sélectionnez une sous-catégorie</option>';
                        if (Array.isArray(data) && data.length > 0) {
                            data.forEach(sousCategorie => {
                                const option = document.createElement('option');
                                option.value = sousCategorie.id;
                                option.textContent = sousCategorie.nom;
                                sousCategorieSelect.appendChild(option);
                            });
                        } else {
                            sousCategorieSelect.innerHTML = '<option value=\"\">Aucune sous-catégorie disponible</option>';
                        }
                        sousCategorieSelect.disabled = false;
                        caracteristiquesContainer.innerHTML = '';
                        caracteristiquesSection.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        sousCategorieSelect.innerHTML = '<option value=\"\">Erreur: ' + error.message + '</option>';
                        sousCategorieSelect.disabled = false;
                    });
            } else {
                sousCategorieSelect.innerHTML = '<option value=\"\">Sélectionnez d\\'abord une catégorie</option>';
                sousCategorieSelect.disabled = true;
                caracteristiquesContainer.innerHTML = '';
                caracteristiquesSection.style.display = 'none';
            }
        });
    }

    // Charger les caractéristiques quand la sous-catégorie change
    if (sousCategorieSelect) {
        sousCategorieSelect.addEventListener('change', function() {
            const sousCategorieId = this.value;
            if (sousCategorieId) {
                caracteristiquesContainer.innerHTML = '<div style=\"text-align: center; padding: 2rem; color: var(--text-secondary);\">Chargement des caractéristiques...</div>';
                caracteristiquesSection.style.display = 'block';
                
                const url = `/produits/api/caracteristiques/\${sousCategorieId}`;
                fetch(url, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin'
                })
                    .then(async response => {
                        const contentType = response.headers.get('content-type');
                        if (!contentType || !contentType.includes('application/json')) {
                            const text = await response.text();
                            console.error('Réponse non-JSON reçue:', text.substring(0, 200));
                            throw new Error('Le serveur a retourné une réponse invalide. Vérifiez que vous êtes bien connecté.');
                        }
                        
                        if (!response.ok) {
                            const err = await response.json();
                            throw new Error(err.error || 'Erreur lors du chargement');
                        }
                        return response.json();
                    })
                    .then(data => {
                        caracteristiquesContainer.innerHTML = '';
                        caracteristiquesValeurs = {};
                        
                        if (data.length > 0) {
                            caracteristiquesSection.style.display = 'block';
                            data.forEach(caracteristique => {
                                const fieldDiv = document.createElement('div');
                                fieldDiv.className = 'caracteristique-field';
                                
                                const label = document.createElement('label');
                                label.className = 'caracteristique-label';
                                label.textContent = caracteristique.nom;
                                if (caracteristique.obligatoire) {
                                    label.innerHTML += ' <span class=\"required\">*</span>';
                                }
                                
                                fieldDiv.appendChild(label);
                                
                                let input;
                                if (caracteristique.type === 'text') {
                                    input = document.createElement('input');
                                    input.type = 'text';
                                    input.className = 'form-control';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('input', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'number') {
                                    input = document.createElement('input');
                                    input.type = 'number';
                                    input.className = 'form-control';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.step = 'any';
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('input', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'boolean') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.innerHTML = '<option value=\"\">--</option><option value=\"true\">Oui</option><option value=\"false\">Non</option>';
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'select') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.innerHTML = '<option value=\"\">--</option>';
                                    caracteristique.valeursPossibles.forEach(valeur => {
                                        const option = document.createElement('option');
                                        option.value = valeur;
                                        option.textContent = valeur;
                                        input.appendChild(option);
                                    });
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'multi-select') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}[]`;
                                    input.multiple = true;
                                    input.innerHTML = '';
                                    caracteristique.valeursPossibles.forEach(valeur => {
                                        const option = document.createElement('option');
                                        option.value = valeur;
                                        option.textContent = valeur;
                                        input.appendChild(option);
                                    });
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                }
                                
                                input.addEventListener('change', function() {
                                    if (caracteristique.type === 'multi-select') {
                                        caracteristiquesValeurs[caracteristique.id] = Array.from(this.selectedOptions).map(opt => opt.value);
                                    } else {
                                        caracteristiquesValeurs[caracteristique.id] = this.value;
                                    }
                                    caracteristiquesValeursInput.value = JSON.stringify(caracteristiquesValeurs);
                                    mettreAJourNomProduit();
                                });
                                
                                fieldDiv.appendChild(input);
                                caracteristiquesContainer.appendChild(fieldDiv);
                            });
                            
                            // Mettre à jour le nom après chargement des caractéristiques
                            mettreAJourNomProduit();
                        } else {
                            caracteristiquesSection.style.display = 'none';
                            mettreAJourNomProduit();
                        }
                    });
            } else {
                caracteristiquesContainer.innerHTML = '';
                caracteristiquesSection.style.display = 'none';
            }
        });
    }

    // Calculer le prix de vente recommandé
    function calculerPrixVenteRecommandé() {
        const prixAchat = parseFloat(prixAchatInput?.value.replace(/[^\\d,.-]/g, '').replace(',', '.') || 0);
        const margeMinimale = parseFloat(margeMinimaleInput?.value.replace(/[^\\d,.-]/g, '').replace(',', '.') || 0);
        
        if (prixAchat > 0 && margeMinimale >= 0) {
            const prixRecommandé = prixAchat + margeMinimale;
            if (prixVenteRecommandéInput) {
                prixVenteRecommandéInput.value = prixRecommandé.toFixed(2).replace('.', ',') + ' MAD';
            }
        }
    }

    if (prixAchatInput) {
        prixAchatInput.addEventListener('input', calculerPrixVenteRecommandé);
    }
    if (margeMinimaleInput) {
        margeMinimaleInput.addEventListener('input', calculerPrixVenteRecommandé);
    }

    // Gérer l'affichage des champs selon l'origine d'achat
    const fournisseurPaiementFields = document.getElementById('fournisseur-paiement-fields');
    const creerAchatCheckbox = document.getElementById('creer_achat');
    const paiementFields = document.getElementById('paiement-fields');
    
    if (origineAchatSelect) {
        // Initialiser l'affichage au chargement de la page
        function toggleOrigineAchatFields() {
            const origineAchat = origineAchatSelect.value;
            if (origineAchat === 'particulier') {
                if (fournisseurField) fournisseurField.style.display = 'none';
                if (fournisseurPaiementFields) fournisseurPaiementFields.style.display = 'none';
                if (particulierFields) {
                    particulierFields.style.display = 'block';
                    // Rendre les champs obligatoires visibles
                    particulierFields.querySelectorAll('input[required], textarea[required]').forEach(field => {
                        field.required = true;
                    });
                }
            } else {
                if (fournisseurField) fournisseurField.style.display = 'block';
                if (fournisseurPaiementFields) fournisseurPaiementFields.style.display = 'block';
                if (particulierFields) {
                    particulierFields.style.display = 'none';
                    // Désactiver les champs obligatoires quand cachés
                    particulierFields.querySelectorAll('input[required], textarea[required]').forEach(field => {
                        field.required = false;
                    });
                }
            }
        }
        
        // Appliquer au chargement
        toggleOrigineAchatFields();
        
        // Écouter les changements
        origineAchatSelect.addEventListener('change', toggleOrigineAchatFields);
    }
    
    // Gérer l'affichage des champs de paiement
    if (creerAchatCheckbox) {
        creerAchatCheckbox.addEventListener('change', function() {
            if (paiementFields) {
                paiementFields.style.display = this.checked ? 'block' : 'none';
            }
        });
    }

    // Fonction pour mettre à jour le nom du produit en temps réel
    function mettreAJourNomProduit() {
        const sousCategorieSelect = document.querySelector('[data-produit-sous-categorie]');
        const nomPreview = document.getElementById('produit-nom-preview');
        const nomHidden = document.querySelector('[name=\"produit[nom]\"]');
        
        if (!sousCategorieSelect || !sousCategorieSelect.value) {
            if (nomPreview) nomPreview.value = '';
            if (nomHidden) nomHidden.value = '';
            return;
        }
        
        const sousCategorieNom = sousCategorieSelect.options[sousCategorieSelect.selectedIndex].text;
        let nom = sousCategorieNom;
        
        // Récupérer les valeurs des caractéristiques
        const valeurs = [];
        caracteristiquesContainer.querySelectorAll('[name^=\"caracteristique_\"]').forEach(input => {
            if (input.type === 'checkbox') {
                if (input.checked) {
                    valeurs.push(input.value);
                }
            } else if (input.tagName === 'SELECT') {
                if (input.multiple) {
                    // Multi-select
                    Array.from(input.selectedOptions).forEach(opt => {
                        if (opt.value) valeurs.push(opt.textContent);
                    });
                } else {
                    // Select simple
                    if (input.value && input.value !== '' && input.value !== 'true' && input.value !== 'false') {
                        valeurs.push(input.options[input.selectedIndex].textContent);
                    }
                }
            } else {
                // Input text, number, etc.
                if (input.value && input.value.trim() !== '' && input.value !== 'true' && input.value !== 'false') {
                    valeurs.push(input.value);
                }
            }
        });
        
        if (valeurs.length > 0) {
            nom += ' - ' + valeurs.slice(0, 5).join(' / '); // Limiter à 5 valeurs
        }
        
        if (nomPreview) nomPreview.value = nom;
        if (nomHidden) nomHidden.value = nom;
    }
    
    // Écouter les changements de sous-catégorie
    if (sousCategorieSelect) {
        sousCategorieSelect.addEventListener('change', mettreAJourNomProduit);
    }

    // Collecter les valeurs des caractéristiques avant soumission
    const form = document.getElementById('produit-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const caracteristiques = {};
            caracteristiquesContainer.querySelectorAll('[name^=\"caracteristique_\"]').forEach(input => {
                const caracteristiqueId = input.name.match(/caracteristique_(\\d+)/)?.[1];
                if (caracteristiqueId) {
                    if (input.type === 'checkbox') {
                        if (!caracteristiques[caracteristiqueId]) {
                            caracteristiques[caracteristiqueId] = [];
                        }
                        if (input.checked) {
                            caracteristiques[caracteristiqueId].push(input.value);
                        }
                    } else if (input.tagName === 'SELECT' && input.multiple) {
                        caracteristiques[caracteristiqueId] = Array.from(input.selectedOptions).map(opt => opt.value);
                    } else {
                        if (input.value && input.value !== '' && input.value !== 'true' && input.value !== 'false') {
                            caracteristiques[caracteristiqueId] = input.value;
                        }
                    }
                }
            });
            caracteristiquesValeursInput.value = JSON.stringify(caracteristiques);
            
            // S'assurer que le nom est bien défini
            mettreAJourNomProduit();
        });
    }

    // Générer le code-barres visuel
    const codeBarresDisplay = document.getElementById('code-barres-display');
    const barcodePreview = document.getElementById('barcode-preview');
    const barcodeSvg = document.getElementById('barcode-svg');
    
    if (codeBarresDisplay && codeBarresDisplay.value && barcodeSvg && typeof JsBarcode !== 'undefined') {
        try {
            JsBarcode(barcodeSvg, codeBarresDisplay.value, {
                format: \"EAN13\",
                width: 2,
                height: 60,
                displayValue: true,
                fontSize: 14,
                margin: 10
            });
            if (barcodePreview) {
                barcodePreview.style.display = 'block';
            }
        } catch (e) {
            console.error('Erreur génération code-barres:', e);
        }
    }
});
</script>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "produit/new.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  763 => 498,  756 => 494,  723 => 464,  719 => 463,  715 => 462,  609 => 358,  602 => 354,  598 => 353,  594 => 352,  590 => 350,  588 => 349,  582 => 346,  578 => 345,  574 => 344,  556 => 329,  552 => 328,  548 => 327,  540 => 322,  536 => 321,  532 => 320,  522 => 313,  518 => 312,  514 => 311,  506 => 306,  502 => 305,  498 => 304,  490 => 299,  486 => 298,  482 => 297,  466 => 284,  462 => 283,  458 => 282,  450 => 277,  446 => 276,  442 => 275,  434 => 270,  430 => 269,  426 => 268,  411 => 256,  400 => 248,  396 => 247,  392 => 246,  384 => 241,  380 => 240,  337 => 200,  333 => 199,  329 => 198,  321 => 193,  317 => 192,  313 => 191,  299 => 180,  124 => 7,  111 => 6,  88 => 4,  65 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Nouveau produit - Stock Manager{% endblock %}
{% block page_title %}Nouveau produit{% endblock %}

{% block content %}
<style>
    .form-container {
        max-width: 900px;
        margin: 0 auto;
        padding: 2rem 0;
    }
    
    .form-card {
        background: white;
        border-radius: 1rem;
        padding: 2rem;
        border: 1px solid var(--border);
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    }
    
    .form-header {
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 2px solid var(--border);
    }
    
    .form-header h2 {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    
    .form-header p {
        color: var(--text-secondary);
        margin: 0;
        font-size: 0.9375rem;
    }
    
    .form-section {
        margin-bottom: 2rem;
        padding-bottom: 1.5rem;
        border-bottom: 1px solid var(--border);
    }
    
    .form-section:last-child {
        border-bottom: none;
    }
    
    .form-section-title {
        font-size: 1.125rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .form-section-title i {
        color: var(--primary);
    }
    
    .form-group {
        margin-bottom: 1.5rem;
    }
    
    .form-label {
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 0.5rem;
        font-size: 0.9375rem;
        display: block;
    }
    
    .form-control, .form-select {
        padding: 0.75rem 1rem;
        border: 1px solid var(--border);
        border-radius: 0.5rem;
        font-size: 0.9375rem;
        transition: all 0.2s ease;
        width: 100%;
    }
    
    .form-control:focus, .form-select:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
    }
    
    .caracteristiques-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
        margin-top: 1rem;
    }
    
    .caracteristique-field {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .caracteristique-label {
        font-weight: 500;
        color: var(--text-primary);
        font-size: 0.875rem;
    }
    
    .caracteristique-label .required {
        color: #dc2626;
    }
    
    .form-actions {
        display: flex;
        gap: 1rem;
        margin-top: 2rem;
        padding-top: 1.5rem;
        border-top: 1px solid var(--border);
    }
    
    .btn-submit {
        flex: 1;
        padding: 0.75rem 1.5rem;
        background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 100%);
        color: white;
        border: none;
        border-radius: 0.5rem;
        font-weight: 600;
        font-size: 0.9375rem;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
    }
    
    .btn-submit:hover {
        background: linear-gradient(135deg, var(--primary-hover) 0%, var(--primary) 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(37, 99, 235, 0.3);
    }
    
    .btn-cancel {
        padding: 0.75rem 1.5rem;
        background: var(--bg-secondary);
        color: var(--text-primary);
        border: 1px solid var(--border);
        border-radius: 0.5rem;
        font-weight: 500;
        font-size: 0.9375rem;
        text-decoration: none;
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-cancel:hover {
        background: var(--bg-tertiary);
        border-color: var(--primary);
        color: var(--primary);
    }
</style>

<div class=\"form-container\">
    <div class=\"form-card\">
        <div class=\"form-header\">
            <h2>
                <i class=\"bi bi-plus-circle-fill\" style=\"color: var(--primary);\"></i>
                Créer un nouveau produit
            </h2>
            <p>Remplissez les informations ci-dessous</p>
        </div>

        {{ form_start(form, {'attr': {'class': 'modern-form', 'id': 'produit-form', 'enctype': 'multipart/form-data'}}) }}
        
        <!-- Section 1: Sélection Catégorie / Sous-catégorie -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-tags\"></i>
                <span>1. Sélection de la catégorie</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.categorie, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.categorie, {'attr': {'class': 'form-select'}}) }}
                        {{ form_errors(form.categorie) }}
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.sousCategorie, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.sousCategorie, {'attr': {'class': 'form-select'}}) }}
                        {{ form_errors(form.sousCategorie) }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 2: Caractéristiques dynamiques -->
        <div class=\"form-section\" id=\"caracteristiques-section\" style=\"display: none;\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-list-check\"></i>
                <span>2. Caractéristiques du produit</span>
            </div>
            <div class=\"caracteristiques-container\" id=\"caracteristiques-container\">
                <!-- Les caractéristiques seront ajoutées dynamiquement ici -->
            </div>
        </div>

        <!-- Section 3: Informations principales -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-info-circle\"></i>
                <span>3. Informations principales</span>
            </div>
                <div class=\"row\">
                    <div class=\"col-md-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\">
                                Nom du produit 
                                <span class=\"text-muted\">(généré automatiquement)</span>
                            </label>
                            <input type=\"text\" 
                                   id=\"produit-nom-preview\" 
                                   class=\"form-control\" 
                                   readonly 
                                   placeholder=\"Le nom sera généré automatiquement à partir de la sous-catégorie et des caractéristiques\"
                                   style=\"background-color: var(--bg-secondary);\">
                            <small class=\"form-text text-muted\">
                                <i class=\"bi bi-info-circle\"></i> 
                                Le nom sera automatiquement créé à partir de la sous-catégorie et des caractéristiques sélectionnées.
                            </small>
                            {{ form_widget(form.nom, {'attr': {'style': 'display: none;'}}) }}
                            {{ form_errors(form.nom) }}
                        </div>
                    </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.referenceInterne, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.referenceInterne, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.referenceInterne) }}
                        <small class=\"form-text text-muted\">Générée automatiquement à partir du code-barres</small>
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        <label class=\"form-label\">Code-barres</label>
                        <div class=\"d-flex align-items-center gap-3\">
                            <input type=\"text\" class=\"form-control\" value=\"{{ produit.codeBarres }}\" readonly id=\"code-barres-display\">
                            <div id=\"barcode-preview\" style=\"display: none;\">
                                <svg id=\"barcode-svg\"></svg>
                            </div>
                        </div>
                        <small class=\"form-text text-muted\">Code-barres unique pour le suivi et la vente</small>
                    </div>
                </div>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.imei, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.imei, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.imei) }}
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.numeroSerie, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.numeroSerie, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.numeroSerie) }}
                    </div>
                </div>
            </div>
            <div class=\"form-group\">
                {{ form_label(form.description, null, {'label_attr': {'class': 'form-label'}}) }}
                {{ form_widget(form.description, {'attr': {'class': 'form-control', 'rows': 4}}) }}
                {{ form_errors(form.description) }}
            </div>
        </div>

        <!-- Section 4: Gestion financière -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-cash-coin\"></i>
                <span>4. Prix & marge</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        {{ form_label(form.prixAchat, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.prixAchat, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.prixAchat) }}
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        {{ form_label(form.margeMinimale, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.margeMinimale, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.margeMinimale) }}
                    </div>
                </div>
                <div class=\"col-md-4\">
                    <div class=\"form-group\">
                        {{ form_label(form.prixVenteRecommande, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.prixVenteRecommande, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.prixVenteRecommande) }}
                    </div>
                </div>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.prixVente, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.prixVente, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.prixVente) }}
                    </div>
                </div>
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.dateAchat, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.dateAchat, {'attr': {'class': 'form-control'}}) }}
                        {{ form_errors(form.dateAchat) }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 5: Origine d'achat -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-truck\"></i>
                <span>5. Origine d'achat</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.origineAchat, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.origineAchat, {'attr': {'class': 'form-select'}}) }}
                        {{ form_errors(form.origineAchat) }}
                    </div>
                </div>
                {% if form.fournisseur is defined %}
                <div class=\"col-md-6\" id=\"fournisseur-field\">
                    <div class=\"form-group\">
                        {{ form_label(form.fournisseur, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.fournisseur, {'attr': {'class': 'form-select'}}) }}
                        {{ form_errors(form.fournisseur) }}
                    </div>
                </div>
                {% endif %}
            </div>
            <div id=\"fournisseur-paiement-fields\" style=\"display: none;\">
                <div class=\"alert alert-info\">
                    <i class=\"bi bi-info-circle\"></i> 
                    Vous pouvez créer un achat et enregistrer un paiement pour ce fournisseur lors de la création du produit.
                </div>
                <div class=\"row\">
                    <div class=\"col-12 mb-3\">
                        <div class=\"form-check\">
                            <input class=\"form-check-input\" type=\"checkbox\" id=\"creer_achat\" name=\"creer_achat\" value=\"1\">
                            <label class=\"form-check-label\" for=\"creer_achat\">
                                Créer un achat pour ce produit
                            </label>
                        </div>
                    </div>
                </div>
                <div id=\"paiement-fields\" style=\"display: none;\">
                    <div class=\"row\">
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"montant_paiement\">Montant à payer (optionnel)</label>
                                <input type=\"number\" id=\"montant_paiement\" name=\"montant_paiement\" class=\"form-control\" step=\"0.01\" min=\"0\">
                                <small class=\"form-text text-muted\">Laissez vide si vous ne payez pas maintenant</small>
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"mode_paiement\">Mode de paiement</label>
                                <select id=\"mode_paiement\" name=\"mode_paiement\" class=\"form-select\">
                                    <option value=\"especes\">Espèces</option>
                                    <option value=\"virement\">Virement</option>
                                    <option value=\"carte\">Carte</option>
                                    <option value=\"cheque\">Chèque</option>
                                    <option value=\"autre\">Autre</option>
                                </select>
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"reference_paiement\">Référence (optionnel)</label>
                                <input type=\"text\" id=\"reference_paiement\" name=\"reference_paiement\" class=\"form-control\">
                            </div>
                        </div>
                        <div class=\"col-md-6\">
                            <div class=\"form-group\">
                                <label class=\"form-label\" for=\"notes_paiement\">Notes (optionnel)</label>
                                <input type=\"text\" id=\"notes_paiement\" name=\"notes_paiement\" class=\"form-control\">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id=\"particulier-fields\" style=\"display: none;\">
                <div class=\"row\">
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"nom_client\">Nom du client particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"text\" id=\"nom_client\" name=\"nom_client\" class=\"form-control\" required>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"telephone_client\">Téléphone du client particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"text\" id=\"telephone_client\" name=\"telephone_client\" class=\"form-control\" required>
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"cin_client\">CIN du client particulier (optionnel)</label>
                            <input type=\"text\" id=\"cin_client\" name=\"cin_client\" class=\"form-control\">
                        </div>
                    </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"prix_paye_particulier\">Prix payé au particulier <span class=\"text-danger\">*</span></label>
                            <input type=\"number\" id=\"prix_paye_particulier\" name=\"prix_paye_particulier\" class=\"form-control\" step=\"0.01\" min=\"0\" required>
                        </div>
                    </div>
                    <div class=\"col-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"adresse_client\">Adresse du client particulier (optionnel)</label>
                            <textarea id=\"adresse_client\" name=\"adresse_client\" class=\"form-control\" rows=\"2\"></textarea>
                        </div>
                    </div>
                    <div class=\"col-12\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"photo_cin\">Photo de la CIN (optionnel)</label>
                            <input type=\"file\" id=\"photo_cin\" name=\"photo_cin\" class=\"form-control\" accept=\"image/*\">
                            <small class=\"form-text text-muted\">Formats acceptés: JPG, PNG, PDF (max 5MB)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Section 6: Statut -->
        <div class=\"form-section\">
            <div class=\"form-section-title\">
                <i class=\"bi bi-check-circle\"></i>
                <span>6. Statut</span>
            </div>
            <div class=\"row\">
                <div class=\"col-md-6\">
                    <div class=\"form-group\">
                        {{ form_label(form.statut, null, {'label_attr': {'class': 'form-label'}}) }}
                        {{ form_widget(form.statut, {'attr': {'class': 'form-select'}}) }}
                        {{ form_errors(form.statut) }}
                    </div>
                </div>
                    <div class=\"col-md-6\">
                        <div class=\"form-group\">
                            <label class=\"form-label\" for=\"quantite\">Quantité à créer <span class=\"text-muted\">(nombre de produits distincts)</span></label>
                            <input type=\"number\" 
                                   id=\"quantite\" 
                                   name=\"quantite\" 
                                   class=\"form-control\" 
                                   min=\"1\" 
                                   value=\"1\" 
                                   required>
                            <small class=\"form-text text-muted\">
                                <i class=\"bi bi-info-circle\"></i> 
                                Si vous mettez \"2\", le système créera 2 produits distincts avec des codes-barres différents.
                            </small>
                        </div>
                    </div>
            </div>
        </div>

        <!-- Champ caché pour stocker les valeurs des caractéristiques -->
        <input type=\"hidden\" name=\"caracteristiques_valeurs\" id=\"caracteristiques_valeurs\" value=\"{}\">

        <div class=\"form-actions\">
            <button type=\"submit\" class=\"btn-submit\">
                <i class=\"bi bi-check-circle-fill\"></i>
                <span>Créer le produit</span>
            </button>
            <a href=\"{{ path('produits_index') }}\" class=\"btn-cancel\">
                <span>Annuler</span>
            </a>
        </div>
        {{ form_end(form) }}
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const categorieSelect = document.querySelector('[data-produit-categorie]');
    const sousCategorieSelect = document.querySelector('[data-produit-sous-categorie]');
    const caracteristiquesContainer = document.getElementById('caracteristiques-container');
    const caracteristiquesSection = document.getElementById('caracteristiques-section');
    const caracteristiquesValeursInput = document.getElementById('caracteristiques_valeurs');
    const prixAchatInput = document.querySelector('[data-prix-achat]');
    const margeMinimaleInput = document.querySelector('[data-marge-minimale]');
    const prixVenteRecommandéInput = document.querySelector('[data-prix-vente-recommande]');
    const origineAchatSelect = document.querySelector('[data-origine-achat]');
    const fournisseurField = document.getElementById('fournisseur-field');
    const particulierFields = document.getElementById('particulier-fields');

    let caracteristiquesValeurs = {};

    // Charger les sous-catégories quand la catégorie change
    if (categorieSelect) {
        categorieSelect.addEventListener('change', function() {
            const categorieId = this.value;
            if (categorieId) {
                sousCategorieSelect.innerHTML = '<option value=\"\">Chargement...</option>';
                sousCategorieSelect.disabled = true;
                
                const url = `/produits/api/sous-categories/\${categorieId}`;
                fetch(url, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin'
                })
                    .then(async response => {
                        const contentType = response.headers.get('content-type');
                        if (!contentType || !contentType.includes('application/json')) {
                            const text = await response.text();
                            console.error('Réponse non-JSON reçue:', text.substring(0, 200));
                            throw new Error('Le serveur a retourné une réponse invalide. Vérifiez que vous êtes bien connecté.');
                        }
                        
                        if (!response.ok) {
                            const err = await response.json();
                            throw new Error(err.error || 'Erreur lors du chargement');
                        }
                        return response.json();
                    })
                    .then(data => {
                        sousCategorieSelect.innerHTML = '<option value=\"\">Sélectionnez une sous-catégorie</option>';
                        if (Array.isArray(data) && data.length > 0) {
                            data.forEach(sousCategorie => {
                                const option = document.createElement('option');
                                option.value = sousCategorie.id;
                                option.textContent = sousCategorie.nom;
                                sousCategorieSelect.appendChild(option);
                            });
                        } else {
                            sousCategorieSelect.innerHTML = '<option value=\"\">Aucune sous-catégorie disponible</option>';
                        }
                        sousCategorieSelect.disabled = false;
                        caracteristiquesContainer.innerHTML = '';
                        caracteristiquesSection.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        sousCategorieSelect.innerHTML = '<option value=\"\">Erreur: ' + error.message + '</option>';
                        sousCategorieSelect.disabled = false;
                    });
            } else {
                sousCategorieSelect.innerHTML = '<option value=\"\">Sélectionnez d\\'abord une catégorie</option>';
                sousCategorieSelect.disabled = true;
                caracteristiquesContainer.innerHTML = '';
                caracteristiquesSection.style.display = 'none';
            }
        });
    }

    // Charger les caractéristiques quand la sous-catégorie change
    if (sousCategorieSelect) {
        sousCategorieSelect.addEventListener('change', function() {
            const sousCategorieId = this.value;
            if (sousCategorieId) {
                caracteristiquesContainer.innerHTML = '<div style=\"text-align: center; padding: 2rem; color: var(--text-secondary);\">Chargement des caractéristiques...</div>';
                caracteristiquesSection.style.display = 'block';
                
                const url = `/produits/api/caracteristiques/\${sousCategorieId}`;
                fetch(url, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    credentials: 'same-origin'
                })
                    .then(async response => {
                        const contentType = response.headers.get('content-type');
                        if (!contentType || !contentType.includes('application/json')) {
                            const text = await response.text();
                            console.error('Réponse non-JSON reçue:', text.substring(0, 200));
                            throw new Error('Le serveur a retourné une réponse invalide. Vérifiez que vous êtes bien connecté.');
                        }
                        
                        if (!response.ok) {
                            const err = await response.json();
                            throw new Error(err.error || 'Erreur lors du chargement');
                        }
                        return response.json();
                    })
                    .then(data => {
                        caracteristiquesContainer.innerHTML = '';
                        caracteristiquesValeurs = {};
                        
                        if (data.length > 0) {
                            caracteristiquesSection.style.display = 'block';
                            data.forEach(caracteristique => {
                                const fieldDiv = document.createElement('div');
                                fieldDiv.className = 'caracteristique-field';
                                
                                const label = document.createElement('label');
                                label.className = 'caracteristique-label';
                                label.textContent = caracteristique.nom;
                                if (caracteristique.obligatoire) {
                                    label.innerHTML += ' <span class=\"required\">*</span>';
                                }
                                
                                fieldDiv.appendChild(label);
                                
                                let input;
                                if (caracteristique.type === 'text') {
                                    input = document.createElement('input');
                                    input.type = 'text';
                                    input.className = 'form-control';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('input', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'number') {
                                    input = document.createElement('input');
                                    input.type = 'number';
                                    input.className = 'form-control';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.step = 'any';
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('input', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'boolean') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.innerHTML = '<option value=\"\">--</option><option value=\"true\">Oui</option><option value=\"false\">Non</option>';
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'select') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}`;
                                    input.innerHTML = '<option value=\"\">--</option>';
                                    caracteristique.valeursPossibles.forEach(valeur => {
                                        const option = document.createElement('option');
                                        option.value = valeur;
                                        option.textContent = valeur;
                                        input.appendChild(option);
                                    });
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                } else if (caracteristique.type === 'multi-select') {
                                    input = document.createElement('select');
                                    input.className = 'form-select';
                                    input.name = `caracteristique_\${caracteristique.id}[]`;
                                    input.multiple = true;
                                    input.innerHTML = '';
                                    caracteristique.valeursPossibles.forEach(valeur => {
                                        const option = document.createElement('option');
                                        option.value = valeur;
                                        option.textContent = valeur;
                                        input.appendChild(option);
                                    });
                                    input.required = caracteristique.obligatoire;
                                    input.addEventListener('change', mettreAJourNomProduit);
                                }
                                
                                input.addEventListener('change', function() {
                                    if (caracteristique.type === 'multi-select') {
                                        caracteristiquesValeurs[caracteristique.id] = Array.from(this.selectedOptions).map(opt => opt.value);
                                    } else {
                                        caracteristiquesValeurs[caracteristique.id] = this.value;
                                    }
                                    caracteristiquesValeursInput.value = JSON.stringify(caracteristiquesValeurs);
                                    mettreAJourNomProduit();
                                });
                                
                                fieldDiv.appendChild(input);
                                caracteristiquesContainer.appendChild(fieldDiv);
                            });
                            
                            // Mettre à jour le nom après chargement des caractéristiques
                            mettreAJourNomProduit();
                        } else {
                            caracteristiquesSection.style.display = 'none';
                            mettreAJourNomProduit();
                        }
                    });
            } else {
                caracteristiquesContainer.innerHTML = '';
                caracteristiquesSection.style.display = 'none';
            }
        });
    }

    // Calculer le prix de vente recommandé
    function calculerPrixVenteRecommandé() {
        const prixAchat = parseFloat(prixAchatInput?.value.replace(/[^\\d,.-]/g, '').replace(',', '.') || 0);
        const margeMinimale = parseFloat(margeMinimaleInput?.value.replace(/[^\\d,.-]/g, '').replace(',', '.') || 0);
        
        if (prixAchat > 0 && margeMinimale >= 0) {
            const prixRecommandé = prixAchat + margeMinimale;
            if (prixVenteRecommandéInput) {
                prixVenteRecommandéInput.value = prixRecommandé.toFixed(2).replace('.', ',') + ' MAD';
            }
        }
    }

    if (prixAchatInput) {
        prixAchatInput.addEventListener('input', calculerPrixVenteRecommandé);
    }
    if (margeMinimaleInput) {
        margeMinimaleInput.addEventListener('input', calculerPrixVenteRecommandé);
    }

    // Gérer l'affichage des champs selon l'origine d'achat
    const fournisseurPaiementFields = document.getElementById('fournisseur-paiement-fields');
    const creerAchatCheckbox = document.getElementById('creer_achat');
    const paiementFields = document.getElementById('paiement-fields');
    
    if (origineAchatSelect) {
        // Initialiser l'affichage au chargement de la page
        function toggleOrigineAchatFields() {
            const origineAchat = origineAchatSelect.value;
            if (origineAchat === 'particulier') {
                if (fournisseurField) fournisseurField.style.display = 'none';
                if (fournisseurPaiementFields) fournisseurPaiementFields.style.display = 'none';
                if (particulierFields) {
                    particulierFields.style.display = 'block';
                    // Rendre les champs obligatoires visibles
                    particulierFields.querySelectorAll('input[required], textarea[required]').forEach(field => {
                        field.required = true;
                    });
                }
            } else {
                if (fournisseurField) fournisseurField.style.display = 'block';
                if (fournisseurPaiementFields) fournisseurPaiementFields.style.display = 'block';
                if (particulierFields) {
                    particulierFields.style.display = 'none';
                    // Désactiver les champs obligatoires quand cachés
                    particulierFields.querySelectorAll('input[required], textarea[required]').forEach(field => {
                        field.required = false;
                    });
                }
            }
        }
        
        // Appliquer au chargement
        toggleOrigineAchatFields();
        
        // Écouter les changements
        origineAchatSelect.addEventListener('change', toggleOrigineAchatFields);
    }
    
    // Gérer l'affichage des champs de paiement
    if (creerAchatCheckbox) {
        creerAchatCheckbox.addEventListener('change', function() {
            if (paiementFields) {
                paiementFields.style.display = this.checked ? 'block' : 'none';
            }
        });
    }

    // Fonction pour mettre à jour le nom du produit en temps réel
    function mettreAJourNomProduit() {
        const sousCategorieSelect = document.querySelector('[data-produit-sous-categorie]');
        const nomPreview = document.getElementById('produit-nom-preview');
        const nomHidden = document.querySelector('[name=\"produit[nom]\"]');
        
        if (!sousCategorieSelect || !sousCategorieSelect.value) {
            if (nomPreview) nomPreview.value = '';
            if (nomHidden) nomHidden.value = '';
            return;
        }
        
        const sousCategorieNom = sousCategorieSelect.options[sousCategorieSelect.selectedIndex].text;
        let nom = sousCategorieNom;
        
        // Récupérer les valeurs des caractéristiques
        const valeurs = [];
        caracteristiquesContainer.querySelectorAll('[name^=\"caracteristique_\"]').forEach(input => {
            if (input.type === 'checkbox') {
                if (input.checked) {
                    valeurs.push(input.value);
                }
            } else if (input.tagName === 'SELECT') {
                if (input.multiple) {
                    // Multi-select
                    Array.from(input.selectedOptions).forEach(opt => {
                        if (opt.value) valeurs.push(opt.textContent);
                    });
                } else {
                    // Select simple
                    if (input.value && input.value !== '' && input.value !== 'true' && input.value !== 'false') {
                        valeurs.push(input.options[input.selectedIndex].textContent);
                    }
                }
            } else {
                // Input text, number, etc.
                if (input.value && input.value.trim() !== '' && input.value !== 'true' && input.value !== 'false') {
                    valeurs.push(input.value);
                }
            }
        });
        
        if (valeurs.length > 0) {
            nom += ' - ' + valeurs.slice(0, 5).join(' / '); // Limiter à 5 valeurs
        }
        
        if (nomPreview) nomPreview.value = nom;
        if (nomHidden) nomHidden.value = nom;
    }
    
    // Écouter les changements de sous-catégorie
    if (sousCategorieSelect) {
        sousCategorieSelect.addEventListener('change', mettreAJourNomProduit);
    }

    // Collecter les valeurs des caractéristiques avant soumission
    const form = document.getElementById('produit-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const caracteristiques = {};
            caracteristiquesContainer.querySelectorAll('[name^=\"caracteristique_\"]').forEach(input => {
                const caracteristiqueId = input.name.match(/caracteristique_(\\d+)/)?.[1];
                if (caracteristiqueId) {
                    if (input.type === 'checkbox') {
                        if (!caracteristiques[caracteristiqueId]) {
                            caracteristiques[caracteristiqueId] = [];
                        }
                        if (input.checked) {
                            caracteristiques[caracteristiqueId].push(input.value);
                        }
                    } else if (input.tagName === 'SELECT' && input.multiple) {
                        caracteristiques[caracteristiqueId] = Array.from(input.selectedOptions).map(opt => opt.value);
                    } else {
                        if (input.value && input.value !== '' && input.value !== 'true' && input.value !== 'false') {
                            caracteristiques[caracteristiqueId] = input.value;
                        }
                    }
                }
            });
            caracteristiquesValeursInput.value = JSON.stringify(caracteristiques);
            
            // S'assurer que le nom est bien défini
            mettreAJourNomProduit();
        });
    }

    // Générer le code-barres visuel
    const codeBarresDisplay = document.getElementById('code-barres-display');
    const barcodePreview = document.getElementById('barcode-preview');
    const barcodeSvg = document.getElementById('barcode-svg');
    
    if (codeBarresDisplay && codeBarresDisplay.value && barcodeSvg && typeof JsBarcode !== 'undefined') {
        try {
            JsBarcode(barcodeSvg, codeBarresDisplay.value, {
                format: \"EAN13\",
                width: 2,
                height: 60,
                displayValue: true,
                fontSize: 14,
                margin: 10
            });
            if (barcodePreview) {
                barcodePreview.style.display = 'block';
            }
        } catch (e) {
            console.error('Erreur génération code-barres:', e);
        }
    }
});
</script>
{% endblock %}
", "produit/new.html.twig", "/var/www/html/templates/produit/new.html.twig");
    }
}
