<?php

namespace App\Repository;

use App\Entity\Achat;
use App\Entity\Magasin;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class AchatRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Achat::class);
    }

    public function findAchatsByMagasinAndDate(Magasin $magasin, \DateTime $dateDebut, \DateTime $dateFin): array
    {
        return $this->createQueryBuilder('a')
            ->where('a.magasin = :magasin')
            ->andWhere('a.dateAchat BETWEEN :dateDebut AND :dateFin')
            ->setParameter('magasin', $magasin)
            ->setParameter('dateDebut', $dateDebut)
            ->setParameter('dateFin', $dateFin)
            ->orderBy('a.dateAchat', 'DESC')
            ->getQuery()
            ->getResult();
    }
}

