<?php

namespace App\Form;

use App\Entity\LigneVente;
use App\Entity\Produit;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class LigneVenteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $magasin = $options['magasin'] ?? null;

        $builder
            ->add('produit', EntityType::class, [
                'class' => Produit::class,
                'choice_label' => function(Produit $produit) {
                    return $produit->getNom() . ' (Stock: ' . $produit->getQuantite() . ')';
                },
                'query_builder' => function($er) use ($magasin) {
                    return $er->createQueryBuilder('p')
                        ->where('p.magasin = :magasin')
                        ->andWhere('p.actif = true')
                        ->andWhere('p.quantite > 0')
                        ->setParameter('magasin', $magasin)
                        ->orderBy('p.nom', 'ASC');
                },
            ])
            ->add('quantite', IntegerType::class, ['attr' => ['min' => 1]])
            ->add('prixUnitaire', MoneyType::class, [
                'currency' => 'EUR',
                'scale' => 2,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => LigneVente::class,
            'magasin' => null,
        ]);
    }
}

