<?php

namespace App\Command;

use App\Entity\User;
use App\Entity\Magasin;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

#[AsCommand(
    name: 'app:create-admin',
    description: 'Créer un utilisateur admin et un magasin de démo',
)]
class CreateAdminCommand extends Command
{
    public function __construct(
        private EntityManagerInterface $em,
        private UserPasswordHasherInterface $passwordHasher
    ) {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);

        // Créer un magasin de démo
        $magasin = new Magasin();
        $magasin->setNom('Magasin Principal');
        $magasin->setAdresse('123 Rue de la Démo');
        $magasin->setVille('Paris');
        $magasin->setEmail('contact@magasin-demo.fr');
        $magasin->setTelephone('0123456789');
        $this->em->persist($magasin);

        // Créer un admin
        $admin = new User();
        $admin->setEmail('admin@example.com');
        $admin->setNom('Admin');
        $admin->setPrenom('Super');
        $admin->setMagasin($magasin);
        $admin->setRoles(['ROLE_ADMIN']);
        $admin->setPassword($this->passwordHasher->hashPassword($admin, 'admin123'));

        $this->em->persist($admin);
        $this->em->flush();

        $io->success('Admin créé avec succès!');
        $io->note('Email: admin@example.com');
        $io->note('Mot de passe: admin123');

        return Command::SUCCESS;
    }
}

